/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal;

import amf.internal.environment.Environment;
import com.mulesoft.apiquery.GraphQLEngine;
import com.mulesoft.apiquery.adapter.internal.GraphqladapterConfiguration;
import com.mulesoft.apiquery.adapter.internal.engine.libconfig.LibConfigBuilder;
import com.mulesoft.apiquery.adapter.internal.engine.specification.GraphqladapterConfigurationBuilder;
import com.mulesoft.apiquery.adapter.internal.utils.Paths;
import com.mulesoft.apiquery.adapter.internal.utils.Zip;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.json.JSONObject;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

public class GraphqladapterOperations {
    static GraphQLEngine engine = null;

    @MediaType(value="application/json", strict=true)
    public void graphqlExecute(@Content(primary=true) String graphQLQuery, Map<String, String> headers, Map<String, String> queryParams, CompletionCallback<String, Void> callback) {
        try {
            this.executeyAsync(engine.executeJvm(graphQLQuery, queryParams, headers), callback);
        }
        catch (Exception e) {
            callback.error((Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=true)
    public void graphqlEvaluate(@Content(primary=true) String graphQLQuery, CompletionCallback<String, Void> callback) {
        try {
            this.executeyAsync(engine.evaluateJvm(graphQLQuery), callback);
        }
        catch (Exception e) {
            callback.error((Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=true)
    public void graphqlLoadConfig(@Config GraphqladapterConfiguration config, CompletionCallback<String, Void> callback) {
        try {
            engine = new GraphQLEngine(config.getApiSpec(), config.getApiVendor(), config.getApiFormat(), Environment.apply(), LibConfigBuilder.create());
            callback.success(Result.builder().output((Object)"configured").build());
        }
        catch (Exception e) {
            callback.error((Throwable)e);
        }
    }

    @MediaType(value="application/json")
    public void graphqlLoadFromZip(String apiSpec, CompletionCallback<String, Void> callback) {
        try {
            File projectDir = new File(Paths.projectPath);
            if (projectDir.exists()) {
                FileUtils.deleteDirectory((File)projectDir);
            }
            if (projectDir.mkdir()) {
                Zip zip = new Zip(apiSpec);
                zip.extractAll(Paths.projectPath);
                String exchangeFile = FileUtils.readFileToString((File)new File(Paths.projectPath + "exchange.json"), (String)"UTF-8");
                JSONObject exchangeObj = new JSONObject(exchangeFile);
                String mainFileName = exchangeObj.getString("main");
                String mainFile = FileUtils.readFileToString((File)new File(Paths.projectPath + mainFileName), (String)"UTF-8");
                String classifier = exchangeObj.getString("classifier");
                String extension = FilenameUtils.getExtension((String)mainFileName);
                GraphqladapterConfiguration config = GraphqladapterConfigurationBuilder.create(classifier, extension, mainFile);
                config.setApiSpec("file://" + Paths.projectPath + mainFileName);
                engine = new GraphQLEngine(config.getApiSpec(), config.getApiVendor(), config.getApiFormat(), Environment.apply(), LibConfigBuilder.create());
                callback.success(Result.builder().output((Object)"configured").build());
            } else {
                callback.error((Throwable)new InternalError("Project Directory not found"));
            }
        }
        catch (Exception e) {
            callback.error((Throwable)e);
        }
    }

    @MediaType(value="application/json")
    public void graphqlIsConfigured(CompletionCallback<String, Void> callback) {
        boolean isConfig = engine != null;
        Result result = Result.builder().output((Object)String.valueOf(isConfig)).build();
        callback.success(result);
    }

    @MediaType(value="text/plain")
    public void graphqlDefinition(CompletionCallback<String, Void> callback) {
        try {
            this.executeyAsync(engine.definition(), callback);
        }
        catch (Exception e) {
            callback.error((Throwable)e);
        }
    }

    private void executeyAsync(CompletionStage<Optional<String>> execution, CompletionCallback<String, Void> callback) {
        execution.handle((r, ex) -> {
            if (ex != null) {
                return Either.left((Object)ex);
            }
            return Either.right((Object)r);
        }).thenAccept(optionalResult -> {
            if (optionalResult.isLeft()) {
                callback.error((Throwable)optionalResult.getLeft());
            } else if (((Optional)optionalResult.getRight()).isPresent()) {
                Result output = Result.builder().output(((Optional)optionalResult.getRight()).get()).build();
                callback.success(output);
            } else {
                Result output = Result.builder().output((Object)"null").build();
                callback.success(output);
            }
        });
    }
}

