/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal.engine.specification.oas;

import com.mulesoft.apiquery.adapter.internal.GraphqladapterConfiguration;
import com.mulesoft.apiquery.adapter.internal.engine.specification.SpecConfig;
import com.mulesoft.apiquery.adapter.internal.utils.SemanticVersion;
import java.util.HashMap;
import org.json.JSONObject;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class OasConfigBuilder
implements SpecConfig {
    private static final String SWAGGER = "swagger";
    private static final String OPENAPI = "openapi";
    private String extension;

    public OasConfigBuilder(String extension) {
        this.extension = extension;
    }

    @Override
    public GraphqladapterConfiguration create(String spec) {
        GraphqladapterConfiguration config = new GraphqladapterConfiguration();
        String version = SemanticVersion.removePatch(this.getVersion(spec));
        config.setApiVendor("OAS " + version);
        config.setApiFormat("application/" + this.extension);
        return config;
    }

    private String getVersion(String spec) {
        if (this.extension.equals("json")) {
            return this.getVersionFromJson(spec);
        }
        if (this.extension.equals("yaml")) {
            return this.getVersionFromYaml(spec);
        }
        throw new IllegalArgumentException("Unknown specification extension ");
    }

    private String getVersionFromJson(String spec) {
        JSONObject jsonSpec = new JSONObject(spec);
        String versionTag = jsonSpec.has(SWAGGER) ? SWAGGER : OPENAPI;
        return jsonSpec.getString(versionTag);
    }

    private String getVersionFromYaml(String spec) {
        DumperOptions options = new DumperOptions();
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.SINGLE_QUOTED);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        HashMap specMap = (HashMap)yaml.load(spec);
        return specMap.get(SWAGGER).toString();
    }
}

