/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal.engine.specification.raml;

import com.mulesoft.apiquery.adapter.internal.GraphqladapterConfiguration;
import com.mulesoft.apiquery.adapter.internal.engine.specification.SpecConfig;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.runtime.soap.api.exception.BadRequestException;

public class RamlConfigBuilder
implements SpecConfig {
    private static String REGEX = "#%RAML (\\d\\.\\d)(.|\\n)*";

    @Override
    public GraphqladapterConfiguration create(String spec) {
        GraphqladapterConfiguration config = new GraphqladapterConfiguration();
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(spec.substring(0, Math.min(spec.length(), 1000)));
        if (!matcher.find()) {
            throw new BadRequestException("Vendor not found");
        }
        String vendorBuilder = "RAML " + matcher.group(1);
        config.setApiVendor(vendorBuilder);
        config.setApiFormat("application/raml");
        return config;
    }
}

