ns bat http://mulesoft.com/ns/bat

type BATPassCapable<T> = {
  kind: String,
  name: String,
  pass: Boolean,
  softFail?: Boolean,
  result: T,
  skip?: Boolean,
  prefix?: String,
  metadata?: {_?: Any},
  startDate?: Date | DateTime | LocalDateTime,
  time?: Number,
  parameters?: { _?: Any }
}

type BATTest = BATPassCapable<Array<BATPassCapable<Any>>> & {
  fileName?: String
} { class: 'com.mulesoft.bat.dw.dao.BATTestResult' }

type BATHttpStep = BATPassCapable<dw::http::Types::HttpClientResult> & {assertions: Array<BATAssertion>}

type BATCustomStep = BATPassCapable<Any>
type BATAssertion = BATPassCapable<Any>

type BATSecret = {
  name: String,
  env: String,
  group: String,
  secretId: String,
  grant: String,
  secret: String | Null
}
