%dw 2.0
output text/plain

import * from bat::Types
import DEBUG from bat::core::Console
import sanitizeName from bat::core::Helpers
import * from dw::http::Client

ns bat http://mulesoft.com/ns/bat

var testIdSplit = (payload.metadata.testId default '') splitBy ":"

var packageName = (testIdSplit[0] default '') ++ ':' ++ (testIdSplit[1] default '')

fun mails() =
  if(options != null and options.EMAILS?)
    options.EMAILS replace " " with "" replace "," with "\", \"" replace ";" with "\", \""
  else
    log('Missing EMAILS option', '')

fun subject(payload) = "Functional Monitoring Alert: " ++ payload.name ++ " failed."

fun matching(result) = result.kind match {
    case "TEST" -> flatten(result.result)
    case "LOOPABLE" -> flatten(result.result)
    case "SUITE" -> flatten(result.result)
    case "HTTP" -> [result]
    else -> []
}

fun processAssertions(assertions) = do {
    assertions filter not $.pass map ("- " ++ $.name ++ " `( " ++ (reason($.result, $.kind)) ++ " )`")
}
fun flatten(results) = do {
    (results flatMap ((item, index) -> (matching(item)) filter not $.pass))
}

fun reason(r, kind) = do {
    kind match {
        case "Assertion" ->
            r.kind match {
                case "Assertion::Equal" -> r.givenValue ++ " was not equal to " ++ r.expectedValue
                case "Assertion::Matcher" -> r.givenValue ++ " does not match " ++ r.expectedValue
                case "Assertion::Similar" -> r.givenValue ++ " is not similar to " ++ r.expectedValue
                else  -> "Assertion failed "
            }
        case "RuntimeException" -> "Exception: " ++ r.message
        else -> "Assertion failed"
    }
}

fun content(payload) = (flatten (payload.result)  map ("The following assertions for `" ++ $.name ++ " have failed: " ++ ( processAssertions($.assertions)  reduce ($$ ++ "\n\t\t" ++$))))[0]

fun getOrganizationId() = payload.metadata.organizationId default ''

fun getUrlBase() = native("email::GetEndpointMail")

fun endpoint(): String = getUrlBase() ++ "/v1/organizations/" ++ getOrganizationId() ++ "/messages"

fun process(payload): String = "[\n    {\n        \"payload\": {\n            \"channel\": \"email\",\n            \"layout\": \"default\",\n            \"to\": {\n                \"emails\": [\n                    \""++ mails() ++ "\"\n                ]\n            },\n            \"subject\": \""++ subject(payload) ++ "\",\n            \"content\": \""++ content(payload) ++ " .\"\n        },\n        \"vars\": {\n            \"serverName\": \"bat-monitoring\",\n            \"userName\": \"batmonitoring\"\n        }\n    }\n]"

fun getHeaders() = if(context != null and context.token != null and context.token != '') {
       'Content-Type': 'application/json',
       'Authorization': 'Bearer ' ++ log(context.token)
     } else {
        'Content-Type': 'application/json'
     }

---
if (DEBUG or endpoint() == '' or mails() == '' or getOrganizationId == '' or payload.pass != false)
    process(payload)
else
  (request('POST', endpoint(), {
     body: (process(payload) as Binary),
     headers: getHeaders()
  }) write 'application/json')