%dw 2.0
output text/plain

import * from bat::Types
import DEBUG from bat::core::Console
import sanitizeName from bat::core::Helpers
import * from dw::http::Client
import envVar from dw::System
import prop from dw::Runtime

ns bat http://mulesoft.com/ns/bat

var testIdSplit = (payload.metadata.testId default '') splitBy ":"

var packageName = (testIdSplit[0] default '') ++ ':' ++ (testIdSplit[1] default '')

var TARGET_SECRET_ENV = (envVar('targetSecret'))
var TARGET_SECRET_PROP = (prop('targetSecret'))

fun mails() =
  if(options != null and options.EMAILS?)
    options.EMAILS replace " " with "" replace "," with "\", \"" replace ";" with "\", \""
  else
    log('Missing EMAILS option', '')

fun subject(payload) = "Functional Monitoring Alert: " ++ payload.name ++ " failed."

fun matching(result) = result.kind match {
    case "TEST" -> flatten(result.result)
    case "LOOPABLE" -> flatten(result.result)
    case "SUITE" -> flatten(result.result)
    case "HTTP" -> [result]
    else -> []
}

fun processAssertions(assertions) = do {
    assertions filter not $.pass map ("<tr><td><ul style=\\\"list-style-type: circle;\\\"><li>" ++ $.name ++ " ( " ++ (reason($.result, $.kind)) ++ " )</li></ul></td></tr>")
}
fun flatten(results) = do {
    (results flatMap ((item, index) -> (matching(item)) filter not $.pass))
}

fun reason(r, kind) = do {
    kind match {
        case "Assertion" ->
            r.kind match {
                case "Assertion::Equal" -> r.givenValue ++ " was not equal to " ++ r.expectedValue
                case "Assertion::Matcher" -> r.givenValue ++ " does not match " ++ r.expectedValue
                case "Assertion::Similar" -> r.givenValue ++ " is not similar to " ++ r.expectedValue
                else  -> "Assertion failed "
            }
        case "RuntimeException" -> "Exception: " ++ r.message
        else -> "Assertion failed"
    }
}

fun content(payload) = (flatten (payload.result)  map ("<div style=\\\"text-align:center;\\\"><table border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"20\\\" width=\\\"100%\\\" align=\\\"center\\\"  style=\\\"margin: 0 auto;\\\"><tbody><tr><td><h2><b>" ++ payload.name ++ "</b></h2> <br/></td></tr></tbody></table></div><div><table border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"20\\\" width=\\\"100%\\\" align=\\\"center\\\"><tbody><tr><td><h3>The following assertions for " ++ $.name ++ " have failed: </h3></td></tr>" ++ ( processAssertions($.assertions)  reduce ($$ ++ "" ++$))))[0] ++ "</tbody></table></div>"

fun getOrganizationId() = payload.metadata.organizationId default ''

fun getTargetId() = payload.metadata.targetId default ''

fun getTargetSecret() =  if(TARGET_SECRET_ENV != null) TARGET_SECRET_ENV
                         else if (TARGET_SECRET_PROP != null) TARGET_SECRET_PROP
                         else ''

fun getUrlBase() = native("email::GetEndpointMail")

fun endpoint(): String = getUrlBase() ++ "/v1/organizations/" ++ getOrganizationId() ++ "/messages"

fun process(payload): String = "[    {        \"payload\": {            \"channel\": \"email\",            \"layout\": \"default\",           \"to\": {                \"emails\": [                    \""++ mails() ++ "\"                ]            },            \"subject\": \""++ subject(payload) ++ "\",            \"content\": \""++ content(payload) ++ "\"       },      \"vars\": {            \"serverName\": \"bat-monitoring\",            \"userName\": \"batmonitoring\"        }    }]"

fun getHeaders() = {
       'Content-Type': 'application/json',
       'X-TARGET-ID': getTargetId(),
       'X-TARGET-SECRET': getTargetSecret()
     }
---
if (DEBUG or endpoint() == '' or mails() == '' or getOrganizationId == '' or payload.pass != false)
    process(payload)
else
  (request('POST', endpoint(), {
     body: (process(payload) as Binary),
     headers: getHeaders()
  }) write 'application/json')
