%dw 2.0
output aplication/json

import * from bat::Types
import DEBUG from bat::core::Console
import sanitizeName from bat::core::Helpers
import * from dw::http::Client
import envVar from dw::System
import prop from dw::Runtime

ns bat http://mulesoft.com/ns/bat

var testIdSplit = (payload.metadata.testId default '') splitBy ":"

var packageName = (testIdSplit[0] default '') ++ ':' ++ (testIdSplit[1] default '')

var TARGET_SECRET_ENV = (envVar('targetSecret'))
var TARGET_SECRET_PROP = (prop('targetSecret'))

fun mails(): Array<String> =
  if(options != null and options.EMAILS?)
    do {
    var emails: String = options.EMAILS default ''
    ---
        if(emails contains(","))
            emails splitBy(",")
        else if(emails contains(";"))
            emails splitBy(";")
        else
            [emails]
    }
  else
    log('Missing EMAILS option', [""])

fun subject(payload) = "Functional Monitoring Alert: " ++ payload.name ++ " failed."

fun contentSummary(payload) = "Functional Monitor: " ++ payload.name ++ " has failed."

fun matching(result) = result.kind match {
    case "TEST" -> flatten(result.result)
    case "LOOPABLE" -> flatten(result.result)
    case "SUITE" -> flatten(result.result)
    case "HTTP" -> [result]
    else -> []
}

fun processAssertions(results) = do {
    flatten(results) flatMap ( (result, index) ->
            result.assertions map (assertion, assertionIndex) -> {
                span @(style: bullet(assertion.pass)): '',
                span: result.name ++ " ( " ++ (reason(assertion , assertion.kind)) ++ ")"
                }
        )
}

fun flatten(results) = do {
    results flatMap ((item, index) -> (matching(item)))
}

fun reason(assertion, kind): String = do {
    kind match {
        case "Assertion" -> assertion.name default "Assertion Failed"
        case "RuntimeException" -> "Exception: " ++ assertion.message
        else -> "Assertion failed"
    } default "Assertion Failed"
}


fun process(payload) = [
                          {
                            payload: {
                              channel: "email",
                              layout: "default",
                              to: {
                                emails: mails()
                              },
                                subject: subject(payload),
                                content: write(getHtml(payload), "text/xml"),
                            },
                            vars: {
                              serverName: "bat-monitoring",
                              userName: "bat"
                            }
                          }
                        ]

fun bullet(pass: Boolean) = do {
    var color = if (pass) "#6cc644" else "#E3174A"
    ---
    "display: inline-block; width: 9px; height: 9px; border-radius: 1em; background: $(color); vertical-align: baseline; margin: 5px 5px;"
}

fun assertionsContainer() = `
                                display: flex;
                                flex-direction: row;
                                align-items: center;
                             `
fun strong() = 'font-weight:bold'

fun getHtml(payload) =     div @(id: 'main-content'): {
                              div @(class:"blankslate blankslate-narrow", style: 'margin: 15px'): {
                                span @(style: 'font-size: 20px;font-weight: 300;color: #555;' ++ strong()): contentSummary(payload),
                                br: null,
                                span @(style:  strong()): "Some assertions have failed:",
                                br: null,
                                div @(style: assertionsContainer()):  processAssertions(payload.result)
                              }
                            }

fun getOrganizationId() = payload.metadata.organizationId default ''

fun getTargetId() = payload.metadata.targetId default ''

fun getTargetSecret() =  if(TARGET_SECRET_ENV != null) TARGET_SECRET_ENV
                         else if (TARGET_SECRET_PROP != null) TARGET_SECRET_PROP
                         else ''

fun getUrlBase() = native("email::GetEndpointMail")

fun endpoint(): String = getUrlBase() ++ "/v1/organizations/" ++ getOrganizationId() ++ "/messages"

fun getHeaders() = {
       'Content-Type' : 'application/json',
       'X-TARGET-ID': getTargetId(),
       'X-TARGET-SECRET': getTargetSecret()
     }
---
if (DEBUG or endpoint() == '' or mails() == [''] or getOrganizationId == '' or payload.pass != false)
    process(payload)
else
  (request('POST', endpoint(), {
     body: (process(payload) as Binary),
     headers: getHeaders()
  }) write 'application/json')
