ns bat http://mulesoft.com/ns/bat

type BATPassCapable<T> = {
  kind: String,
  name: String,
  pass: Boolean,
  softFail?: Boolean,
  result: T,
  skip?: Boolean,
  prefix?: String,
  metadata?: {_?: Any},
  startDate?: Date | DateTime | LocalDateTime,
  time?: Number,
  parameters?: { _?: Any }
}

type BATTest = {
    kind: String,
    name: String,
    pass: Boolean,
    softFail?: Boolean,
    result: Array<BATPassCapable<Any>>,
    skip?: Boolean,
    prefix?: String,
    metadata?: {_?: Any},
    startDate?: Date | DateTime | LocalDateTime,
    time?: Number,
    parameters?: { _?: Any },

    fileName?: String | Null
} { class: 'com.mulesoft.bat.dw.dao.BATTestResult' }

type BATHttpStep = {
    kind: String,
    name: String,
    pass: Boolean,
    result: dw::http::Types::HttpClientResult,
    softFail?: Boolean,
    skip?: Boolean,
    prefix?: String,
    metadata?: {_?: Any},
    startDate?: Date | DateTime | LocalDateTime,
    time: Number,
    parameters?: { _?: Any },

    assertions: Array<BATAssertion>,
    time?: Number
}

type BATCustomStep = BATPassCapable<Any>
type BATAssertion = BATPassCapable<Any>

type BATSecret = {
  name: String,
  env: String,
  group: String,
  secretId: String,
  grant: String,
  secret: String | Null
}
