%dw 2.0
output application/json

import * from bat::Types
import DEBUG from bat::core::Console
import * from dw::http::Client
import * from dw::Runtime
import * from bat::Reporters::Common

var atHereEnabled = getBooleanProperty(options, "AT_HERE_ENABLED")
var disabled = isDisabled(options, context)
var sendNotification = sendNotificationIfPassed(options)

fun webHook() = getReporterProperty(options, "SLACK_WEBHOOK")

fun matching(result) = result.kind match {
    case "TEST" -> flatten(result.result)
    case "LOOPABLE" -> flatten(result.result)
    case "SUITE" -> flatten(result.result)
    case "HTTP" -> [result]
    else -> []
}

fun processHttp(http) = do {
    http.name
}
fun flatten(results) = do {
    (results flatMap ((item, index) -> (matching(item)) filter not $.pass))
}

fun reason(r, kind) = do {
    kind match {
        case "Assertion" ->
            r.kind match {
                case "Assertion::Equal" -> r.givenValue ++ " was not equal to " ++ r.expectedValue
                case "Assertion::Matcher" -> r.givenValue ++ " does not match " ++ r.expectedValue
                case "Assertion::Similar" -> r.givenValue ++ " is not similar to " ++ r.expectedValue
                else  -> "Assertion failed "
            }
        case "RuntimeException" -> "Exception: " ++ r.message
        else -> "Assertion failed"
    }

}
//fun processAssertions(assertions) = do {
//    assertions filter not $.pass map ("- " ++ $.name ++ " `( " ++ (reason($.result, $.kind)) ++ " ) ` :exclamation:")
//}

fun processAssertions(assertions) =  {
                                      "type": "context",
                                      "elements":
                                      assertions filter not $.pass map ({
                                      "type": "mrkdwn",
                                      "text": "- $($.name) `($(reason($.result, $.kind)))` :exclamation:"
                                      })
                                    }

fun post(url, body) = do {
   var r = request('POST',url,body)
   ---
   if(r.err)
      fail("Slack notification failed: " ++ r.message)
   else if(r.response.status != 200)
      fail("Slack notification failed: " ++ r.response.payload)
   else body
}

fun process(payload, context) = {
    blocks: header(payload, context) ++ getBody(payload) ++ footer(payload)
}

fun header(payload, context) = [
    {
      "type": "section",
      "text": {
        "type": "mrkdwn",
        "text": "$(headerStarting(payload))Monitor `$(payload.name)` *$(passedText(payload))* with configuration `$(context.config default 'default')` $(headerEnding(payload))"
      }
    },
    {
      "type": "divider"
    }
]

fun getBody(payload) =
    if(payload.pass)
        [
            {
              "type": "section",
              "text": {
                "type": "mrkdwn",
                "text": ":white_check_mark: All assertions have passed."
              }
            }
        ]
    else
        flatten (payload.result) map ([
                {
                 "type": "section",
                 "text": {
                   "type": "mrkdwn",
                   "text": ":x: The following assertions for  $($.name) have failed:"
                 }
                }, processAssertions($.assertions),
                {
                       "type": "divider"
                 }]
        ) reduce ((item, accumulator) -> accumulator ++ item)






fun passedText(payload) = if(payload.pass) "PASSED" else "FAILED"

fun headerEnding(payload) = if(payload.pass) ":small_blue_diamond:" else ":heavy_exclamation_mark:"

fun headerStarting(payload): String =
    if(payload.pass)
        ':small_blue_diamond: '
    else
       if(atHereEnabled) "@here "
       else ''

fun footer(payload) = if(hasMetadata(payload))[
        {
          "type": "section",
          "text": {
            "type": "mrkdwn",
            "text": "*<$(generateLink(payload))|Go to monitor>*"
          }
        }
    ] else []
---
if (DEBUG or webHook() == '' or disabled or (!payload.pass and !sendNotification))
  process(payload, context)
else
  post(webHook(), {
    body: process(payload, context),
  })



