/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.bat.APIs;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.blemale.scaffeine.Scaffeine$;
import com.mulesoft.bat.APIs.Http$;
import com.mulesoft.bat.APIs.Secret;
import com.mulesoft.bat.dw.service.BatLoggingService;
import com.mulesoft.bat.lambda.HttpLink;
import com.mulesoft.bat.lambda.Response;
import com.mulesoft.bat.runner.BatSecret;
import com.mulesoft.bat.runner.InternalBatRunnerLoggingService;
import com.mulesoft.bat.runner.InternalBatRunnerLoggingService$;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Base64;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class WorkerAPI$ {
    public static WorkerAPI$ MODULE$;
    private BatLoggingService logger;
    private String coreServicesEndpoint;
    private String workerAPIEndpoint;
    private final HttpLink http;
    private final long maxCacheSize;
    private final scala.collection.concurrent.Map<String, File> artifactsCache;

    static {
        new WorkerAPI$();
    }

    public BatLoggingService logger() {
        return this.logger;
    }

    public void logger_$eq(BatLoggingService x$1) {
        this.logger = x$1;
    }

    public String coreServicesEndpoint() {
        return this.coreServicesEndpoint;
    }

    public void coreServicesEndpoint_$eq(String x$1) {
        this.coreServicesEndpoint = x$1;
    }

    public String workerAPIEndpoint() {
        return this.workerAPIEndpoint;
    }

    public void workerAPIEndpoint_$eq(String x$1) {
        this.workerAPIEndpoint = x$1;
    }

    public HttpLink http() {
        return this.http;
    }

    public long maxCacheSize() {
        return this.maxCacheSize;
    }

    public void logDebug(Response response) {
        this.logger().logDebug(new StringBuilder(5).append("\u250c\n\u2502").append(response.toString().replaceAll("\n", "\n\u2502")).append("\n\u2514").toString());
    }

    public scala.collection.immutable.Map<String, BatSecret> getSecrets(scala.collection.immutable.Map<String, BatSecret> secretsInfo, Option<String> targetId, Option<String> orgId, Option<String> targetSecret) {
        Predef$.MODULE$.require(orgId.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Error getting secrets, organizationId is required.");
        return (scala.collection.immutable.Map)secretsInfo.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Response response;
            BatSecret info;
            String alias;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                alias = (String)tuple2._1();
                info = (BatSecret)tuple2._2();
                String url = new StringBuilder(27).append(MODULE$.workerAPIEndpoint()).append("/v1/organizations/").append(orgId.get()).append("/secrets/").append(info.getSecretId()).toString();
                MODULE$.logger().logDebug(new StringBuilder(4).append("GET ").append(url).toString());
                response = MODULE$.http().get(new URL(url), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(MODULE$.headers(targetId, targetSecret)).asJava());
                if (response.getStatus() != 200) {
                    throw new Exception(new StringBuilder(54).append("Error getting secret for secretId: ").append(info.getSecretId()).append(". Response status: ").append(response.getStatus()).toString());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Secret s = Http$.MODULE$.parseResponseJson(response, new TypeReference<Secret>(){});
            Try triedDecode = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Base64.getDecoder().decode(s.key()));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)alias), (Object)new BatSecret("", "", "", "", info.getSecretId(), "", (String)triedDecode.map((Function1 & Serializable & scala.Serializable)x$1 -> new String((byte[])x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> s.key())));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    public scala.collection.concurrent.Map<String, File> artifactsCache() {
        return this.artifactsCache;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeFile(String key, File value, RemovalCause removalCause) {
        boolean bl;
        this.logger().logDebug(new StringBuilder(36).append("Deleting file ").append(value.getAbsolutePath()).append(" of artifact ").append(key).append(". Cause: ").append(removalCause.toString()).toString());
        boolean bl2 = false;
        Success success = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> value.delete());
        if (try_ instanceof Success) {
            bl2 = true;
            success = (Success)try_;
            boolean bl3 = BoxesRunTime.unboxToBoolean((Object)success.value());
            if (bl3) {
                this.logger().logDebug(new StringBuilder(44).append("Temp file ").append(value.getAbsolutePath()).append(" of artifact ").append(key).append(" successfully deleted").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl2 && !(bl = BoxesRunTime.unboxToBoolean((Object)success.value()))) {
            this.logger().logWarn(new StringBuilder(34).append("Couldn't delete file ").append(value.getAbsolutePath()).append(" of artifact ").append(key).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
        Failure failure = (Failure)try_;
        Throwable exception = failure.exception();
        this.logger().logError(new StringBuilder(46).append("There was an error deleting file ").append(value.getAbsolutePath()).append(" of artifact ").append(key).toString());
        this.logger().logError(exception);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public File getArtifact(String organizationId, String artifactId, String executionId, String testId, String token, Option<String> targetId, Option<String> targetSecret) {
        File file;
        File tempDir = new File((String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> System.getProperty("java.io.tmpdir")).toOption().orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> System.getProperty("user.dir")).toOption()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        File localFile = new File(tempDir, new StringBuilder(19).append("bat-executable-").append(artifactId).append(".zip").toString());
        localFile.deleteOnExit();
        try {
            File file2;
            String string = artifactId;
            if (this.artifactsCache().exists((Function1 & Serializable & scala.Serializable)tuple -> BoxesRunTime.boxToBoolean((boolean)WorkerAPI$.$anonfun$getArtifact$5(artifactId, tuple)))) {
                this.setStatus(organizationId, executionId, testId, token, "RUNNING", targetId, targetSecret);
                file2 = (File)Option$.MODULE$.option2Iterable(this.artifactsCache().get((Object)artifactId)).head();
            } else {
                file2 = this.getArtifactNow(localFile, organizationId, artifactId, executionId, testId, token, targetId, targetSecret);
            }
            file = file2;
        }
        catch (Exception e) {
            this.logger().logError((Throwable)e);
            this.setStatus(organizationId, executionId, testId, token, "ERROR", targetId, targetSecret);
            throw e;
        }
        return file;
    }

    public File getArtifactNow(File localFile, String organizationId, String artifactId, String executionId, String testId, String token, Option<String> targetId, Option<String> targetSecret) {
        String url = new StringBuilder(48).append(this.workerAPIEndpoint()).append("/v1/organizations/").append(organizationId).append("/tests/").append(testId).append("/executions/").append(executionId).append("/artifacts/").append(artifactId).toString();
        this.logger().logDebug(new StringBuilder(4).append("GET ").append(url).toString());
        File file = targetId.isDefined() && targetSecret.isDefined() ? this.http().downloadWithHeaders(new URL(url), localFile, token, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.headers(targetId, targetSecret)).asJava()) : this.http().download(new URL(url), localFile, token);
        Predef$.MODULE$.assert(localFile.length() > 0L, (Function0 & Serializable & scala.Serializable)() -> "Downloaded artifact must have content");
        this.setStatus(organizationId, executionId, testId, token, "RUNNING", targetId, targetSecret);
        Object object = localFile.length() > 0L ? this.artifactsCache().put((Object)artifactId, (Object)localFile) : BoxedUnit.UNIT;
        return localFile;
    }

    public boolean uploadResult(String organizationId, String executionId, String testId, byte[] result, Option<byte[]> analytics, String token, Option<String> targetId, Option<String> targetSecret) {
        scala.collection.immutable.Map map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"result"), (Object)result)}));
        if (analytics.isDefined()) {
            map = map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"analytics"), analytics.get()));
        }
        String url = new StringBuilder(44).append(this.workerAPIEndpoint()).append("/v1/organizations/").append(organizationId).append("/tests/").append(testId).append("/executions/").append(executionId).append("/result").toString();
        this.logger().logDebug(new StringBuilder(5).append("POST ").append(url).toString());
        Response res = this.http().upload(new URL(url), JavaConverters$.MODULE$.mapAsJavaMap((Map)map), token, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.headers(targetId, targetSecret)).asJava());
        boolean success = res.getStatus() == 200 || res.getStatus() == 201;
        this.logDebug(res);
        return success;
    }

    public boolean setStatus(String organizationId, String executionId, String testId, String token, String status, Option<String> targetId, Option<String> targetSecret) {
        scala.collection.immutable.Map valueToSend = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status"), (Object)status)}));
        String url = new StringBuilder(37).append(this.workerAPIEndpoint()).append("/v1/organizations/").append(organizationId).append("/tests/").append(testId).append("/executions/").append(executionId).toString();
        this.logger().logDebug(new StringBuilder(4).append("PUT ").append(url).toString());
        Response res = Http$.MODULE$.putJson(url, valueToSend, token, this.headers(targetId, targetSecret));
        boolean success = res.getStatus() == 200 || res.getStatus() == 201;
        this.logDebug(res);
        return success;
    }

    private scala.collection.immutable.Map<String, String> headers(Option<String> targetId, Option<String> targetSecret) {
        return ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{targetId.map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"X-TARGET-ID"), x$2)), targetSecret.map((Function1 & Serializable & scala.Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"X-TARGET-SECRET"), x$3))})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$getArtifact$5(String artifactId$1, Tuple2 tuple) {
        Object object = tuple._1();
        String string = artifactId$1;
        return !(object != null ? !object.equals(string) : string != null) && ((File)tuple._2()).exists();
    }

    private WorkerAPI$() {
        MODULE$ = this;
        this.logger = new InternalBatRunnerLoggingService(false, InternalBatRunnerLoggingService$.MODULE$.$lessinit$greater$default$2());
        this.coreServicesEndpoint = "https://anypoint.mulesoft.com";
        this.workerAPIEndpoint = "https://bat-worker.cloudhub.io";
        this.http = new HttpLink();
        this.maxCacheSize = BoxesRunTime.unboxToLong((Object)scala.sys.package$.MODULE$.props().get("MAX_ARTIFACTS").flatMap((Function1 & Serializable & scala.Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int(Integer.valueOf(s))).toOption()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 50L));
        this.artifactsCache = Scaffeine$.MODULE$.apply().recordStats().expireAfterWrite(new package.DurationInt(package$.MODULE$.DurationInt(1)).hour()).maximumSize(this.maxCacheSize()).removalListener((Function3 & Serializable & scala.Serializable)(key, value, removalCause) -> {
            WorkerAPI$.MODULE$.removeFile(key, value, removalCause);
            return BoxedUnit.UNIT;
        }).build().asMap();
    }
}

