/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.bat.runner;

import com.google.common.cache.CacheBuilder;
import com.mulesoft.bat.runner.BatExecutableSpec;
import com.mulesoft.bat.runner.BatProjectArtifactId;
import com.mulesoft.bat.runner.BatSpecExecutionContext;
import com.mulesoft.bat.runner.ClassLoaderUtils$;
import com.mulesoft.bat.runner.WeaveHelper$;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.ConcurrentMap;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.model.values.ObjectValue;
import org.mule.weave.v2.model.values.ObjectValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine$;
import org.mule.weave.v2.runtime.InputType;
import org.mule.weave.v2.runtime.ScriptingBindings;
import org.mule.weave.v2.sdk.NameIdentifierHelper$;
import org.mule.weave.v2.ts.ObjectType;
import org.mule.weave.v2.ts.ObjectType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.io.File$;
import scala.reflect.io.Path$;
import scala.util.Either;
import scala.util.Try$;

public final class BatSpecFactory$ {
    public static BatSpecFactory$ MODULE$;
    private final DataWeaveScriptingEngine scriptingEngine;
    private final String configFolder;
    private final Seq<String> DEFAULT_FILES;
    private final ConcurrentMap<BatProjectArtifactId, BatExecutableSpec> specCache;

    static {
        new BatSpecFactory$();
    }

    public DataWeaveScriptingEngine scriptingEngine() {
        return this.scriptingEngine;
    }

    public String configFolder() {
        return this.configFolder;
    }

    public Seq<String> DEFAULT_FILES() {
        return this.DEFAULT_FILES;
    }

    public ConcurrentMap<BatProjectArtifactId, BatExecutableSpec> specCache() {
        return this.specCache;
    }

    public BatExecutableSpec executableSpec(Option<BatProjectArtifactId> maybeDefinition, String nameIdentifier, BatSpecExecutionContext context, URLClassLoader specProjectClassloader) {
        BatExecutableSpec batExecutableSpec;
        Option<BatProjectArtifactId> option = maybeDefinition;
        if (option instanceof Some) {
            BatExecutableSpec batExecutableSpec2;
            Some some = (Some)option;
            BatProjectArtifactId definition = (BatProjectArtifactId)some.value();
            Option maybeSpec = Option$.MODULE$.apply(this.specCache().get(definition));
            Option option2 = maybeSpec;
            if (None$.MODULE$.equals(option2)) {
                BatExecutableSpec spec = this.syncCompileSpec(nameIdentifier, specProjectClassloader);
                this.specCache().putIfAbsent(definition, spec);
                batExecutableSpec2 = spec;
            } else if (option2 instanceof Some) {
                BatExecutableSpec s;
                Some some2 = (Some)option2;
                batExecutableSpec2 = s = (BatExecutableSpec)some2.value();
            } else {
                throw new MatchError((Object)option2);
            }
            batExecutableSpec = batExecutableSpec2;
        } else if (None$.MODULE$.equals(option)) {
            batExecutableSpec = this.syncCompileSpec(nameIdentifier, specProjectClassloader);
        } else {
            throw new MatchError(option);
        }
        return batExecutableSpec;
    }

    private synchronized BatExecutableSpec syncCompileSpec(String nameIdentifier, URLClassLoader specProjectClassloader) {
        return this.compileSpec(nameIdentifier, specProjectClassloader);
    }

    private BatExecutableSpec compileSpec(String nameIdentifier, URLClassLoader specProjectClassloader) {
        return (BatExecutableSpec)ClassLoaderUtils$.MODULE$.runWithContextClassloader(specProjectClassloader, (Function1 & Serializable & scala.Serializable)classloader -> {
            DataWeaveScript dataWeaveScript = (DataWeaveScript)WeaveHelper$.MODULE$.withCompilationErrorFormatter((Function0 & Serializable & scala.Serializable)() -> {
                InputType[] inputTypes = (InputType[])((Object[])new InputType[]{new InputType("config", (Option)None$.MODULE$), new InputType("secrets", (Option)None$.MODULE$)});
                NameIdentifier identifierIdentifier = NameIdentifierHelper$.MODULE$.fromWeaveFilePath(nameIdentifier);
                return MODULE$.scriptingEngine().compile(identifierIdentifier, inputTypes);
            });
            return new BatExecutableSpec(dataWeaveScript, (URLClassLoader)classloader);
        });
    }

    public Value<?> readConfiguration(ServiceManager serviceManager, Option<String> configName, URLClassLoader classLoader) {
        ObjectValue objectValue;
        Option mayBeConfigUrl = Option$.MODULE$.apply((Object)this.getConfiguration(configName, classLoader));
        Option option = mayBeConfigUrl;
        if (None$.MODULE$.equals(option)) {
            serviceManager.loggingService().logWarn("*** No config file was found ***");
            objectValue = ObjectValue$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            URL configUrl = (URL)some.value();
            objectValue = (Value)WeaveHelper$.MODULE$.withCompilationErrorFormatter((Function0 & Serializable & scala.Serializable)() -> MODULE$.scriptingEngine().compile(configUrl, (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))).exec(new ScriptingBindings()));
        } else {
            throw new MatchError((Object)option);
        }
        return objectValue;
    }

    private URL getConfiguration(Option<String> configName, URLClassLoader classLoader) {
        return classLoader.findResource(this.getConfigPath(configName));
    }

    private String getConfigPath(Option<String> configName) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".dwl"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.configFolder(), configName.getOrElse((Function0 & Serializable & scala.Serializable)() -> "default")}));
    }

    public Either<Throwable, DataWeaveScript> validateScript(String resourceName, Option<String> maybeConfig) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Option weaveType = Option$.MODULE$.apply((Object)Source$.MODULE$.fromResource(MODULE$.getConfigPath(maybeConfig), Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.fallbackSystemCodec())).flatMap((Function1 & Serializable & scala.Serializable)content -> MODULE$.scriptingEngine().inferTypeOf(content.mkString()));
            URL resourceUrl = ClassLoaderUtils$.MODULE$.getResource(resourceName, ClassLoaderUtils$.MODULE$.getResource$default$2());
            InputType inputType = new InputType("config", weaveType);
            InputType secretsType = new InputType("secrets", (Option)new Some((Object)new ObjectType(ObjectType$.MODULE$.apply$default$1(), ObjectType$.MODULE$.apply$default$2(), ObjectType$.MODULE$.apply$default$3())));
            File scriptFile = File$.MODULE$.apply(Path$.MODULE$.string2path(resourceUrl.getPath()), Codec$.MODULE$.fallbackSystemCodec()).jfile();
            return MODULE$.scriptingEngine().compile(scriptFile, (InputType[])((Object[])new InputType[]{inputType, secretsType}));
        }).toEither();
    }

    public Either<Throwable, BatExecutableSpec> validateSpec(Option<BatProjectArtifactId> maybeDefinition, String nameIdentifier, BatSpecExecutionContext context, URLClassLoader specProjectClassloader) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.executableSpec(maybeDefinition, nameIdentifier, context, specProjectClassloader)).toEither();
    }

    public void runReporter(ServiceManager serviceManager, URL reporterUrl, Object payload, String stdOut, String stdErr, Option<Writer> target, Map<String, Object> options) {
        block0: {
            DataWeaveScript reporterDwScript = (DataWeaveScript)WeaveHelper$.MODULE$.withCompilationErrorFormatter((Function0 & Serializable & scala.Serializable)() -> MODULE$.scriptingEngine().compile(reporterUrl, (String[])((Object[])new String[]{"payload", "stdOut", "stdErr", "options"})));
            ScriptingBindings bindings = new ScriptingBindings();
            bindings.addBinding("payload", payload, "application/java");
            bindings.addBinding("stdOut", (Object)stdOut, "application/java");
            bindings.addBinding("stdErr", (Object)stdErr, "application/java");
            bindings.addBinding("options", options, "application/java");
            String result = reporterDwScript.write(bindings, serviceManager).getContentAsString();
            if (!target.isDefined()) break block0;
            BufferedWriter bw = new BufferedWriter((Writer)target.get());
            bw.write(result);
            bw.close();
        }
    }

    private BatSpecFactory$() {
        MODULE$ = this;
        this.scriptingEngine = DataWeaveScriptingEngine$.MODULE$.apply();
        this.configFolder = "config";
        this.DEFAULT_FILES = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bat.yaml", "bat.yml", "main.dwl", "test.dwl"}));
        this.specCache = CacheBuilder.newBuilder().maximumSize(Predef$.MODULE$.Long2long(Long.getLong("bat.max.cache.size", 10000L))).build().asMap();
    }
}

