/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.bat.APIs;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.cache.CacheBuilder;
import com.mulesoft.bat.APIs.Http$;
import com.mulesoft.bat.APIs.Secret;
import com.mulesoft.bat.lambda.HttpLink;
import com.mulesoft.bat.lambda.Response;
import com.mulesoft.bat.runner.BatSecret;
import com.mulesoft.bat.runner.InternalBatRunnerLoggingService;
import com.mulesoft.bat.runner.InternalBatRunnerLoggingService$;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Base64;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.runtime.BoxedUnit;

public final class WorkerAPI$ {
    public static WorkerAPI$ MODULE$;
    private final InternalBatRunnerLoggingService logger;
    private String coreServicesEndpoint;
    private String workerAPIEndpoint;
    private final HttpLink http;
    private final scala.collection.concurrent.Map<String, File> artifactsCache;

    static {
        new WorkerAPI$();
    }

    private InternalBatRunnerLoggingService logger() {
        return this.logger;
    }

    public String coreServicesEndpoint() {
        return this.coreServicesEndpoint;
    }

    public void coreServicesEndpoint_$eq(String x$1) {
        this.coreServicesEndpoint = x$1;
    }

    public String workerAPIEndpoint() {
        return this.workerAPIEndpoint;
    }

    public void workerAPIEndpoint_$eq(String x$1) {
        this.workerAPIEndpoint = x$1;
    }

    public HttpLink http() {
        return this.http;
    }

    public scala.collection.immutable.Map<String, BatSecret> getSecrets(scala.collection.immutable.Map<String, BatSecret> secretsInfo, Option<String> targetId, Option<String> orgId, Option<String> targetSecret) {
        Predef$.MODULE$.require(orgId.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Error getting secrets, organizationId is required.");
        return (scala.collection.immutable.Map)secretsInfo.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Response response;
            BatSecret info;
            String alias;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                alias = (String)tuple2._1();
                info = (BatSecret)tuple2._2();
                String url = new StringBuilder(27).append(MODULE$.workerAPIEndpoint()).append("/v1/organizations/").append(orgId.get()).append("/secrets/").append(info.getSecretId()).toString();
                MODULE$.logger().logDebug(new StringBuilder(4).append("GET ").append(url).toString());
                response = MODULE$.http().get(new URL(url), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(MODULE$.headers(targetId, targetSecret)).asJava());
                if (response.getStatus() != 200) {
                    throw new Exception(new StringBuilder(54).append("Error getting secret for secretId: ").append(info.getSecretId()).append(". Response status: ").append(response.getStatus()).toString());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Secret s = Http$.MODULE$.parseResponseJson(response, new TypeReference<Secret>(){});
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)alias), (Object)new BatSecret("", "", "", "", info.getSecretId(), "", new String(Base64.getDecoder().decode(s.key()))));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    public scala.collection.concurrent.Map<String, File> artifactsCache() {
        return this.artifactsCache;
    }

    public <K, V> ConcurrentMap<K, V> buildCache() {
        return CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(60L, TimeUnit.MINUTES).concurrencyLevel(10).build().asMap();
    }

    public File getArtifact(String organizationId, String artifactId, String executionId, String testId, String token, Option<String> targetId, Option<String> targetSecret) {
        File file;
        File localFile = File.createTempFile("bat-executable", artifactId);
        localFile.deleteOnExit();
        try {
            File file2;
            String string = artifactId;
            if (this.artifactsCache().get((Object)artifactId).isDefined()) {
                this.setStatus(organizationId, executionId, testId, token, "RUNNING", targetId, targetSecret);
                file2 = (File)Option$.MODULE$.option2Iterable(this.artifactsCache().get((Object)artifactId)).head();
            } else {
                file2 = this.getArtifactNow(localFile, organizationId, artifactId, executionId, testId, token, targetId, targetSecret);
            }
            file = file2;
        }
        catch (Exception e) {
            this.logger().logError(e);
            this.setStatus(organizationId, executionId, testId, token, "ERROR", targetId, targetSecret);
            throw e;
        }
        return file;
    }

    public File getArtifactNow(File localFile, String organizationId, String artifactId, String executionId, String testId, String token, Option<String> targetId, Option<String> targetSecret) {
        String url = new StringBuilder(48).append(this.workerAPIEndpoint()).append("/v1/organizations/").append(organizationId).append("/tests/").append(testId).append("/executions/").append(executionId).append("/artifacts/").append(artifactId).toString();
        this.logger().logDebug(new StringBuilder(4).append("GET ").append(url).toString());
        File file = targetId.isDefined() && targetSecret.isDefined() ? this.http().downloadWithHeaders(new URL(url), localFile, token, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.headers(targetId, targetSecret)).asJava()) : this.http().download(new URL(url), localFile, token);
        Predef$.MODULE$.assert(localFile.length() > 0L, (Function0 & Serializable & scala.Serializable)() -> "Downloaded artifact must have content");
        this.setStatus(organizationId, executionId, testId, token, "RUNNING", targetId, targetSecret);
        Object object = localFile.length() > 0L ? this.artifactsCache().put((Object)artifactId, (Object)localFile) : BoxedUnit.UNIT;
        return localFile;
    }

    public boolean uploadResult(String organizationId, String executionId, String testId, byte[] result, Option<byte[]> analytics, String token, Option<String> targetId, Option<String> targetSecret) {
        scala.collection.immutable.Map map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"result"), (Object)result)}));
        if (analytics.isDefined()) {
            map = map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"analytics"), analytics.get()));
        }
        String url = new StringBuilder(44).append(this.workerAPIEndpoint()).append("/v1/organizations/").append(organizationId).append("/tests/").append(testId).append("/executions/").append(executionId).append("/result").toString();
        this.logger().logDebug(new StringBuilder(5).append("POST ").append(url).toString());
        Response res = this.http().upload(new URL(url), JavaConverters$.MODULE$.mapAsJavaMap((Map)map), token, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.headers(targetId, targetSecret)).asJava());
        boolean success = res.getStatus() == 200 || res.getStatus() == 201;
        this.logger().logDebug(res);
        return success;
    }

    public boolean setStatus(String organizationId, String executionId, String testId, String token, String status, Option<String> targetId, Option<String> targetSecret) {
        scala.collection.immutable.Map valueToSend = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status"), (Object)status)}));
        String url = new StringBuilder(37).append(this.workerAPIEndpoint()).append("/v1/organizations/").append(organizationId).append("/tests/").append(testId).append("/executions/").append(executionId).toString();
        this.logger().logDebug(new StringBuilder(4).append("PUT ").append(url).toString());
        Response res = Http$.MODULE$.putJson(url, valueToSend, token, this.headers(targetId, targetSecret));
        boolean success = res.getStatus() == 200 || res.getStatus() == 201;
        this.logger().logDebug(res);
        return success;
    }

    private scala.collection.immutable.Map<String, String> headers(Option<String> targetId, Option<String> targetSecret) {
        return ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{targetId.map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"X-TARGET-ID"), x$1)), targetSecret.map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"X-TARGET-SECRET"), x$2))})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toMap(Predef$.MODULE$.$conforms());
    }

    private WorkerAPI$() {
        MODULE$ = this;
        this.logger = new InternalBatRunnerLoggingService(false, InternalBatRunnerLoggingService$.MODULE$.$lessinit$greater$default$2());
        this.coreServicesEndpoint = "https://anypoint.mulesoft.com";
        this.workerAPIEndpoint = "https://bat-worker.cloudhub.io";
        this.http = new HttpLink();
        this.artifactsCache = (scala.collection.concurrent.Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.buildCache()).asScala();
    }
}

