/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.bat.runner.lambda;

import com.mulesoft.bat.runner.lambda.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;

public class HttpLink {
    private RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(120000).setConnectionRequestTimeout(60000).build();

    public File download(URL url, File dstFile, String token) {
        CloseableHttpClient httpClient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        try {
            HttpGet request = new HttpGet(url.toURI());
            request.setConfig(this.config);
            this.addToken((HttpRequestBase)request, token);
            File file = (File)httpClient.execute((HttpUriRequest)request, (ResponseHandler)new FileDownloadResponseHandler(dstFile));
            return file;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.closeClient(httpClient);
        }
    }

    public File downloadWithHeaders(URL url, File dstFile, String token, Map<String, String> headers) {
        CloseableHttpClient httpClient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        try {
            HttpGet request = new HttpGet(url.toURI());
            request.setConfig(this.config);
            this.addToken((HttpRequestBase)request, token);
            headers.forEach((arg_0, arg_1) -> ((HttpGet)request).setHeader(arg_0, arg_1));
            File file = (File)httpClient.execute((HttpUriRequest)request, (ResponseHandler)new FileDownloadResponseHandler(dstFile));
            return file;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.closeClient(httpClient);
        }
    }

    public Response upload(URL url, Map<String, byte[]> files, String token) {
        CloseableHttpClient httpClient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.STRICT);
        files.forEach((s, bytes) -> builder.addBinaryBody(s, bytes, ContentType.DEFAULT_BINARY, "file"));
        try {
            HttpPost request = new HttpPost(url.toURI());
            request.setConfig(this.config);
            this.addToken((HttpRequestBase)request, token);
            HttpEntity entity = builder.build();
            request.setEntity(entity);
            Response response = this.makeResponse(httpClient.execute((HttpUriRequest)request));
            return response;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.closeClient(httpClient);
        }
    }

    public Response upload(URL url, Map<String, byte[]> files, String token, Map<String, String> headers) {
        CloseableHttpClient httpClient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.STRICT);
        files.forEach((s, bytes) -> builder.addBinaryBody(s, bytes, ContentType.DEFAULT_BINARY, "file"));
        try {
            HttpPost request = new HttpPost(url.toURI());
            request.setConfig(this.config);
            this.addToken((HttpRequestBase)request, token);
            HttpEntity entity = builder.build();
            request.setEntity(entity);
            headers.forEach((arg_0, arg_1) -> ((HttpPost)request).setHeader(arg_0, arg_1));
            Response response = this.makeResponse(httpClient.execute((HttpUriRequest)request));
            return response;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.closeClient(httpClient);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response putJson(URL url, String json, String token) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();){
            HttpPut request = new HttpPut(url.toURI());
            request.setConfig(this.config);
            this.addToken((HttpRequestBase)request, token);
            StringEntity requestEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)requestEntity);
            Response response = this.makeResponse(httpClient.execute((HttpUriRequest)request));
            return response;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Response putJson(URL url, String json, String token, Map<String, String> headers) {
        CloseableHttpClient httpClient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        try {
            HttpPut request = new HttpPut(url.toURI());
            request.setConfig(this.config);
            this.addToken((HttpRequestBase)request, token);
            headers.forEach((arg_0, arg_1) -> ((HttpPut)request).setHeader(arg_0, arg_1));
            StringEntity requestEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)requestEntity);
            Response response = this.makeResponse(httpClient.execute((HttpUriRequest)request));
            return response;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.closeClient(httpClient);
        }
    }

    public Response get(URL url, String token, Map<String, String> headers) {
        CloseableHttpClient httpClient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        try {
            HttpGet request = new HttpGet(url.toURI());
            request.setConfig(this.config);
            if (token != null) {
                this.addToken((HttpRequestBase)request, token);
            }
            headers.forEach((arg_0, arg_1) -> ((HttpGet)request).setHeader(arg_0, arg_1));
            Response response = this.makeResponse(httpClient.execute((HttpUriRequest)request));
            return response;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.closeClient(httpClient);
        }
    }

    public Response get(URL url, Map<String, String> headers) {
        return this.get(url, null, headers);
    }

    public Response get(URL url, String token) {
        return this.get(url, token, Collections.emptyMap());
    }

    public Response delete(URL url, String token) {
        CloseableHttpClient httpClient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        try {
            HttpDelete request = new HttpDelete(url.toURI());
            request.setConfig(this.config);
            this.addToken((HttpRequestBase)request, token);
            Response response = this.makeResponse(httpClient.execute((HttpUriRequest)request));
            return response;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.closeClient(httpClient);
        }
    }

    public Response postJson(URL url, String json, String token) {
        CloseableHttpClient httpClient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        try {
            HttpPost request = new HttpPost(url.toURI());
            request.setConfig(this.config);
            this.addToken((HttpRequestBase)request, token);
            StringEntity requestEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)requestEntity);
            Response response = this.makeResponse(httpClient.execute((HttpUriRequest)request));
            return response;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.closeClient(httpClient);
        }
    }

    private Response makeResponse(CloseableHttpResponse r) throws IOException {
        Response newResponse = new Response();
        HttpEntity ent = r.getEntity();
        newResponse.setContent(IOUtils.toByteArray((InputStream)ent.getContent()));
        newResponse.setStatus(r.getStatusLine().getStatusCode());
        newResponse.setHeaders(r.getAllHeaders());
        return newResponse;
    }

    private void addToken(HttpRequestBase request, String token) {
        if (token != null && token.length() > 0) {
            if (token.toLowerCase().startsWith("bearer ")) {
                request.addHeader("Authorization", token);
            } else {
                request.addHeader("Authorization", "Bearer " + token);
            }
        }
    }

    private void closeClient(CloseableHttpClient client) {
        try {
            client.close();
        }
        catch (IOException e) {
            throw new RuntimeException("There was a problem closing the http client", e);
        }
    }

    static class FileDownloadResponseHandler
    implements ResponseHandler<File> {
        private final File target;

        FileDownloadResponseHandler(File target) {
            this.target = target;
        }

        public File handleResponse(HttpResponse response) throws IOException {
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Not found");
            }
            InputStream source = response.getEntity().getContent();
            FileUtils.copyInputStreamToFile((InputStream)source, (File)this.target);
            if (this.target.length() == 0L) {
                throw new IOException("Received file has no lenght");
            }
            return this.target;
        }
    }
}

