/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.bat.runner.pipeline;

import com.github.benmanes.caffeine.cache.RemovalCause;
import com.mulesoft.bat.dw.csm.CSMSecretsProvider;
import com.mulesoft.bat.dw.dao.BATTestResult;
import com.mulesoft.bat.dw.service.BatLoggingService;
import com.mulesoft.bat.runner.apis.Endpoints;
import com.mulesoft.bat.runner.apis.WorkerAPI;
import com.mulesoft.bat.runner.compiler.BatCompiler;
import com.mulesoft.bat.runner.compiler.ContextRunnerFactory;
import com.mulesoft.bat.runner.httpCommon.HttpLink;
import com.mulesoft.bat.runner.httpCommon.Response;
import com.mulesoft.bat.runner.model.BatProjectArtifactId;
import com.mulesoft.bat.runner.model.BatReporter;
import com.mulesoft.bat.runner.model.BatSecret;
import com.mulesoft.bat.runner.model.BatSpec;
import com.mulesoft.bat.runner.model.DistributionType$;
import com.mulesoft.bat.runner.model.Execution;
import com.mulesoft.bat.runner.pipeline.BatExecutableProject;
import com.mulesoft.bat.runner.service.DynamicServiceManager;
import com.mulesoft.bat.runner.service.DynamicServiceManager$;
import com.mulesoft.bat.runner.service.ServicesSwitcher$;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import org.mule.weave.v2.model.service.LoggingService;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b!B\u000f\u001f\u0003\u0003I\u0003\u0002\u0003\u001c\u0001\u0005\u000b\u0007I\u0011A\u001c\t\u0011y\u0002!\u0011!Q\u0001\naB\u0001b\u0010\u0001\u0003\u0006\u0004%\u0019\u0001\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0003\"A\u0001\n\u0001B\u0001B\u0003-\u0011\nC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0005X\u0001\u0001\u0007\t\u0019!C\u00011\"Iq\f\u0001a\u0001\u0002\u0004%\t\u0001\u0019\u0005\nM\u0002\u0001\r\u0011!Q!\neCQa\u001a\u0001\u0007\u0002!DQ\u0001\u001d\u0001\u0005\u0002EDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\"\u0001!\t!a\t\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u0011\u0011\f\u0001\u0007\u0002\u0005m\u0003bBA6\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0003_\u0002A\u0011AA7\u0011\u001d\t\t\b\u0001C\u0001\u0003gBq!a!\u0001\t\u0003\t)\tC\u0004\u0002\u0012\u0002!\t!a%\t\u000f\u0005u\u0005\u0001\"\u0001\u0002 \"9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0006bBA[\u0001\u0019\u0005\u0011q\u0017\u0005\b\u0003\u000b\u0004a\u0011AAd\u0011\u001d\ty\r\u0001C\u0001\u0003#Dq!!>\u0001\t\u0003\t9\u0010C\u0004\u0003\u0016\u0001!\tAa\u0006\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e\tY!)\u0019;QSB,G.\u001b8f\u0015\ty\u0002%\u0001\u0005qSB,G.\u001b8f\u0015\t\t#%\u0001\u0004sk:tWM\u001d\u0006\u0003G\u0011\n1AY1u\u0015\t)c%\u0001\u0005nk2,7o\u001c4u\u0015\u00059\u0013aA2p[\u000e\u00011c\u0001\u0001+aA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t1\u0011I\\=SK\u001a\u0004\"!\r\u001b\u000e\u0003IR!a\r\u0011\u0002\t\u0005\u0004\u0018n]\u0005\u0003kI\u0012\u0011bV8sW\u0016\u0014\u0018\tU%\u0002\u0013\u0015DXmY;uS>tW#\u0001\u001d\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m\u0002\u0013!B7pI\u0016d\u0017BA\u001f;\u0005%)\u00050Z2vi&|g.\u0001\u0006fq\u0016\u001cW\u000f^5p]\u0002\n1BY1u\u0007>l\u0007/\u001b7feV\t\u0011\t\u0005\u0002C\u000b6\t1I\u0003\u0002EA\u0005A1m\\7qS2,'/\u0003\u0002G\u0007\nY!)\u0019;D_6\u0004\u0018\u000e\\3s\u00031\u0011\u0017\r^\"p[BLG.\u001a:!\u0003\t)7\r\u0005\u0002K\u001b6\t1J\u0003\u0002MY\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u00059[%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019\u0011+\u0016,\u0015\u0005I#\u0006CA*\u0001\u001b\u0005q\u0002\"\u0002%\u0007\u0001\bI\u0005\"\u0002\u001c\u0007\u0001\u0004A\u0004\"B \u0007\u0001\b\t\u0015AD:feZL7-Z'b]\u0006<WM]\u000b\u00023B\u0011!,X\u0007\u00027*\u0011A\fI\u0001\bg\u0016\u0014h/[2f\u0013\tq6LA\u000bEs:\fW.[2TKJ4\u0018nY3NC:\fw-\u001a:\u0002%M,'O^5dK6\u000bg.Y4fe~#S-\u001d\u000b\u0003C\u0012\u0004\"a\u000b2\n\u0005\rd#\u0001B+oSRDq!\u001a\u0005\u0002\u0002\u0003\u0007\u0011,A\u0002yIE\nqb]3sm&\u001cW-T1oC\u001e,'\u000fI\u0001\u0007Y><w-\u001a:\u0016\u0003%\u0004\"A\u001b8\u000e\u0003-T!\u0001\u00187\u000b\u00055\u0014\u0013A\u00013x\u0013\ty7NA\tCCRdunZ4j]\u001e\u001cVM\u001d<jG\u0016\f1b]3oIJ+7/\u001e7ugR\u0011!/\u001e\t\u0004\u0015N\f\u0017B\u0001;L\u0005\u00191U\u000f^;sK\")ao\u0003a\u0001o\u0006YQ.Y=cKJ+7/\u001e7u!\rY\u0003P_\u0005\u0003s2\u0012aa\u00149uS>t\u0007CA>\u007f\u001b\u0005a(BA?m\u0003\r!\u0017m\\\u0005\u0003\u007fr\u0014QBQ!U)\u0016\u001cHOU3tk2$\u0018a\u00038pi&4\u00170\u0012:s_J$2A]A\u0003\u0011\u001d\t9\u0001\u0004a\u0001\u0003\u0013\t\u0011!\u001a\t\u0005\u0003\u0017\tYB\u0004\u0003\u0002\u000e\u0005]a\u0002BA\b\u0003+i!!!\u0005\u000b\u0007\u0005M\u0001&\u0001\u0004=e>|GOP\u0005\u0002[%\u0019\u0011\u0011\u0004\u0017\u0002\u000fA\f7m[1hK&!\u0011QDA\u0010\u0005%!\u0006N]8xC\ndWMC\u0002\u0002\u001a1\nqbZ3u\u000bb$(/Y\"p]R,\u0007\u0010^\u000b\u0003\u0003K\u0001BAS:\u0002(A!1\u0006_A\u0015!!\tY#a\r\u0002:\u0005}b\u0002BA\u0017\u0003_\u00012!a\u0004-\u0013\r\t\t\u0004L\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0012q\u0007\u0002\u0004\u001b\u0006\u0004(bAA\u0019YA!\u00111FA\u001e\u0013\u0011\ti$a\u000e\u0003\rM#(/\u001b8h!\u0011\t\t%a\u0013\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\nA\u0001\\1oO*\u0011\u0011\u0011J\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002N\u0005\r#AB(cU\u0016\u001cG/A\u0004jg\u0012+'-^4\u0016\u0005\u0005M\u0003cA\u0016\u0002V%\u0019\u0011q\u000b\u0017\u0003\u000f\t{w\u000e\\3b]\u0006\u0001Bm\\<oY>\fG-\u0011:uS\u001a\f7\r\u001e\u000b\u0003\u0003;\u0002BAS:\u0002`A!\u0011\u0011MA4\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0013a\u00018fi&!\u0011\u0011NA2\u0005\r)&\u000bT\u0001\u0011S:LG/[1mSj,'+\u001e8oKJ$\u0012A]\u0001\u000fM&t\u0017\r\\5{KJ+hN\\3s\u0003E9W\r^#yiJ\f'+\u001a9peR,'o]\u000b\u0003\u0003k\u0002BAS:\u0002xA1\u00111BA=\u0003{JA!a\u001f\u0002 \t!A*[:u!\rI\u0014qP\u0005\u0004\u0003\u0003S$a\u0003\"biJ+\u0007o\u001c:uKJ\fqBY3g_J,W\t_3dkRLwN\u001c\u000b\u0004e\u0006\u001d\u0005bBAE'\u0001\u0007\u00111R\u0001\bE\u0006$8\u000b]3d!\rI\u0014QR\u0005\u0004\u0003\u001fS$a\u0002\"biN\u0003XmY\u0001\rO\u0016$8\t\\1tgB\u000bG\u000f[\u000b\u0003\u0003+\u0003BAS:\u0002\u0018B)1&!'\u0002`%\u0019\u00111\u0014\u0017\u0003\u000b\u0005\u0013(/Y=\u0002\u0019\u001d,Go\u0015;beR4\u0015\u000e\\3\u0016\u0005\u0005\u0005\u0006\u0003\u0002&t\u0003G\u0003Ba\u000b=\u0002:\u0005\u0019r-\u001a;Fq\u0016\u001cW\u000f^5p]RKW.Z8viV\u0011\u0011\u0011\u0016\t\u0005\u0003W\u000b\t,\u0004\u0002\u0002.*\u0019\u0011qV&\u0002\u0011\u0011,(/\u0019;j_:LA!a-\u0002.\nAA)\u001e:bi&|g.A\btK\u000e\u0014X\r^:Qe>4\u0018\u000eZ3s+\t\tI\f\u0005\u0003\u0002<\u0006\u0005WBAA_\u0015\r\ty\f\\\u0001\u0004GNl\u0017\u0002BAb\u0003{\u0013!cQ*N'\u0016\u001c'/\u001a;t!J|g/\u001b3fe\u0006!2m\u001c8uKb$(+\u001e8oKJ4\u0015m\u0019;pef,\"!!3\u0011\u0007\t\u000bY-C\u0002\u0002N\u000e\u0013AcQ8oi\u0016DHOU;o]\u0016\u0014h)Y2u_JL\u0018\u0001\u00053jgR\u0014\u0018NY;uS>tG+\u001f9f+\t\t\u0019\u000e\u0005\u0003\u0002V\u0006=h\u0002BAl\u0003WtA!!7\u0002j:!\u00111\\At\u001d\u0011\ti.!:\u000f\t\u0005}\u00171\u001d\b\u0005\u0003\u001f\t\t/C\u0001(\u0013\t)c%\u0003\u0002$I%\u0011\u0011EI\u0005\u0003w\u0001J1!!<;\u0003A!\u0015n\u001d;sS\n,H/[8o)f\u0004X-\u0003\u0003\u0002r\u0006M(\u0001\u0005#jgR\u0014\u0018NY;uS>tG+\u001f9f\u0015\r\tiOO\u0001\u0015O\u0016$X\t_3dkR\f'\r\\3Qe>TWm\u0019;\u0015\u0011\u0005e(\u0011\u0001B\u0003\u0005#\u0001BAS:\u0002|B\u00191+!@\n\u0007\u0005}hD\u0001\u000bCCR,\u00050Z2vi\u0006\u0014G.\u001a)s_*,7\r\u001e\u0005\b\u0005\u0007Q\u0002\u0019AAR\u00039i\u0017-\u001f2f'R\f'\u000f\u001e$jY\u0016DqAa\u0002\u001b\u0001\u0004\u0011I!A\bnCf\u0014W-\u0011:uS\u001a\f7\r^%e!\u0011Y\u0003Pa\u0003\u0011\u0007e\u0012i!C\u0002\u0003\u0010i\u0012ACQ1u!J|'.Z2u\u0003J$\u0018NZ1di&#\u0007b\u0002B\n5\u0001\u0007\u0011qS\u0001\nG2\f7o\u001d9bi\"\fQbZ3u\u0003J$\u0018NZ1di&#WC\u0001B\r!\u0011Q5O!\u0003\u0002\u0007I,h\u000e\u0006\u0002\u0003 A\u0019!j]<")
public abstract class BatPipeline
implements WorkerAPI {
    private final Execution execution;
    private final BatCompiler batCompiler;
    private final ExecutionContext ec;
    private DynamicServiceManager serviceManager;
    private String coreServicesEndpoint;
    private String workerAPIEndpoint;
    private final HttpLink http;
    private final scala.collection.concurrent.Map<String, File> artifactsCache;

    @Override
    public void setEndpoints(Endpoints endpoints) {
        WorkerAPI.setEndpoints$(this, endpoints);
    }

    @Override
    public void logDebug(Response response) {
        WorkerAPI.logDebug$(this, response);
    }

    @Override
    public Map<String, BatSecret> getSecrets(Map<String, BatSecret> secretsInfo, Option<String> targetId, Option<String> orgId, Option<String> targetSecret, Option<String> token) {
        return WorkerAPI.getSecrets$(this, secretsInfo, targetId, orgId, targetSecret, token);
    }

    @Override
    public Option<String> getSecrets$default$5() {
        return WorkerAPI.getSecrets$default$5$(this);
    }

    @Override
    public void removeFile(String key, File value, RemovalCause removalCause) {
        WorkerAPI.removeFile$(this, key, value, removalCause);
    }

    @Override
    public File getArtifact(String organizationId, String artifactId, String executionId, String testId, String token, Option<String> targetId, Option<String> targetSecret, scala.collection.concurrent.Map<String, File> artifactsCache) {
        return WorkerAPI.getArtifact$(this, organizationId, artifactId, executionId, testId, token, targetId, targetSecret, artifactsCache);
    }

    @Override
    public scala.collection.concurrent.Map<String, File> getArtifact$default$8() {
        return WorkerAPI.getArtifact$default$8$(this);
    }

    @Override
    public File getArtifactNow(File localFile, String organizationId, String artifactId, String executionId, String testId, String token, Option<String> targetId, Option<String> targetSecret) {
        return WorkerAPI.getArtifactNow$(this, localFile, organizationId, artifactId, executionId, testId, token, targetId, targetSecret);
    }

    @Override
    public boolean uploadResult(String organizationId, String executionId, String testId, byte[] result, Option<byte[]> analytics, String token, Option<String> targetId, Option<String> targetSecret) {
        return WorkerAPI.uploadResult$(this, organizationId, executionId, testId, result, analytics, token, targetId, targetSecret);
    }

    @Override
    public boolean setStatus(String organizationId, String executionId, String testId, String token, String status, Option<String> targetId, Option<String> targetSecret) {
        return WorkerAPI.setStatus$(this, organizationId, executionId, testId, token, status, targetId, targetSecret);
    }

    @Override
    public String coreServicesEndpoint() {
        return this.coreServicesEndpoint;
    }

    @Override
    public void coreServicesEndpoint_$eq(String x$1) {
        this.coreServicesEndpoint = x$1;
    }

    @Override
    public String workerAPIEndpoint() {
        return this.workerAPIEndpoint;
    }

    @Override
    public void workerAPIEndpoint_$eq(String x$1) {
        this.workerAPIEndpoint = x$1;
    }

    @Override
    public HttpLink http() {
        return this.http;
    }

    @Override
    public scala.collection.concurrent.Map<String, File> artifactsCache() {
        return this.artifactsCache;
    }

    @Override
    public void com$mulesoft$bat$runner$apis$WorkerAPI$_setter_$http_$eq(HttpLink x$1) {
        this.http = x$1;
    }

    @Override
    public void com$mulesoft$bat$runner$apis$WorkerAPI$_setter_$artifactsCache_$eq(scala.collection.concurrent.Map<String, File> x$1) {
        this.artifactsCache = x$1;
    }

    public Execution execution() {
        return this.execution;
    }

    public BatCompiler batCompiler() {
        return this.batCompiler;
    }

    public DynamicServiceManager serviceManager() {
        return this.serviceManager;
    }

    public void serviceManager_$eq(DynamicServiceManager x$1) {
        this.serviceManager = x$1;
    }

    @Override
    public abstract BatLoggingService logger();

    public Future<BoxedUnit> sendResults(Option<BATTestResult> maybeResult) {
        return Future$.MODULE$.unit();
    }

    public Future<BoxedUnit> notifyError(Throwable e) {
        this.logger().logError("*** Error ***");
        this.logger().logError(e.getMessage());
        return Future$.MODULE$.unit();
    }

    public Future<Option<Map<String, Object>>> getExtraContext() {
        return Future$.MODULE$.successful((Object)None$.MODULE$);
    }

    public boolean isDebug() {
        return false;
    }

    public abstract Future<URL> downloadArtifact();

    public Future<BoxedUnit> initializeRunner() {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.serviceManager_$eq(new DynamicServiceManager((LoggingService)this.logger(), DynamicServiceManager$.MODULE$.$lessinit$greater$default$2(), DynamicServiceManager$.MODULE$.$lessinit$greater$default$3()));
            this.serviceManager().registerService(CSMSecretsProvider.class, this.secretsProvider());
            ServicesSwitcher$.MODULE$.configureVariableServices(this.serviceManager(), this.distributionType());
        }, this.ec);
    }

    public Future<BoxedUnit> finalizeRunner() {
        return Future$.MODULE$.unit();
    }

    public Future<List<BatReporter>> getExtraReporters() {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$, this.ec);
    }

    public Future<BoxedUnit> beforeExecution(BatSpec batSpec) {
        return Future$.MODULE$.unit();
    }

    public Future<URL[]> getClassPath() {
        return this.downloadArtifact().map((Function1 & Serializable & scala.Serializable)x$1 -> (URL[])((Object[])new URL[]{x$1}), this.ec);
    }

    public Future<Option<String>> getStartFile() {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, this.ec);
    }

    public Duration getExecutionTimeout() {
        return new package.DurationInt(package$.MODULE$.DurationInt(30)).minutes();
    }

    public abstract CSMSecretsProvider secretsProvider();

    public abstract ContextRunnerFactory contextRunnerFactory();

    public Enumeration.Value distributionType() {
        return DistributionType$.MODULE$.Cli();
    }

    public Future<BatExecutableProject> getExecutableProject(Option<String> maybeStartFile, Option<BatProjectArtifactId> maybeArtifactId, URL[] classpath) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new BatExecutableProject(this.execution(), maybeArtifactId, maybeStartFile, this.contextRunnerFactory().createContextRunner(classpath), this.isDebug(), this.getExecutionTimeout(), this.distributionType()), this.ec);
    }

    public Future<Option<BatProjectArtifactId>> getArtifactId() {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Execution execution = this.execution();
            if (execution != null) {
                Option<String> option = execution.organizationId();
                Option<String> option2 = execution.testId();
                Option<String> option3 = execution.artifactId();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String o = (String)some.value();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        String t = (String)some2.value();
                        if (option3 instanceof Some) {
                            Some some3 = (Some)option3;
                            String a = (String)some3.value();
                            return new Some((Object)new BatProjectArtifactId(o, t, a));
                        }
                    }
                }
            }
            return None$.MODULE$;
        }, this.ec);
    }

    public Future<Option<BATTestResult>> run() {
        this.logger().logInfo("*** Starting Pipeline ***");
        return this.initializeRunner().flatMap((Function1 & Serializable & scala.Serializable)_ -> {
            this.logger().logInfo("*** Building classpath ***");
            return this.getClassPath().flatMap((Function1 & Serializable & scala.Serializable)classpath -> {
                this.logger().logInfo("*** Building artifactId ***");
                return this.getArtifactId().flatMap((Function1 & Serializable & scala.Serializable)maybeArtifactId -> {
                    this.logger().logInfo("*** Resolving start file ***");
                    return this.getStartFile().flatMap((Function1 & Serializable & scala.Serializable)maybeStartFile -> {
                        this.logger().logInfo("*** Configuring project ***");
                        return this.getExecutableProject((Option<String>)maybeStartFile, (Option<BatProjectArtifactId>)maybeArtifactId, (URL[])classpath).flatMap((Function1 & Serializable & scala.Serializable)project -> {
                            this.logger().logInfo("*** Looking for extra reporters ***");
                            return this.getExtraReporters().flatMap((Function1 & Serializable & scala.Serializable)extraReporters -> {
                                this.logger().logInfo("*** Building extra context ***");
                                return this.getExtraContext().flatMap((Function1 & Serializable & scala.Serializable)extraContext -> {
                                    this.logger().logInfo("*** Running tests ***");
                                    return project.run(this.logger(), this.serviceManager(), (List<BatReporter>)extraReporters, (Option<Map<String, Object>>)extraContext, (Function1<BatSpec, Future<BoxedUnit>>)(Function1 & Serializable & scala.Serializable)batSpec -> this.beforeExecution((BatSpec)batSpec), $this.ec, this.batCompiler()).flatMap((Function1 & Serializable & scala.Serializable)result -> {
                                        this.logger().logInfo("*** Sending Results ***");
                                        return this.sendResults((Option<BATTestResult>)result).flatMap((Function1 & Serializable & scala.Serializable)_2 -> {
                                            this.logger().logInfo("*** Finishing Pipeline ***");
                                            return this.finalizeRunner().map((Function1 & Serializable & scala.Serializable)_ -> result, $this.ec);
                                        }, $this.ec);
                                    }, $this.ec);
                                }, $this.ec);
                            }, $this.ec);
                        }, $this.ec);
                    }, $this.ec);
                }, $this.ec);
            }, $this.ec);
        }, this.ec);
    }

    public BatPipeline(Execution execution, BatCompiler batCompiler, ExecutionContext ec) {
        this.execution = execution;
        this.batCompiler = batCompiler;
        this.ec = ec;
        WorkerAPI.$init$(this);
    }
}

