/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.bat.cli;

import com.mulesoft.bat.cli.Option;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class BatWrapper {
    public static final String BAT_VERSION_FILE = ".bat-version";
    private static final File batDir = System.getProperty("bat.temp.dir") != null ? new File(System.getProperty("bat.temp.dir")) : new File(System.getenv("HOME"), ".bat");
    private static final String LATEST = "LATEST";
    private static final String BIN_PATH = "/bin/bat-cli";
    private HashMap<Option, String> options;
    private String BASE_URL = "https://repository-master.mulesoft.org/nexus/content/repositories/releases/com/mulesoft/bat/bat-cli";

    public static void main(String[] args) {
        new BatWrapper().execute(args);
    }

    protected void execute(String[] args) {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        this.parseOptions(argList);
        boolean update = this.hasOption(Option.UPDATE);
        try {
            if (update) {
                this.checkVersion(this.getLatestVersion(), true, true);
            } else {
                String runningVersion = this.getOption(Option.BAT_VERSION).orElse(this.getVersionFromFile().orElse(LATEST));
                this.checkVersion(runningVersion, false, false);
                String[] newArgs = argList.toArray(new String[argList.size()]);
                if (this.hasOption(Option.VERSION)) {
                    System.out.println("BAT Wrapper: " + this.getWrapperVersion());
                }
                this.executeCli(runningVersion, newArgs);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    private void checkVersion(String version, boolean update, boolean latest) throws IOException {
        if (!this.upToDate(version, update)) {
            String newVersion = this.downloadVersion(version, latest);
            if (update && newVersion != null) {
                this.writeVersionFile(newVersion);
            }
        } else if (update) {
            this.writeVersionFile(Files.readSymbolicLink(BatWrapper.batCLIDir(latest ? LATEST : version).toPath()).getFileName().toString());
        }
    }

    private boolean upToDate(String version, boolean update) throws IOException {
        if (update) {
            System.out.print("Updating Version: ");
            File file = new File(BatWrapper.batCLIDir(version), ".etag");
            if (!file.exists()) {
                System.out.println("You have an older BAT version.");
                return false;
            }
            String eTag = Files.readAllLines(file.toPath()).get(0);
            boolean upToDate = eTag.equals(this.getEtag(version));
            if (upToDate) {
                System.out.println("Up-To-Date!");
            } else {
                System.out.println("You have an older BAT version.");
            }
            return upToDate;
        }
        if (!new File(BatWrapper.batCLIDir(version), BIN_PATH).exists()) {
            System.out.println("You do not have the " + version + " version of BAT.");
            return false;
        }
        return true;
    }

    private String getWrapperVersion() {
        InputStream stream = BatWrapper.class.getClassLoader().getResourceAsStream("BAT-WRAPPER-VERSION.txt");
        return stream != null ? new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.joining()) : "Working Copy";
    }

    private void parseOptions(List<String> argList) {
        this.options = new HashMap();
        Iterator<String> iterator = argList.iterator();
        while (iterator.hasNext()) {
            Option option;
            String s = iterator.next();
            if (!s.startsWith("--") || (option = this.option(s.substring(2).split("=", 2))) == null || !option.isWrapperOnly()) continue;
            iterator.remove();
        }
    }

    private Option option(String[] optionValue) {
        Option option = Option.option(optionValue[0]);
        String value = null;
        if (option != null) {
            if (option.hasArgument()) {
                if (optionValue.length == 1) {
                    throw new IllegalArgumentException("Missing value for option --" + option.name());
                }
                value = optionValue[1];
            }
            this.options.put(option, value);
        }
        return option;
    }

    private Optional<String> getOption(Option option) {
        return Optional.ofNullable(this.options.get((Object)option));
    }

    private Optional<String> getVersionFromFile() throws IOException {
        File file = new File(System.getProperty("user.dir"), BAT_VERSION_FILE);
        if (!file.exists()) {
            return Optional.empty();
        }
        return Files.lines(file.toPath()).findFirst();
    }

    private boolean hasOption(Option option) {
        return this.options.containsKey((Object)option);
    }

    private void executeCli(String version, String[] args) throws Throwable {
        File[] files = new File(BatWrapper.batCLIDir(version), "/lib").listFiles();
        assert (files != null);
        Stream<URL> urlStream = Arrays.stream(files).map(f -> {
            try {
                return new URL("file://" + f.getAbsolutePath());
            }
            catch (MalformedURLException e) {
                return null;
            }
        });
        URLClassLoader contextClassLoader = new URLClassLoader((URL[])urlStream.toArray(URL[]::new), ClassLoader.getSystemClassLoader().getParent());
        Thread.currentThread().setContextClassLoader(contextClassLoader);
        Class<?> mainClass = contextClassLoader.loadClass("com.mulesoft.bat.EntryPoint");
        Method mainMethod = mainClass.getMethod("main", String[].class);
        try {
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            throw e.getCause() != null ? e.getCause() : e;
        }
        contextClassLoader.close();
    }

    private void writeVersionFile(String version) throws IOException {
        File dir = new File(System.getProperty("user.dir"));
        File[] files = dir.listFiles((dir1, name) -> name.equalsIgnoreCase("bat.yaml") || name.equalsIgnoreCase("bat.yml"));
        if (files != null && files.length > 0) {
            File file = new File(System.getProperty("user.dir"), BAT_VERSION_FILE);
            assert (version.contains("-"));
            Files.write(file.toPath(), version.split("-")[2].getBytes("UTF-8"), new OpenOption[0]);
        }
    }

    public static void cleanBatDir() {
        BatWrapper.removeDirectory(batDir);
    }

    private static void removeDirectory(File dir) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files != null && files.length > 0) {
                for (File aFile : files) {
                    BatWrapper.removeDirectory(aFile);
                }
            }
            dir.delete();
        } else {
            dir.delete();
        }
    }

    private String downloadVersion(String version, boolean latest) throws IOException {
        String eTag;
        batDir.mkdir();
        File download = new File(batDir, ".download");
        try {
            if (version.equals(LATEST)) {
                version = this.getLatestVersion();
                latest = true;
            }
            System.out.print("The new version will be downloaded in " + BatWrapper.batCLIDir(version) + "\n");
            eTag = this.doDownload(version, download);
        }
        catch (XmlPullParserException e) {
            throw new IOException(e.getMessage());
        }
        BatWrapper.removeDirectory(BatWrapper.batCLIDir(version));
        if (latest) {
            BatWrapper.removeDirectory(BatWrapper.batCLIDir(LATEST));
        }
        String root = this.unzip(download);
        this.writeEtag(new File(batDir, root + "/.etag"), eTag);
        if (latest) {
            this.createSymLinkToLatest(root);
        }
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        Files.setPosixFilePermissions(new File(batDir, root + BIN_PATH).toPath(), perms);
        download.delete();
        return root;
    }

    private static File batCLIDir(String version) {
        return new File(batDir, "bat-cli-" + version);
    }

    private void createSymLinkToLatest(String root) throws IOException {
        Files.createSymbolicLink(BatWrapper.batCLIDir(LATEST).toPath(), new File(batDir, root).toPath(), new FileAttribute[0]);
    }

    private void writeEtag(File file, String eTag) throws IOException {
        Files.write(file.toPath(), eTag.getBytes("UTF-8"), new OpenOption[0]);
    }

    private String unzip(File zipFile) throws IOException {
        String root = null;
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            if (!entry.isDirectory()) {
                new File(batDir, entry.getName()).getParentFile().mkdirs();
                if (root == null) {
                    root = entry.getName().split("/")[0];
                }
                this.extractFile(zipIn, batDir + "/" + entry.getName());
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
        return root;
    }

    private void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        int read;
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[1000000];
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    protected String doDownload(String version, File download) throws IOException, XmlPullParserException {
        OutputStream out = null;
        InputStream in = null;
        try {
            int numRead;
            URL url = this.versionUrl(version);
            out = new BufferedOutputStream(new FileOutputStream(download));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            in = conn.getInputStream();
            byte[] buffer = new byte[5000000];
            long progressCounter = 0L;
            System.out.print("Downloading version " + version + ". Please wait");
            while ((numRead = in.read(buffer)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    System.out.print("interrupted");
                    throw new IOException("Download was interrupted.");
                }
                int PROGRESS_CHUNK = 2500000;
                if ((progressCounter += (long)numRead) / (long)PROGRESS_CHUNK > 0L) {
                    System.out.print(".");
                    progressCounter -= (long)PROGRESS_CHUNK;
                }
                out.write(buffer, 0, numRead);
            }
            String string = conn.getHeaderField("ETag");
            return string;
        }
        catch (FileNotFoundException f) {
            System.err.println("Zip file for version: " + version + " not found on server");
            throw f;
        }
        finally {
            System.out.println();
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private String getLatestVersion() throws IOException, XmlPullParserException {
        URL url = new URL(this.BASE_URL + "/maven-metadata.xml");
        Metadata metadata = new MetadataXpp3Reader().read(url.openStream());
        return metadata.getVersioning().getRelease();
    }

    private String getEtag(String version) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.versionUrl(version).openConnection();
        connection.setRequestMethod("HEAD");
        if (connection.getResponseCode() == 200) {
            return connection.getHeaderField("ETag");
        }
        return "0";
    }

    private URL versionUrl(String version) throws MalformedURLException {
        return new URL(this.BASE_URL + "/" + version + "/bat-cli-" + version + ".zip");
    }
}

