/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.cloudhub.client;

import com.google.gson.Gson;
import com.mulesoft.ch.rest.model.Account;
import com.mulesoft.ch.rest.model.Application;
import com.mulesoft.ch.rest.model.DomainStatus;
import com.mulesoft.cloudhub.client.CloudHubConnectionI;
import com.mulesoft.cloudhub.client.CloudHubDomainConnectionI;
import com.mulesoft.cloudhub.client.CloudHubDomainConnectionImpl;
import com.mulesoft.cloudhub.client.CloudHubException;
import com.mulesoft.cloudhub.client.ReturnMessage;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.multipart.impl.MultiPartWriter;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class CloudHubConnectionImpl
implements CloudHubConnectionI {
    public static final String NEW_DEFAULT_URL = "https://anypoint.mulesoft.com/cloudhub/";
    public static final String ENVIRONMENT_ID = "X-ANYPNT-ENV-ID";
    protected String url;
    protected Client client;
    protected String username;
    protected String password;
    protected String apiToken;
    protected String environmentId;
    protected String accessToken;
    protected Gson gson;

    protected void init(String url, boolean debug) {
        this.url = StringUtils.isBlank((CharSequence)url) ? NEW_DEFAULT_URL : (url.endsWith("/") ? url : url + "/");
        this.client = Client.create((ClientConfig)this.getClientConfig());
        if (debug) {
            this.client.addFilter((ClientFilter)new LoggingFilter());
        }
        this.gson = new Gson();
    }

    protected CloudHubConnectionImpl() {
    }

    public CloudHubConnectionImpl(String url, String accessToken, String environmentId, boolean debug) {
        this.environmentId = environmentId;
        this.accessToken = accessToken;
        this.init(url, debug);
    }

    public CloudHubConnectionImpl(String url, String accessToken, boolean debug) {
        this(url, accessToken, "", debug);
    }

    @Override
    public CloudHubDomainConnectionI connectWithDomain(String domain) {
        if (!StringUtils.isBlank((CharSequence)domain)) {
            return new CloudHubDomainConnectionImpl(this, this.environmentId, true, domain);
        }
        throw new IllegalArgumentException("Domain must not be null or empty");
    }

    @Override
    public Account retrieveAccount() throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createBuilder("account/").type(MediaType.APPLICATION_JSON_TYPE)).get(ClientResponse.class);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            return (Account)clientResponse.getEntity(Account.class);
        }
        throw this.buildExpception(clientResponse);
    }

    @Override
    public boolean isDomainAvailable(String domain) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)this.addEnvironmentHeader(this.createBuilder("applications/domains/" + domain)).get(ClientResponse.class);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            return ((DomainStatus)clientResponse.getEntity(DomainStatus.class)).isAvailable();
        }
        throw this.buildExpception(clientResponse);
    }

    @Override
    public List<Application> retrieveApplications() {
        ClientResponse clientResponse = (ClientResponse)this.addEnvironmentHeader(this.createApplicationBuilder("")).get(ClientResponse.class);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<Application>>(){});
        }
        throw this.buildExpception(clientResponse);
    }

    @Override
    public Application createApplication(Application application) throws CloudHubException {
        if (this.isDomainAvailable(application.getDomain())) {
            ClientResponse clientResponse = (ClientResponse)this.addEnvironmentHeader((WebResource.Builder)this.createApplicationBuilder("").type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)application);
            if (ClientResponse.Status.CREATED.equals((Object)clientResponse.getClientResponseStatus())) {
                return (Application)clientResponse.getEntity(Application.class);
            }
            throw this.buildExpception(clientResponse);
        }
        throw new CloudHubException("The application's domain is not available", String.valueOf(ClientResponse.Status.CONFLICT.getStatusCode()));
    }

    @Override
    public List<String> getSupportedMuleVersions() throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)this.addEnvironmentHeader(this.createApplicationBuilder("supportedMuleVersions")).get(ClientResponse.class);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            return (List)clientResponse.getEntity(List.class);
        }
        throw this.buildExpception(clientResponse);
    }

    private ClientConfig getClientConfig() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getClasses().add(JacksonJsonProvider.class);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JacksonJsonProvider jsonProvider = new JacksonJsonProvider((org.codehaus.jackson.map.ObjectMapper)mapper);
        clientConfig.getSingletons().add(jsonProvider);
        clientConfig.getClasses().add(MultiPartWriter.class);
        return clientConfig;
    }

    protected WebResource.Builder createBuilder(String path) {
        return this.authorizeResource(this.createResource(path));
    }

    protected WebResource.Builder authorizeResource(WebResource pathResource) {
        return pathResource.header("Authorization", (Object)("Bearer " + this.accessToken));
    }

    protected WebResource.Builder addEnvironmentHeader(WebResource.Builder pathResource) {
        return (WebResource.Builder)pathResource.header(ENVIRONMENT_ID, (Object)this.environmentId);
    }

    protected WebResource createResource(String path) {
        return this.client.resource(this.url + "api/").path(path);
    }

    protected final WebResource.Builder createApplicationBuilder(String path) {
        return this.createBuilder("applications/" + path);
    }

    protected CloudHubException buildExpception(ClientResponse clientResponse) throws CloudHubException {
        String message = "";
        int status = clientResponse.getStatus();
        message = ClientResponse.Status.BAD_REQUEST.equals((Object)clientResponse.getClientResponseStatus()) ? ((ReturnMessage)this.gson.fromJson((String)clientResponse.getEntity(String.class), ReturnMessage.class)).getErrorMessage() : clientResponse.getClientResponseStatus().getReasonPhrase();
        return new CloudHubException(message, String.valueOf(status));
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassowrd() {
        return this.password;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    public static class ObjectMapper
    extends org.codehaus.jackson.map.ObjectMapper {
        public ObjectMapper() {
            this.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        }
    }
}

