/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.cloudhub.client;

import com.mulesoft.ch.rest.model.Application;
import com.mulesoft.ch.rest.model.ApplicationStatus;
import com.mulesoft.ch.rest.model.ApplicationStatusChange;
import com.mulesoft.ch.rest.model.ApplicationUpdateInfo;
import com.mulesoft.cloudhub.client.CloudHubConnectionI;
import com.mulesoft.cloudhub.client.CloudHubConnectionImpl;
import com.mulesoft.cloudhub.client.CloudHubDomainConnectionI;
import com.mulesoft.cloudhub.client.CloudHubException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.File;
import java.io.IOException;
import javax.ws.rs.core.MediaType;

public class CloudHubDomainConnectionImpl
extends CloudHubConnectionImpl
implements CloudHubDomainConnectionI {
    private String domain;
    private String environmentId;

    protected CloudHubDomainConnectionImpl(CloudHubConnectionI con, String environmentId, boolean csAuthentication, String domain) {
        super(con.getUrl(), con.getAccessToken(), environmentId, false);
        this.domain = domain;
        this.environmentId = environmentId;
    }

    public CloudHubDomainConnectionImpl(String url, String accessToken, boolean debug) {
        this.accessToken = accessToken;
        this.init(url, debug);
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public Application retrieveApplication() throws CloudHubException {
        ClientResponse clientResponse;
        block3: {
            clientResponse = null;
            try {
                clientResponse = (ClientResponse)this.createApplicationDomainBuilder("").get(ClientResponse.class);
                if (!ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) break block3;
                Application application = (Application)clientResponse.getEntity(Application.class);
                this.closeSilently(clientResponse);
                clientResponse = null;
                return application;
            }
            catch (Throwable throwable) {
                this.closeSilently(clientResponse);
                clientResponse = null;
                throw throwable;
            }
        }
        throw this.buildExpception(clientResponse);
    }

    @Override
    public ApplicationStatus retrieveApplicationStatus() throws CloudHubException {
        ClientResponse clientResponse;
        block3: {
            clientResponse = null;
            try {
                clientResponse = (ClientResponse)this.createApplicationDomainBuilder("status").get(ClientResponse.class);
                if (!ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) break block3;
                ApplicationStatus applicationStatus = ApplicationStatus.valueOf((String)((String)clientResponse.getEntity(String.class)));
                this.closeSilently(clientResponse);
                clientResponse = null;
                return applicationStatus;
            }
            catch (Throwable throwable) {
                this.closeSilently(clientResponse);
                clientResponse = null;
                throw throwable;
            }
        }
        throw this.buildExpception(clientResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deployApplication(File file, long maxWaitTime) {
        FormDataMultiPart multiPart = null;
        ClientResponse clientResponse = null;
        try {
            multiPart = new FormDataMultiPart();
            multiPart.bodyPart((BodyPart)new FileDataBodyPart("file", file, MediaType.APPLICATION_OCTET_STREAM_TYPE));
            clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainBuilderV2("files").type("multipart/form-data")).post(ClientResponse.class, (Object)multiPart);
            if (!ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
                throw this.buildExpception(clientResponse);
            }
            this.waitForFinish(maxWaitTime, this.failedBefore());
            this.closeSilently(multiPart);
            this.closeSilently(clientResponse);
            multiPart = null;
            clientResponse = null;
        }
        catch (Throwable throwable) {
            this.closeSilently(multiPart);
            this.closeSilently(clientResponse);
            multiPart = null;
            clientResponse = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSilently(ClientResponse clientResponse) {
        if (clientResponse != null) {
            try {
                clientResponse.close();
            }
            finally {
                clientResponse = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSilently(FormDataMultiPart multiPart) {
        if (multiPart != null) {
            try {
                multiPart.close();
            }
            catch (IOException ioEx) {
                multiPart.cleanup();
            }
            finally {
                multiPart = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Application updateApplication(ApplicationUpdateInfo newApplicationInfo) throws CloudHubException {
        ClientResponse clientResponse = null;
        Application application = this.retrieveApplication();
        ApplicationUpdateInfo oldApplicationInfo = new ApplicationUpdateInfo(application);
        if (oldApplicationInfo.equals((Object)newApplicationInfo)) return application;
        clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainBuilder("").type(MediaType.APPLICATION_JSON_TYPE)).put(ClientResponse.class, (Object)newApplicationInfo);
        if (!ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) throw this.buildExpception(clientResponse);
        Application application2 = (Application)clientResponse.getEntity(Application.class);
        this.closeSilently(clientResponse);
        return application2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateApplicationStatus(ApplicationStatusChange applicationStatusChange, long maxWaitTime) throws CloudHubException {
        ClientResponse clientResponse = null;
        try {
            boolean failedBefore = this.failedBefore();
            clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainBuilder("status").type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)applicationStatusChange);
            if (!ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
                throw this.buildExpception(clientResponse);
            }
            this.waitForFinish(maxWaitTime, failedBefore);
            this.closeSilently(clientResponse);
            clientResponse = null;
        }
        catch (Throwable throwable) {
            this.closeSilently(clientResponse);
            clientResponse = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteApplication() throws CloudHubException {
        ClientResponse clientResponse = null;
        try {
            clientResponse = (ClientResponse)this.createApplicationDomainBuilder("").delete(ClientResponse.class);
            if (!ClientResponse.Status.NO_CONTENT.equals((Object)clientResponse.getClientResponseStatus())) {
                throw this.buildExpception(clientResponse);
            }
            this.closeSilently(clientResponse);
            clientResponse = null;
        }
        catch (Throwable throwable) {
            this.closeSilently(clientResponse);
            clientResponse = null;
            throw throwable;
        }
    }

    private final WebResource.Builder createApplicationDomainBuilder(String path) {
        return this.addEnvironmentHeader(this.createBuilder("applications/" + this.domain + "/" + path));
    }

    private final WebResource.Builder createApplicationDomainBuilderV2(String path) {
        return this.addEnvironmentHeader(this.createBuilder("v2/applications/" + this.domain + "/" + path));
    }

    private void waitForFinish(long maxWaitTime, boolean failedBefore) {
        ApplicationStatus status;
        Application latestApplication;
        if (maxWaitTime == 0L) {
            return;
        }
        if (maxWaitTime == 1L) {
            maxWaitTime = Long.MAX_VALUE;
        }
        long before = System.currentTimeMillis();
        while (System.currentTimeMillis() - before < maxWaitTime) {
            latestApplication = this.retrieveApplication();
            status = latestApplication.getDeploymentUpdateStatus();
            if (!failedBefore && status != null && status.equals((Object)ApplicationStatus.DEPLOY_FAILED)) {
                throw new CloudHubException("Application " + this.domain + " failed to start.", String.valueOf(ClientResponse.Status.EXPECTATION_FAILED.getStatusCode()));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        if ((status = (latestApplication = this.retrieveApplication()).getDeploymentUpdateStatus()) == null && latestApplication.getStatus().equals((Object)ApplicationStatus.STARTED)) {
            return;
        }
        if (status == null && latestApplication.getStatus().equals((Object)ApplicationStatus.UNDEPLOYED)) {
            return;
        }
        if (status.equals((Object)ApplicationStatus.DEPLOY_FAILED)) {
            throw new CloudHubException("Application " + this.domain + " failed to start.", String.valueOf(ClientResponse.Status.EXPECTATION_FAILED.getStatusCode()));
        }
        throw new CloudHubException("CloudHub did not finish the process before the specified time", String.valueOf(ClientResponse.Status.GATEWAY_TIMEOUT.getStatusCode()));
    }

    private boolean failedBefore() {
        ApplicationStatus status = this.retrieveApplication().getDeploymentUpdateStatus();
        return status == null ? false : status.equals((Object)ApplicationStatus.DEPLOY_FAILED);
    }
}

