package com.mulesoft.cloudhub.client;

import java.util.List;

import com.mulesoft.ch.rest.model.Account;
import com.mulesoft.ch.rest.model.Application;
import com.mulesoft.cloudhub.client.annotation.Component;
import com.mulesoft.cloudhub.client.annotation.UsedBy;

public interface CloudHubConnectionI {

    public String getUrl();

    public String getUsername();

    public String getPassowrd();

    public String getAccessToken();

    /**
     * Returns a connection against a given domain of the CloudHub account
     * 
     * @param domain
     *            the domain to which you want to connect
     * @return an instance of {@link com.mulesoft.cloudhub.client.CloudHubDomainConnectionImpl} connected with the specified domain
     */
    @UsedBy(Component.STUDIO)
    public CloudHubDomainConnectionI connectWithDomain(String domain);

    /**
     * Retrieves the CloudHub Account
     * 
     * @return an instance of {@link com.mulesoft.ch.rest.model.Account}
     * @throws CloudHubException
     *             if there is an error when retrieving the account
     */
    @UsedBy(Component.STUDIO)
    public Account retrieveAccount() throws CloudHubException;

    /**
     * Checks if the domain is valid and available
     * 
     * @param domain
     *            the domain to be validated
     * @return true if the domain is valid and available to be used. False if the domain is already taken.
     * @throws CloudHubException
     *             if there is an error when validating the domain
     */
    @UsedBy(value = { Component.STUDIO, Component.DEPLOY_MAVEN_PLUGIN })
    public boolean isDomainAvailable(String domain) throws CloudHubException;

    /**
     * Retrieves All Applications from an specific CloudHub account
     * 
     * @return a collection of {@link com.mulesoft.ch.rest.model.Application}
     * @throws CloudHubException
     *             if there is an error when retrieving the applications
     */
    @UsedBy(Component.STUDIO)
    public List<Application> retrieveApplications() throws CloudHubException;

    /**
     * Creates an application on your CloudHub account. This method does not deploy your application.
     * 
     * @param application
     *            an instance of {@link com.mulesoft.ch.rest.model.Application} containing all the application's information
     * 
     * @return an instance of {@link com.mulesoft.ch.rest.model.Application} containing all the recently created application's information provided by CloudHub
     * 
     * @throws CloudHubException
     *             if there was an error while creating the application
     */
    @UsedBy(value = { Component.STUDIO, Component.DEPLOY_MAVEN_PLUGIN })
    public Application createApplication(Application application) throws CloudHubException;

    /**
     * This method returns all the supported mule versions by CloudHub
     * 
     * @return a list of strings, with all the supported mule versions by CloudHub
     * @throws CloudHubException
     */
    @UsedBy(Component.STUDIO)
    public List<String> getSupportedMuleVersions() throws CloudHubException;
}
