/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.cloudhub.client;

import com.mulesoft.cloudhub.client.Application;
import com.mulesoft.cloudhub.client.CloudHubException;
import com.mulesoft.cloudhub.client.CloudhubConnection;
import com.mulesoft.cloudhub.client.DomainConnection;
import com.mulesoft.cloudhub.client.Notification;
import com.mulesoft.cloudhub.client.NotificationResults;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.core.util.Base64;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
implements CloudhubConnection {
    private Logger logger = LoggerFactory.getLogger(Connection.class);
    public static final String DEFAULT_URL = "https://cloudhub.io/";
    private final Client client;
    private final String url;
    private final String username;
    private final String password;
    private String apiToken;

    public Connection(String url, String username, String password) {
        this(url, username, password, false);
    }

    public Connection(String url, String username, String password, boolean debug) {
        if (url == null) {
            throw new IllegalArgumentException("null url");
        }
        if (username == null || "".equals(username)) {
            this.apiToken = System.getProperty("cloudhub.api.token");
            if (this.apiToken == null) {
                this.apiToken = System.getProperty("ion.api.token");
            }
            this.logger.debug("Using CloudHub token authentication.");
        } else {
            this.logger.debug("Using CloudHub username/password authentication because the username is set.");
        }
        if (this.apiToken == null) {
            if (username == null) {
                throw new IllegalArgumentException("null username");
            }
            if (password == null) {
                throw new IllegalArgumentException("null password");
            }
        }
        this.url = !url.endsWith("/") ? url + "/" : url;
        this.username = username;
        this.password = password;
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getClasses().add(JacksonJsonProvider.class);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JacksonJsonProvider jsonProvider = new JacksonJsonProvider((org.codehaus.jackson.map.ObjectMapper)mapper);
        clientConfig.getSingletons().add(jsonProvider);
        this.client = Client.create((ClientConfig)clientConfig);
        if (debug) {
            this.client.addFilter((ClientFilter)new LoggingFilter());
        }
    }

    protected final String getUrl() {
        return this.url;
    }

    protected final String getUsername() {
        return this.username;
    }

    protected final String getPassword() {
        return this.password;
    }

    protected final String getAPIURL() {
        return this.url + "api/";
    }

    protected WebResource.Builder createBuilder(String path) {
        WebResource resource = this.createResource(path);
        return this.authorizeResource(resource);
    }

    private WebResource.Builder authorizeResource(WebResource pathResource) {
        if (this.apiToken == null) {
            return pathResource.header("Authorization", (Object)("Basic " + new String(Base64.encode((String)(this.username + ":" + this.password)), Charset.forName("ASCII"))));
        }
        return pathResource.header("X-ION-Authenticate", (Object)this.apiToken);
    }

    private WebResource createResource(String path) {
        return this.client.resource(this.getAPIURL()).path(path);
    }

    @Override
    public final DomainConnection on(String domain) {
        return new DomainConnection(this, domain);
    }

    @Override
    public final boolean test() {
        try {
            this.createBuilder("applications/").get(Object.class);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public final List<Application> listApplications() {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.createBuilder("applications/").type(MediaType.APPLICATION_JSON_TYPE)).get(ClientResponse.class);
        this.handleErrors(response);
        return (List)response.getEntity((GenericType)new GenericType<List<Application>>(){});
    }

    @Override
    @Deprecated
    public final Notification createNotification(String text, Notification.Priority priority, String domain, Map<String, String> customProperties) {
        Notification notification = new Notification();
        notification.setMessage(text);
        notification.setDomain(domain);
        notification.setPriority(priority);
        notification.setCustomProperties(customProperties);
        return this.create(notification);
    }

    @Override
    public final Notification create(Notification notification) {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.createBuilder("notifications/").type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)notification);
        this.handleErrors(response);
        WebResource.Builder notificationResource = this.authorizeResource(this.client.resource(response.getLocation()));
        response = (ClientResponse)notificationResource.get(ClientResponse.class);
        this.handleErrors(response);
        return (Notification)response.getEntity(Notification.class);
    }

    @Override
    public final NotificationResults listNotifications(Integer maxResults, Integer offset, String tenantId) {
        WebResource resource = this.createResource("/notifications");
        if (maxResults != null) {
            resource.queryParam("maxResults", maxResults.toString());
        }
        if (offset != null) {
            resource.queryParam("offset", offset.toString());
        }
        if (tenantId != null) {
            resource.queryParam("tenantId", tenantId);
        }
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.authorizeResource(resource).type(MediaType.APPLICATION_JSON_TYPE)).get(ClientResponse.class);
        this.handleErrors(response);
        return (NotificationResults)response.getEntity(NotificationResults.class);
    }

    @Override
    public final void dismissNotification(String href) {
        WebResource.Builder resource = this.authorizeResource(this.client.resource(href));
        ClientResponse response = (ClientResponse)((WebResource.Builder)resource.type(MediaType.APPLICATION_JSON_TYPE)).delete(ClientResponse.class);
        this.handleErrors(response);
    }

    @Override
    public final void dismissAllNotifications() {
        WebResource.Builder resource = this.createBuilder("notifications/");
        ClientResponse response = (ClientResponse)((WebResource.Builder)resource.type(MediaType.APPLICATION_JSON_TYPE)).delete(ClientResponse.class);
        this.handleErrors(response);
    }

    protected void handleErrors(ClientResponse response) {
        if (response.getStatus() == 404) {
            throw new CloudHubException("That resource was not found.");
        }
        if (response.getStatus() == 401) {
            throw new CloudHubException("Invalid username or password.");
        }
        if (response.getStatus() == 403) {
            throw new CloudHubException("You do not have access to perform that action.");
        }
        if (response.getStatus() >= 400) {
            if (response.getType() != null && response.getType().isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
                Map responseProps = (Map)response.getEntity(Map.class);
                throw new CloudHubException((String)responseProps.get("message"));
            }
            String text = (String)response.getEntity(String.class);
            throw new CloudHubException("Error " + response.getStatus() + ". " + text);
        }
    }

    public static class ObjectMapper
    extends org.codehaus.jackson.map.ObjectMapper {
        public ObjectMapper() {
            this.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        }
    }
}

