/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.cloudhub.client;

import com.mulesoft.cloudhub.client.Application;
import com.mulesoft.cloudhub.client.ApplicationStatusChange;
import com.mulesoft.cloudhub.client.ApplicationUpdateInfo;
import com.mulesoft.cloudhub.client.Connection;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.MediaType;

public class DomainConnection
extends Connection {
    public static final String DEFAULT_MULE_VERSION = "3.3.1";
    public static final int DEFAULT_WORKERS = 1;
    public static final long DEFAULT_MAX_WAIT_TIME = 120000L;
    private final String domain;

    public DomainConnection(Connection connection, String domain) {
        super(connection.getUrl(), connection.getUsername(), connection.getPassword());
        if (domain == null) {
            throw new IllegalArgumentException("null domain");
        }
        this.domain = domain;
    }

    public final boolean available() {
        ClientResponse clientResponse = this.createBuilder("applications/available/" + this.domain).head();
        return clientResponse.getStatus() == 404;
    }

    public final Application.Status status() {
        ClientResponse response = (ClientResponse)this.createApplicationBuilder(this.domain + "/status").get(ClientResponse.class);
        this.handleErrors(response);
        return Application.Status.valueOf((String)response.getEntity(String.class));
    }

    public final String getDomain() {
        return this.domain;
    }

    protected final void ensureCloudHubApplicationExists(String domain) {
        if (this.available()) {
            throw new RuntimeException("CloudHub Application <" + domain + "> does not exit on <" + this.getUrl() + ">");
        }
    }

    public final void update(ApplicationUpdateInfo application) {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.createApplicationBuilder(this.domain).type(MediaType.APPLICATION_JSON_TYPE)).put(ClientResponse.class, (Object)application);
        this.handleErrors(response);
    }

    public final void deploy(File file) {
        this.deploy(file, DEFAULT_MULE_VERSION, 1, 120000L, Collections.<String, String>emptyMap());
    }

    public final void deploy(File file, ApplicationUpdateInfo application, int waitForStart) {
        this.deploy(file, application.getMuleVersion(), (int)application.getWorkers(), (long)waitForStart, application.getProperties());
    }

    public final void deploy(File file, String muleVersion, int workers, long maxWaitTime, Map<String, String> properties) {
        try {
            this.deployFromStream(new FileInputStream(file), file.getName(), muleVersion, workers, maxWaitTime, properties);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File does not exist", e);
        }
    }

    public final void deploy(InputStream file, String muleVersion, int workers, long maxWaitTime, Map<String, String> properties) {
        this.deployFromStream(file, this.getDomain() + ".zip", muleVersion, workers, maxWaitTime, properties);
    }

    private final void deployFromStream(InputStream file, String fileName, String muleVersion, int workers, long maxWaitTime, Map<String, String> properties) {
        this.ensureCloudHubApplicationExists(this.getDomain());
        Application application = this.get();
        ApplicationUpdateInfo appUdateInfo = new ApplicationUpdateInfo(application);
        if (!application.getSupportedVersions().contains(muleVersion)) {
            throw new IllegalArgumentException("Requested mule version <" + muleVersion + "> is not one of supported versions <" + application.getSupportedVersions() + ">");
        }
        if (workers > application.getRemainingWorkerCount()) {
            throw new IllegalArgumentException("Requested <" + workers + "> workers but only <" + application.getRemainingWorkerCount() + "> are remaining");
        }
        switch (application.getStatus()) {
            case STARTED: 
            case UNDEPLOYED: 
            case DEPLOY_FAILED: {
                boolean updated = false;
                if (workers != application.getWorkers()) {
                    appUdateInfo.setWorkers(workers);
                    updated = true;
                }
                if (!muleVersion.equals(application.getMuleVersion())) {
                    appUdateInfo.setMuleVersion(muleVersion);
                    updated = true;
                }
                if (!fileName.equals(application.getFilename())) {
                    appUdateInfo.setFilename(fileName);
                    updated = true;
                }
                if (properties != null && !((Object)properties).equals(application.getProperties())) {
                    appUdateInfo.setProperties(properties);
                    updated = true;
                }
                if (updated) {
                    this.update(appUdateInfo);
                }
                ClientResponse response = (ClientResponse)((WebResource.Builder)this.createApplicationBuilder(this.getDomain() + "/deploy").type(MediaType.APPLICATION_OCTET_STREAM_TYPE)).post(ClientResponse.class, (Object)file);
                this.handleErrors(response);
                break;
            }
            case DEPLOYING: {
                throw new IllegalStateException("Another deployment is in progress");
            }
            default: {
                throw new IllegalStateException("Unhandled status <" + (Object)((Object)application.getStatus()) + ">");
            }
        }
        this.waitForStart(maxWaitTime);
    }

    private void waitForStart(long maxWaitTime) {
        if (maxWaitTime == 0L) {
            return;
        }
        long before = System.currentTimeMillis();
        while (System.currentTimeMillis() - before < maxWaitTime) {
            Application latestApplication = this.get();
            Application.Status status = latestApplication.getDeploymentUpdateStatus() != null ? latestApplication.getDeploymentUpdateStatus() : latestApplication.getStatus();
            switch (status) {
                case DEPLOY_FAILED: {
                    throw new RuntimeException("Application " + this.domain + " failed to start.");
                }
                case STARTED: {
                    return;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        throw new RuntimeException("Waited on <" + this.getDomain() + "> deployment for <" + maxWaitTime + "> ms");
    }

    public final void stop() {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.createApplicationBuilder(this.domain + "/status/").type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)new ApplicationStatusChange(ApplicationStatusChange.ApplicationStatus.stop));
        this.handleErrors(response);
    }

    public final void start(Long maxWaitTime) {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.createApplicationBuilder(this.domain + "/status/").type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)new ApplicationStatusChange(ApplicationStatusChange.ApplicationStatus.start));
        this.handleErrors(response);
        this.waitForStart(maxWaitTime);
    }

    public void delete() {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.createApplicationBuilder(this.domain).type(MediaType.APPLICATION_JSON_TYPE)).delete(ClientResponse.class);
        this.handleErrors(response);
    }

    protected final WebResource.Builder createApplicationBuilder(String path) {
        return this.createBuilder("applications/" + path);
    }

    public Application get() {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.createApplicationBuilder(this.domain).type(MediaType.APPLICATION_JSON_TYPE)).get(ClientResponse.class);
        this.handleErrors(response);
        return (Application)response.getEntity(Application.class);
    }
}

