/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.cloudhub.client;

import com.mulesoft.ch.rest.model.Application;
import com.mulesoft.ch.rest.model.ApplicationStatus;
import com.mulesoft.ch.rest.model.ApplicationStatusChange;
import com.mulesoft.ch.rest.model.ApplicationUpdateInfo;
import com.mulesoft.ch.rest.model.Deployment;
import com.mulesoft.ch.rest.model.Deployments;
import com.mulesoft.ch.rest.model.Instance;
import com.mulesoft.ch.rest.model.LogLine;
import com.mulesoft.ch.rest.model.LogLineWrapperV2;
import com.mulesoft.ch.rest.model.LogRequest;
import com.mulesoft.ch.rest.model.LogResults;
import com.mulesoft.ch.rest.model.Tenant;
import com.mulesoft.ch.rest.model.TenantResults;
import com.mulesoft.cloudhub.client.CloudHubConnectionI;
import com.mulesoft.cloudhub.client.CloudHubConnectionImpl;
import com.mulesoft.cloudhub.client.CloudHubDomainConnectionI;
import com.mulesoft.cloudhub.client.CloudHubException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;

public class CloudHubDomainConnectionImpl
extends CloudHubConnectionImpl
implements CloudHubDomainConnectionI {
    private String domain;

    protected CloudHubDomainConnectionImpl(CloudHubConnectionI con, String domain) {
        super(con.getUrl(), con.getUsername(), con.getPassword(), null, false);
        this.domain = domain;
    }

    protected CloudHubDomainConnectionImpl(CloudHubConnectionI con, boolean csAuthentication, String domain) {
        super(con.getUrl(), con.getAccessToken(), con.getEnvironmentId(), false);
        this.domain = domain;
    }

    public CloudHubDomainConnectionImpl(String url, String accessToken, boolean debug) {
        this.accessToken = accessToken;
        this.init(url, debug);
    }

    public CloudHubDomainConnectionImpl(String url, String accessToken, String environmentId, boolean debug) {
        this.accessToken = accessToken;
        this.environmentId = environmentId;
        this.init(url, debug);
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public Application retrieveApplication() throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)this.createApplicationDomainBuilder("").get(ClientResponse.class);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            return (Application)clientResponse.getEntity(Application.class);
        }
        throw this.buildException(clientResponse);
    }

    @Override
    public LogResults retrieveApplicationLog(Map<String, String> queryParams) throws CloudHubException {
        if (this.applicationHasNewLogging()) {
            return this.retrieveApplicationLog_v2(queryParams);
        }
        return this.retrieveApplicationLog_v1(queryParams);
    }

    protected boolean applicationHasNewLogging() throws CloudHubException {
        Application app = this.retrieveApplication();
        return app.isLoggingNgEnabled();
    }

    public LogResults retrieveApplicationLog_v1(Map<String, String> queryParams) throws CloudHubException {
        ClientResponse clientResponse;
        WebResource resource = this.createResource("/applications/" + this.domain + "/logs");
        if (queryParams != null && !queryParams.isEmpty()) {
            for (String key : queryParams.keySet()) {
                resource = resource.queryParam(key, queryParams.get(key));
            }
        }
        if (ClientResponse.Status.OK.equals((Object)(clientResponse = (ClientResponse)this.authorizeResource(resource).get(ClientResponse.class)).getClientResponseStatus())) {
            return (LogResults)clientResponse.getEntity(LogResults.class);
        }
        throw this.buildException(clientResponse);
    }

    public LogResults retrieveApplicationLog_v2(Map<String, String> queryParams) throws CloudHubException {
        ClientResponse clientResponse;
        Deployment lastDeployment = this.getLastDeployment();
        if (!queryParams.containsKey("search") && !queryParams.containsKey("priority")) {
            WebResource resource = this.createResource("/v2/applications/" + this.domain + "/deployments/" + lastDeployment.getDeploymentId() + "/logs");
            clientResponse = (ClientResponse)this.authorizeResource(resource).get(ClientResponse.class);
            if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
                return (LogResults)clientResponse.getEntity(LogResults.class);
            }
        } else {
            LogRequest logRequest = new LogRequest();
            if (queryParams.containsKey("search")) {
                logRequest.setText(queryParams.get("search"));
            }
            if (queryParams.containsKey("priority")) {
                logRequest.setPriority(queryParams.get("priority"));
            }
            logRequest.setLimitMsgLen(1000L);
            logRequest.setDeploymentId(lastDeployment.getDeploymentId());
            WebResource resource = this.createResource("/v2/applications/" + this.domain + "/logs");
            clientResponse = (ClientResponse)((WebResource.Builder)this.authorizeResource(resource).type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)logRequest);
            if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
                LogLineWrapperV2[] logs = (LogLineWrapperV2[])clientResponse.getEntity(LogLineWrapperV2[].class);
                LogResults logResults = new LogResults();
                logResults.setData(this.logsToList(logs));
                logResults.setTotal(new Long(logResults.getData().size()));
                return logResults;
            }
        }
        throw this.buildException(clientResponse);
    }

    private List<LogLine> logsToList(LogLineWrapperV2[] logs) {
        ArrayList<LogLine> logLines = new ArrayList<LogLine>();
        for (LogLineWrapperV2 log : logs) {
            logLines.add(log.getEvent());
        }
        return logLines;
    }

    public Deployment getLastDeployment() throws CloudHubException {
        Deployments deployments;
        WebResource resource = this.createResource("/v2/applications/" + this.domain + "/deployments");
        resource = resource.queryParam("orderByDate", "DESC");
        ClientResponse clientResponse = (ClientResponse)this.authorizeResource(resource = resource.queryParam("loggingVersion", "VERSION_2")).get(ClientResponse.class);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus()) && (deployments = (Deployments)clientResponse.getEntity(Deployments.class)).getData().size() > 0) {
            return (Deployment)deployments.getData().get(0);
        }
        throw this.buildException(clientResponse);
    }

    @Override
    public File downloadApplicationLog(Map<String, String> queryParams) throws CloudHubException {
        if (this.applicationHasNewLogging()) {
            return this.downloadApplicationLog_v2(queryParams);
        }
        return this.downloadApplicationLog_v1(queryParams);
    }

    public File downloadApplicationLog_v1(Map<String, String> queryParams) throws CloudHubException {
        ClientResponse clientResponse;
        WebResource resource = this.createResource("/applications/" + this.domain + "/logs/download");
        if (queryParams != null && !queryParams.isEmpty()) {
            for (String key : queryParams.keySet()) {
                resource = resource.queryParam(key, queryParams.get(key));
            }
        }
        if (ClientResponse.Status.OK.equals((Object)(clientResponse = (ClientResponse)this.authorizeResource(resource).get(ClientResponse.class)).getClientResponseStatus())) {
            return (File)clientResponse.getEntity(File.class);
        }
        throw this.buildException(clientResponse);
    }

    public File downloadApplicationLog_v2(Map<String, String> queryParams) throws CloudHubException {
        ClientResponse clientResponse;
        Deployment lastDeployment = this.getLastDeployment();
        Instance instance = (Instance)lastDeployment.getInstances().get(0);
        WebResource resource = this.createResource("/v2/applications/" + this.domain + "/instances/" + instance.getInstanceId() + "/log-file");
        if (queryParams != null && !queryParams.isEmpty()) {
            for (String key : queryParams.keySet()) {
                resource = resource.queryParam(key, queryParams.get(key));
            }
        }
        if (ClientResponse.Status.OK.equals((Object)(clientResponse = (ClientResponse)this.authorizeResource(resource).get(ClientResponse.class)).getClientResponseStatus())) {
            return (File)clientResponse.getEntity(File.class);
        }
        throw this.buildException(clientResponse);
    }

    @Override
    public ApplicationStatus retrieveApplicationStatus() throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)this.createApplicationDomainBuilder("status").get(ClientResponse.class);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            return ApplicationStatus.valueOf((String)((String)clientResponse.getEntity(String.class)));
        }
        throw this.buildException(clientResponse);
    }

    @Override
    public void deployApplication(InputStream fileStream, long maxWaitTime) {
        boolean failedBefore = this.failedBefore();
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainBuilder("deploy").type(MediaType.APPLICATION_OCTET_STREAM_TYPE)).post(ClientResponse.class, (Object)fileStream);
        if (!ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            throw this.buildException(clientResponse);
        }
        this.waitForFinish(maxWaitTime, failedBefore);
    }

    @Override
    public void deployApplication(File file, long maxWaitTime) {
        try {
            this.deployApplication(new FileInputStream(file), maxWaitTime);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File does not exist", e);
        }
    }

    @Override
    public Application updateApplication(ApplicationUpdateInfo newApplicationInfo) throws CloudHubException {
        Application application = this.retrieveApplication();
        ApplicationUpdateInfo oldApplicationInfo = new ApplicationUpdateInfo(application);
        if (!oldApplicationInfo.equals((Object)newApplicationInfo)) {
            ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainBuilder("").type(MediaType.APPLICATION_JSON_TYPE)).put(ClientResponse.class, (Object)newApplicationInfo);
            if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
                return (Application)clientResponse.getEntity(Application.class);
            }
            throw this.buildException(clientResponse);
        }
        return application;
    }

    @Override
    public void updateApplicationStatus(ApplicationStatusChange applicationStatusChange, long maxWaitTime) throws CloudHubException {
        boolean failedBefore = this.failedBefore();
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainBuilder("status").type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)applicationStatusChange);
        if (!ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            throw this.buildException(clientResponse);
        }
        this.waitForFinish(maxWaitTime, failedBefore);
    }

    @Override
    public void deleteApplication() throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)this.createApplicationDomainBuilder().delete(ClientResponse.class);
        if (!ClientResponse.Status.NO_CONTENT.equals((Object)clientResponse.getClientResponseStatus())) {
            throw this.buildException(clientResponse);
        }
    }

    @Override
    public TenantResults retrieveTenants(Integer limit, Integer offset, String query, Boolean enabled) throws CloudHubException {
        ClientResponse clientResponse;
        WebResource resource = this.createResource("/applications/" + this.domain + "/tenants");
        if (limit != null) {
            resource = resource.queryParam("limit", String.valueOf(limit));
        }
        if (offset != null) {
            resource = resource.queryParam("offset", String.valueOf(offset));
        }
        if (enabled != null) {
            resource = resource.queryParam("enabled", enabled.toString());
        }
        if (query != null) {
            resource = resource.queryParam("search", query);
        }
        if (ClientResponse.Status.OK.equals((Object)(clientResponse = (ClientResponse)((WebResource.Builder)this.authorizeResource(resource).type(MediaType.APPLICATION_JSON_TYPE)).get(ClientResponse.class)).getClientResponseStatus())) {
            return (TenantResults)clientResponse.getEntity(TenantResults.class);
        }
        throw this.buildException(clientResponse);
    }

    @Override
    public Tenant retrieveTenant(String tenantId) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainTenantBuilder(tenantId).type(MediaType.APPLICATION_JSON_TYPE)).get(ClientResponse.class);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            return (Tenant)clientResponse.getEntity(Tenant.class);
        }
        throw this.buildException(clientResponse);
    }

    @Override
    public InputStream retrieveTenantClientCertificates(String tenantId) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainTenantBuilder(tenantId + "/openVPNConfigs/").type(MediaType.APPLICATION_JSON_TYPE)).get(ClientResponse.class);
        return (InputStream)clientResponse.getEntity(InputStream.class);
    }

    @Override
    public Tenant createTenant(Tenant tenant) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainTenantBuilder("").type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)tenant);
        if (ClientResponse.Status.CREATED.equals((Object)clientResponse.getClientResponseStatus())) {
            return (Tenant)clientResponse.getEntity(Tenant.class);
        }
        throw this.buildException(clientResponse);
    }

    @Override
    public Tenant updateTenant(Tenant tenant) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainTenantBuilder(tenant.getId()).type(MediaType.APPLICATION_JSON_TYPE)).put(ClientResponse.class, (Object)tenant);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            return (Tenant)clientResponse.getEntity(Tenant.class);
        }
        throw this.buildException(clientResponse);
    }

    @Override
    public void deleteTenant(String tenantId) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainTenantBuilder(tenantId).type(MediaType.APPLICATION_JSON_TYPE)).delete(ClientResponse.class);
        if (!ClientResponse.Status.NO_CONTENT.equals((Object)clientResponse.getClientResponseStatus())) {
            throw this.buildException(clientResponse);
        }
    }

    @Override
    public void deleteTenants(List<String> tenantIds) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainTenantBuilder("").type(MediaType.APPLICATION_JSON_TYPE)).delete(ClientResponse.class, tenantIds);
        if (!ClientResponse.Status.NO_CONTENT.equals((Object)clientResponse.getClientResponseStatus())) {
            throw this.buildException(clientResponse);
        }
    }

    @Override
    public void deleteTenantClientCertificates(String tenantId) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainTenantBuilder(tenantId + "/openVPNConfigs/").type(MediaType.APPLICATION_JSON_TYPE)).delete(ClientResponse.class);
        if (!ClientResponse.Status.NO_CONTENT.equals((Object)clientResponse.getClientResponseStatus())) {
            throw this.buildException(clientResponse);
        }
    }

    private final WebResource.Builder createApplicationDomainBuilder(String path) {
        return this.createBuilder("applications/" + this.domain + "/" + path);
    }

    private final WebResource.Builder createApplicationDomainBuilder() {
        return this.createBuilder("applications/" + this.domain);
    }

    private final WebResource.Builder createApplicationDomainTenantBuilder(String path) {
        return this.createBuilder("applications/" + this.domain + "/tenants/" + path);
    }

    private void waitForFinish(long maxWaitTime, boolean failedBefore) {
        ApplicationStatus status;
        Application latestApplication;
        if (maxWaitTime == 0L) {
            return;
        }
        if (maxWaitTime == 1L) {
            maxWaitTime = Long.MAX_VALUE;
        }
        long before = System.currentTimeMillis();
        while (System.currentTimeMillis() - before < maxWaitTime) {
            latestApplication = this.retrieveApplication();
            status = latestApplication.getDeploymentUpdateStatus();
            if (!failedBefore && status != null && status.equals((Object)ApplicationStatus.DEPLOY_FAILED)) {
                throw new CloudHubException("Application " + this.domain + " failed to start.", String.valueOf(ClientResponse.Status.EXPECTATION_FAILED.getStatusCode()));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        if ((status = (latestApplication = this.retrieveApplication()).getDeploymentUpdateStatus()) == null && latestApplication.getStatus().equals((Object)ApplicationStatus.STARTED)) {
            return;
        }
        if (status == null && latestApplication.getStatus().equals((Object)ApplicationStatus.UNDEPLOYED)) {
            return;
        }
        if (status.equals((Object)ApplicationStatus.DEPLOY_FAILED)) {
            throw new CloudHubException("Application " + this.domain + " failed to start.", String.valueOf(ClientResponse.Status.EXPECTATION_FAILED.getStatusCode()));
        }
        throw new CloudHubException("CloudHub did not finish the process before the specified time", String.valueOf(ClientResponse.Status.GATEWAY_TIMEOUT.getStatusCode()));
    }

    private boolean failedBefore() {
        ApplicationStatus status = this.retrieveApplication().getDeploymentUpdateStatus();
        return status == null ? false : status.equals((Object)ApplicationStatus.DEPLOY_FAILED);
    }

    public static void main(String[] args) {
        String csToken = "635edb51-ad3f-4ce0-ba6f-0571d198258d";
        String environmentId = "552d191be4b0ccf3b4a11936";
        CloudHubConnectionImpl ch = new CloudHubConnectionImpl("https://anypoint.mulesoft.com/cloudhub/", csToken, environmentId, false);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("limit", "100");
        String domain = "dgw-35f22bf0-d696-4e4c-8e46-9332beb8a422";
        CloudHubDomainConnectionI chd = ch.connectWithDomain(domain);
        LogResults logs = chd.retrieveApplicationLog(queryParams);
        System.out.println("V2 >>> " + logs);
        File logFile = chd.downloadApplicationLog(queryParams);
        System.out.println("V2 FILE >>> " + logFile);
    }
}

