/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.cloudhub.client;

import com.mulesoft.ch.rest.model.Account;
import com.mulesoft.ch.rest.model.Application;
import com.mulesoft.ch.rest.model.DomainStatus;
import com.mulesoft.ch.rest.model.Notification;
import com.mulesoft.ch.rest.model.NotificationResults;
import com.mulesoft.cloudhub.client.CloudHubConnectionI;
import com.mulesoft.cloudhub.client.CloudHubDomainConnectionI;
import com.mulesoft.cloudhub.client.CloudHubDomainConnectionImpl;
import com.mulesoft.cloudhub.client.CloudHubException;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.core.util.Base64;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudHubConnectionImpl
implements CloudHubConnectionI {
    protected Logger logger = LoggerFactory.getLogger(CloudHubConnectionImpl.class);
    @Deprecated
    public static final String DEFAULT_URL = "https://cloudhub.io/";
    public static final String NEW_DEFAULT_URL = "https://anypoint.mulesoft.com/cloudhub/";
    protected String url;
    protected Client client;
    protected String username;
    protected String password;
    protected String apiToken;
    protected Integer connectionTimeout;
    protected Integer readTimeout;
    protected String accessToken;
    protected String environmentId;
    protected boolean csAuthentication = false;

    protected void init(String url, boolean debug) {
        this.url = StringUtils.isBlank((CharSequence)url) ? (this.csAuthentication ? NEW_DEFAULT_URL : DEFAULT_URL) : (url.endsWith("/") ? url : url + "/");
        this.client = Client.create((ClientConfig)this.getClientConfig());
        this.client.setConnectTimeout(this.connectionTimeout);
        this.client.setReadTimeout(this.readTimeout);
        if (debug) {
            this.client.addFilter((ClientFilter)new LoggingFilter());
        }
    }

    protected CloudHubConnectionImpl() {
    }

    public CloudHubConnectionImpl(String url, String accessToken, boolean debug) {
        this.csAuthentication = true;
        this.accessToken = accessToken;
        this.init(url, debug);
    }

    public CloudHubConnectionImpl(String url, String accessToken, String environmentId, boolean debug) {
        this.csAuthentication = true;
        this.accessToken = accessToken;
        this.environmentId = environmentId;
        this.init(url, debug);
    }

    public CloudHubConnectionImpl(String url, String username, String password, String sandbox, boolean debug) {
        this(url, username, password, sandbox, 0, 0, debug);
    }

    public CloudHubConnectionImpl(String url, String username, String password, String sandbox, Integer readTimeout, Integer connectionTimeout, boolean debug) {
        if (StringUtils.isBlank((CharSequence)username)) {
            this.apiToken = System.getProperty("cloudhub.api.token") != null ? System.getProperty("cloudhub.api.token") : System.getProperty("ion.api.token");
            Validate.notNull((Object)this.apiToken, (String)"apiToken can not be null if username was not provided", (Object[])new Object[0]);
            this.logger.debug("Using CloudHub token authentication.");
        } else {
            Validate.notNull((Object)password, (String)"Password can not be null if username is provided.", (Object[])new Object[0]);
            this.logger.debug("Using CloudHub username/password authentication because the username is set.");
        }
        this.username = StringUtils.isNotBlank((CharSequence)sandbox) ? username + "@" + sandbox : username;
        this.password = password;
        this.readTimeout = readTimeout;
        this.connectionTimeout = connectionTimeout;
        this.init(url, debug);
    }

    @Override
    public CloudHubConnectionI createConnection(String url, String username, String password, String sandbox, Integer readTimeout, Integer connectionTimeout) {
        return new CloudHubConnectionImpl(url, username, password, sandbox, readTimeout, connectionTimeout, false);
    }

    @Override
    public CloudHubDomainConnectionI connectWithDomain(String domain) {
        if (!StringUtils.isBlank((CharSequence)domain)) {
            if (this.csAuthentication) {
                return new CloudHubDomainConnectionImpl(this, true, domain);
            }
            return new CloudHubDomainConnectionImpl(this, domain);
        }
        throw new IllegalArgumentException("Domain must not be null or empty");
    }

    @Override
    public Account retrieveAccount() throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createBuilder("account/").type(MediaType.APPLICATION_JSON_TYPE)).get(ClientResponse.class);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            return (Account)clientResponse.getEntity(Account.class);
        }
        throw this.buildException(clientResponse);
    }

    @Override
    public boolean isDomainAvailable(String domain) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)this.createBuilder("applications/domains/" + domain).get(ClientResponse.class);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            return ((DomainStatus)clientResponse.getEntity(DomainStatus.class)).isAvailable();
        }
        throw this.buildException(clientResponse);
    }

    @Override
    public Collection<Application> retrieveApplications() {
        ClientResponse clientResponse = (ClientResponse)this.createApplicationBuilder("").get(ClientResponse.class);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            return (Collection)clientResponse.getEntity(Collection.class);
        }
        throw this.buildException(clientResponse);
    }

    @Override
    public Application createApplication(Application application) throws CloudHubException {
        if (this.isDomainAvailable(application.getDomain())) {
            ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationBuilder("").type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)application);
            if (ClientResponse.Status.CREATED.equals((Object)clientResponse.getClientResponseStatus())) {
                return (Application)clientResponse.getEntity(Application.class);
            }
            throw this.buildException(clientResponse);
        }
        throw new CloudHubException("The application's domain is not available", String.valueOf(ClientResponse.Status.CONFLICT.getStatusCode()));
    }

    @Override
    public NotificationResults retrieveNotifications(String domain, String tenantId, Integer limit, Integer offset, Notification.NotificationStatus status, String message) throws CloudHubException {
        ClientResponse clientResponse;
        Validate.notNull((Object)domain, (String)"The domain can not be null", (Object[])new Object[0]);
        WebResource resource = this.createResource("/notifications");
        resource = resource.queryParam("domain", domain);
        if (tenantId != null) {
            resource = resource.queryParam("tenantId", String.valueOf(tenantId));
        }
        if (limit != null) {
            resource = resource.queryParam("limit", String.valueOf(limit));
        }
        if (offset != null) {
            resource = resource.queryParam("offset", String.valueOf(offset));
        }
        if (status != null) {
            resource = resource.queryParam("status", status.toString());
        }
        if (message != null) {
            resource = resource.queryParam("search", message);
        }
        if (ClientResponse.Status.OK.equals((Object)(clientResponse = (ClientResponse)((WebResource.Builder)this.authorizeResource(resource).type(MediaType.APPLICATION_JSON_TYPE)).get(ClientResponse.class)).getClientResponseStatus())) {
            return (NotificationResults)clientResponse.getEntity(NotificationResults.class);
        }
        throw this.buildException(clientResponse);
    }

    @Override
    public Notification retrieveNotification(String notificationId) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createNotificationBuilder(notificationId).type(MediaType.APPLICATION_JSON_TYPE)).get(ClientResponse.class);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            return (Notification)clientResponse.getEntity(Notification.class);
        }
        throw this.buildException(clientResponse);
    }

    @Override
    public Notification createNotification(Notification notification) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createNotificationBuilder("").type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)notification);
        if (ClientResponse.Status.CREATED.equals((Object)clientResponse.getClientResponseStatus())) {
            URI uri = clientResponse.getLocation();
            return new Notification(uri.getPath().substring(uri.getPath().lastIndexOf("/") + 1, uri.getPath().length()));
        }
        throw this.buildException(clientResponse);
    }

    @Override
    public void updateNotificationsStatus(String domain, String tenantId, Notification.NotificationStatus status) throws CloudHubException {
        ClientResponse clientResponse;
        Validate.notNull((Object)domain, (String)"The domain can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)status, (String)"The status can not be null", (Object[])new Object[0]);
        WebResource resource = this.createResource("notifications/").queryParam("domain", domain);
        if (tenantId != null) {
            resource.queryParam("tenantId", tenantId);
        }
        if (!ClientResponse.Status.NO_CONTENT.equals((Object)(clientResponse = (ClientResponse)((WebResource.Builder)this.authorizeResource(resource).type(MediaType.APPLICATION_JSON_TYPE)).put(ClientResponse.class, (Object)status)).getClientResponseStatus())) {
            throw this.buildException(clientResponse);
        }
    }

    @Override
    public void updateNotificationStatus(String notificationId, Notification.NotificationStatus status) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createNotificationBuilder(notificationId).type(MediaType.APPLICATION_JSON_TYPE)).put(ClientResponse.class, (Object)status);
        if (!ClientResponse.Status.NO_CONTENT.equals((Object)clientResponse.getClientResponseStatus())) {
            this.buildException(clientResponse);
        }
    }

    @Override
    public List<String> getSupportedMuleVersions() throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)this.createApplicationBuilder("supportedMuleVersions").get(ClientResponse.class);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            return (List)clientResponse.getEntity(List.class);
        }
        throw this.buildException(clientResponse);
    }

    private ClientConfig getClientConfig() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        clientConfig.getClasses().add(JacksonJsonProvider.class);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JacksonJsonProvider jsonProvider = new JacksonJsonProvider((org.codehaus.jackson.map.ObjectMapper)mapper);
        clientConfig.getSingletons().add(jsonProvider);
        return clientConfig;
    }

    protected WebResource.Builder createBuilder(String path) {
        return this.authorizeResource(this.createResource(path));
    }

    protected WebResource.Builder authorizeResource(WebResource pathResource) {
        if (this.csAuthentication) {
            if (this.environmentId != null) {
                return (WebResource.Builder)pathResource.header("Authorization", (Object)("Bearer " + this.accessToken)).header("X-ANYPNT-ENV-ID", (Object)this.environmentId);
            }
            return pathResource.header("Authorization", (Object)("Bearer " + this.accessToken));
        }
        if (this.apiToken == null) {
            return pathResource.header("Authorization", (Object)("Basic " + new String(Base64.encode((String)(this.username + ":" + this.password)), Charset.forName("ASCII"))));
        }
        return pathResource.header("X-ION-Authenticate", (Object)this.apiToken);
    }

    protected WebResource createResource(String path) {
        return this.client.resource(this.url + "api/").path(path);
    }

    protected final WebResource.Builder createApplicationBuilder(String path) {
        return this.createBuilder("applications/" + path);
    }

    protected final WebResource.Builder createNotificationBuilder(String path) {
        return this.createBuilder("notifications/" + path);
    }

    protected CloudHubException buildException(ClientResponse clientResponse) throws CloudHubException {
        String message = "";
        int status = clientResponse.getStatus();
        message = ClientResponse.Status.BAD_REQUEST.equals((Object)clientResponse.getClientResponseStatus()) ? (String)clientResponse.getEntity(String.class) : clientResponse.getClientResponseStatus().getReasonPhrase();
        return new CloudHubException(message, String.valueOf(status));
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public boolean isCsAuthentication() {
        return this.csAuthentication;
    }

    public static void main(String[] args) {
        String filePath = "dgw-5866bfb8-f0d0-43ff-a11a-4197e9309036b.zip";
        String csToken = "f8ba3832-baed-47ad-8539-87f778136155";
        String domain = "dgw-e1e76e37-70f7-4a0b-93e9-62090ebde476";
        String environment = "1b053013-3055-4e86-85bf-f13ad6be5eed";
        URL url = Thread.currentThread().getContextClassLoader().getResource(filePath);
        try {
            CloudHubConnectionImpl ch = new CloudHubConnectionImpl("https://stgx.anypoint.mulesoft.com/cloudhub/", csToken, "317948ff-f7a3-4755-bec0-945fe14c872a", false);
            HashMap prop = new HashMap();
            Application app = new Application();
            app.setSecureDataGatewayEnabled(false);
            app.setLoggingNgEnabled(true);
            app.setMonitoringAutoRestart(true);
            app.setDomain(domain);
            app.setProperties(prop);
            ch.createApplication(app);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class ObjectMapper
    extends org.codehaus.jackson.map.ObjectMapper {
        public ObjectMapper() {
            this.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        }
    }
}

