/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.muleesb.cloudhub;

import com.mulesoft.muleesb.cloudhub.AbstractCloudHubMojo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="deploy", requiresProject=false, defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class CloudHubDeployMojo
extends AbstractCloudHubMojo {
    @Parameter(property="cloudhub.workers", defaultValue="1")
    protected int workers;
    @Parameter(property="cloudhub.muleVersion")
    protected String muleVersion;
    @Parameter
    protected Map<String, String> properties;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="application")
    protected File application;

    @Override
    public void doExecute() throws MojoExecutionException {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        File file = this.getApplication();
        this.getLog().info((CharSequence)("Deploying application: " + file));
        this.getLog().info((CharSequence)("to domain " + this.domain + " with Mule Runtime " + this.muleVersion + " using " + this.workers + " workers"));
        this.getLog().info((CharSequence)("using properties: " + this.properties));
        try {
            this.cloudhub.deploy(file, this.muleVersion, this.workers, this.timeout, this.properties);
        }
        catch (MojoExecutionException e) {
            this.rollbackDeployment();
            this.getLog().error((CharSequence)("Failed to deploy application: " + e.getMessage()));
            throw e;
        }
    }

    private void rollbackDeployment() {
        try {
            this.cloudhub.undeploy();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Couldn't rollback failed deployment.");
        }
    }

    protected File getApplication() {
        if (this.application == null) {
            String type = this.project.getArtifact().getType();
            if (!"mule".equals(type)) {
                throw new IllegalArgumentException("Project packaging should be mule but is: " + type);
            }
            if (this.project.getAttachedArtifacts().isEmpty()) {
                throw new IllegalArgumentException("No project artifact was found.");
            }
            return ((Artifact)this.project.getAttachedArtifacts().get(0)).getFile();
        }
        return this.application;
    }
}

