/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.ch.rest.model.billing;

import com.mulesoft.ch.rest.model.billing.WorkerType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerTypeInfo {
    private String name;
    private double workerVal;

    public static List<WorkerTypeInfo> toWorkerTypeInfos(List<WorkerType> workerTypes) {
        ArrayList<WorkerTypeInfo> infos = new ArrayList<WorkerTypeInfo>(workerTypes.size());
        for (WorkerType wt : workerTypes) {
            infos.add(new WorkerTypeInfo(wt));
        }
        return infos;
    }

    public WorkerTypeInfo() {
    }

    public WorkerTypeInfo(WorkerType workerType) {
        this.name = workerType.getType();
        this.workerVal = workerType.getWorkerVal();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getWorkerVal() {
        return this.workerVal;
    }

    public void setWorkerVal(double workerVal) {
        this.workerVal = workerVal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        long temp = Double.doubleToLongBits(this.workerVal);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerTypeInfo)) {
            return false;
        }
        WorkerTypeInfo other = (WorkerTypeInfo)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return Double.doubleToLongBits(this.workerVal) == Double.doubleToLongBits(other.workerVal);
    }
}

