/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.dynamics365bc.citizen.internal.config;

import com.mulesoft.connectors.commons.template.config.ConnectorConfig;
import com.mulesoft.connectors.dynamics365bc.api.configuration.StreamingType;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.connection.provider.BasicAuthCitizenConnectionProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.connection.provider.OAuthCitizenConnectionProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.CreateCustomerOperation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.CreateItemOperation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.CreateItemVariantOperation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.CreateSalesOrderOperation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.GetCustomersOperation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.GetItemVariantsOperation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.GetItemsOperation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.GetSalesOrdersOperation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.UpdateCustomerOperation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.UpdateItemOperation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.UpdateItemVariantOperation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.UpdateSalesOrderOperation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.test.DeleteCustomerOperation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.test.DeleteItemOperation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.test.DeleteItemVariantOperation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.test.DeleteSalesOrderOperation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.source.impl.CitizenOnNewOrUpdatedCustomerSource;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.source.impl.CitizenOnNewOrUpdatedItemSource;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.source.impl.CitizenOnNewOrUpdatedSalesOrderSource;
import com.mulesoft.connectors.dynamics365bc.internal.config.MicrosoftDynamics365Configuration;
import com.mulesoft.connectors.dynamics365bc.internal.model.ConfigurationOverrides;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Configuration
@Operations(value={CreateCustomerOperation.class, GetCustomersOperation.class, UpdateCustomerOperation.class, DeleteCustomerOperation.class, CreateItemOperation.class, GetItemsOperation.class, UpdateItemOperation.class, DeleteItemOperation.class, CreateItemVariantOperation.class, GetItemVariantsOperation.class, UpdateItemVariantOperation.class, DeleteItemVariantOperation.class, CreateSalesOrderOperation.class, GetSalesOrdersOperation.class, UpdateSalesOrderOperation.class, DeleteSalesOrderOperation.class})
@ConnectionProviders(value={OAuthCitizenConnectionProvider.class, BasicAuthCitizenConnectionProvider.class})
@Sources(value={CitizenOnNewOrUpdatedCustomerSource.class, CitizenOnNewOrUpdatedItemSource.class, CitizenOnNewOrUpdatedSalesOrderSource.class})
public class CitizenMicrosoftDynamics365Configuration
implements ConnectorConfig {
    @DefaultEncoding
    private String defaultEncoding;
    private Charset charset;
    @Parameter
    @Optional(defaultValue="60")
    @Placement(tab="Advanced")
    @Summary(value="The timeout for request to the remote service.")
    private Integer responseTimeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Placement(tab="Advanced")
    @Summary(value="A time unit which qualifies the Response Timeout}")
    private TimeUnit responseTimeoutUnit = TimeUnit.SECONDS;
    @Parameter
    @Placement(tab="Advanced")
    @Optional(defaultValue="AUTO")
    @Summary(value="Defines if the request should be sent using streaming. Setting the value to AUTO will automatically define the best strategy based on the request content.")
    private StreamingType streamingType;
    private MicrosoftDynamics365Configuration specialistConfig;

    public Charset getCharset() {
        return this.charset;
    }

    public Integer getResponseTimeout() {
        return this.responseTimeout;
    }

    public TimeUnit getResponseTimeoutUnit() {
        return this.responseTimeoutUnit;
    }

    public StreamingType getStreamingType() {
        return this.streamingType;
    }

    public int getResponseTimeoutInMillis() {
        return (int)this.getResponseTimeoutUnit().toMillis(this.getResponseTimeout().intValue());
    }

    public MicrosoftDynamics365Configuration getSpecialist() {
        if (this.specialistConfig == null) {
            this.specialistConfig = new MicrosoftDynamics365Configuration.Builder().withStreamingType(this.streamingType).withResponseTimeoutUnit(this.responseTimeoutUnit).withResponseTimeout(this.responseTimeout).withDefaultEncoding(this.defaultEncoding).withCharset(this.charset).build();
        }
        return this.specialistConfig;
    }

    public ConfigurationOverrides getConfigurationOverride() {
        return new ConfigurationOverrides.Builder().withResponseTimeout(this.getResponseTimeout()).withResponseTimeoutUnit(this.getResponseTimeoutUnit()).withStreamingType(this.getStreamingType()).build();
    }
}

