/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.dynamics365bc.citizen.internal.connection.provider;

import com.mulesoft.connectors.dynamics365bc.citizen.internal.connection.provider.BaseCitizenConnectionProvider;
import com.mulesoft.connectors.dynamics365bc.internal.connection.MicrosoftRestConnection;
import com.mulesoft.connectors.dynamics365bc.internal.connection.provider.BasicAuthConnectionProvider;
import com.mulesoft.connectors.dynamics365bc.internal.model.connection.OptionalTlsParameterGroup;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.security.Username;

@Alias(value="basic")
@DisplayName(value="Basic Auth Connection Provider")
public class BasicAuthCitizenConnectionProvider
extends BaseCitizenConnectionProvider {
    @DisplayName(value="Base Uri")
    @Summary(value="Parameter base URI, each instance/tenant gets its own")
    @Parameter
    @Optional(defaultValue="https://api.businesscentral.dynamics.com/v2.0/<tenantId>/<environment name>/api/v2.0")
    private String baseUri;
    @Parameter
    @Summary(value="The username to authenticate the requests")
    @Username
    protected String username;
    @Parameter
    @Optional
    @Summary(value="The password to authenticate the requests")
    @Password
    protected String password;
    @ParameterGroup(name="tls")
    private OptionalTlsParameterGroup tlsConfig;
    private BasicAuthConnectionProvider delegate;

    private void createDelegate() {
        if (this.delegate == null) {
            this.delegate = new BasicAuthConnectionProvider.Builder(this.getDefaultBaseConfiguration()).withBaseUri(this.baseUri).withUsername(this.username).withPassword(this.password).withTlsConfig(this.tlsConfig).build();
        }
    }

    public void initialise() throws InitialisationException {
        this.createDelegate();
        this.delegate.initialise();
    }

    public void start() throws MuleException {
        this.delegate.start();
    }

    public void stop() throws MuleException {
        this.delegate.stop();
    }

    public MicrosoftRestConnection connect() throws ConnectionException {
        return this.delegate.connect();
    }

    public void disconnect(MicrosoftRestConnection connection) {
        this.delegate.disconnect(connection);
    }

    public ConnectionValidationResult validate(MicrosoftRestConnection connection) {
        return this.delegate.validate(connection);
    }
}

