/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.dynamics365bc.citizen.internal.connection.provider;

import com.mulesoft.connectors.dynamics365bc.citizen.internal.connection.provider.BaseCitizenConnectionProvider;
import com.mulesoft.connectors.dynamics365bc.internal.connection.MicrosoftRestConnection;
import com.mulesoft.connectors.dynamics365bc.internal.connection.provider.OAuthcConnectionProvider;
import com.mulesoft.connectors.dynamics365bc.internal.model.connection.OptionalTlsParameterGroup;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.sdk.api.connectivity.NoConnectivityTest;

@Alias(value="oauth2")
@DisplayName(value="OAuth2 Connection Provider")
@AuthorizationCode(accessTokenUrl="https://login.microsoftonline.com/<tenantId>/oauth2/v2.0/token", authorizationUrl="https://login.microsoftonline.com/<tenantId>/oauth2/v2.0/authorize", defaultScopes="offline_access https://api.businesscentral.dynamics.com/.default")
public class OAuthCitizenConnectionProvider
extends BaseCitizenConnectionProvider
implements NoConnectivityTest {
    @DisplayName(value="Base Uri")
    @Summary(value="Parameter base URI, each instance/tenant gets its own")
    @Parameter
    @Optional(defaultValue="https://api.businesscentral.dynamics.com/v2.0/<tenantId>/<environment name>/api/v2.0")
    private String baseUri;
    @ParameterGroup(name="tls")
    private OptionalTlsParameterGroup tlsConfig;
    private AuthorizationCodeState oauthState;
    private OAuthcConnectionProvider delegate;

    public void createDelegate() {
        if (this.delegate == null) {
            this.delegate = new OAuthcConnectionProvider.Builder(this.getDefaultBaseConfiguration()).withBaseUri(this.baseUri).withTlsConfig(this.tlsConfig).withOauthState(this.oauthState).build();
        }
    }

    public MicrosoftRestConnection connect() throws ConnectionException {
        if (this.delegate == null) {
            this.createDelegate();
            try {
                this.delegate.initialise();
            }
            catch (InitialisationException e) {
                throw new ConnectionException(e.getMessage());
            }
            this.delegate.start();
        }
        return this.delegate.connect();
    }

    public void disconnect(MicrosoftRestConnection connection) {
        this.delegate.disconnect(connection);
    }

    public ConnectionValidationResult validate(MicrosoftRestConnection connection) {
        return this.delegate.validate(connection);
    }

    public void initialise() {
    }

    public void start() {
    }

    public void stop() {
        if (this.delegate != null) {
            this.delegate.stop();
        }
    }
}

