/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.sample;

import com.mulesoft.connectors.dynamics365bc.api.HttpResponseAttributes;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.config.CitizenMicrosoftDynamics365Configuration;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.utils.CitizenUtils;
import com.mulesoft.connectors.dynamics365bc.internal.connection.MicrosoftRestConnection;
import com.mulesoft.connectors.dynamics365bc.internal.util.RestRequestBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.sdk.api.annotation.param.Config;
import org.mule.sdk.api.annotation.param.Connection;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.sdk.api.data.sample.SampleDataProvider;
import org.mule.sdk.api.runtime.operation.Result;

public class GenericEntitySampleDataProvider
implements SampleDataProvider<InputStream, HttpResponseAttributes> {
    private static final byte[] emptyArray = new byte[0];
    private static final String ID_EXPRESSION = "#[output java --- payload.value[0].id]";
    private static final String NESTED_ARRAY_EXPRESSION = "#[output application/json --- payload - '%s' ++ { %s: [payload.%s[0]]}]";
    @Connection
    private MicrosoftRestConnection connection;
    @Config
    private CitizenMicrosoftDynamics365Configuration config;
    @Parameter
    private String companyId;
    private String entity;
    private String expandProperty;

    public GenericEntitySampleDataProvider() {
    }

    public GenericEntitySampleDataProvider(String entity, String expandProperty) {
        this.entity = entity;
        this.expandProperty = expandProperty;
    }

    public String getId() {
        return this.getClass().getSimpleName();
    }

    public Result<InputStream, HttpResponseAttributes> getSample() throws SampleDataException {
        try {
            String sampleCompanyId = this.companyId;
            String sampleEntityId = this.findEntityId(sampleCompanyId, this.entity);
            if (sampleEntityId != null) {
                RestRequestBuilder builder = new RestRequestBuilder(this.connection.getBaseUri(), "/companies({id})/{entity}({entity_id})", HttpConstants.Method.GET).addUriParam("entity_id", (Object)sampleEntityId).addHeader("accept", (Object)"application/json").setQueryParamFormat(RestRequestBuilder.QueryParamFormat.MULTIMAP).addQueryParam("$expand", (Object)this.expandProperty).addUriParam("id", (Object)sampleCompanyId).addUriParam("entity", (Object)this.entity);
                org.mule.runtime.extension.api.runtime.operation.Result sampleData = (org.mule.runtime.extension.api.runtime.operation.Result)this.connection.request(builder, 30000, MediaType.APPLICATION_JSON, null).get();
                InputStream data = (InputStream)sampleData.getOutput();
                if (this.expandProperty != null) {
                    String nesterArrayExpFormatted = String.format(NESTED_ARRAY_EXPRESSION, this.expandProperty, this.expandProperty, this.expandProperty);
                    sampleData = sampleData.copy().output(this.connection.applyExpression(nesterArrayExpFormatted, new TypedValue((Object)data, DataType.JSON_STRING)).getValue()).build();
                }
                return CitizenUtils.toSdkResult2(sampleData);
            }
            return Result.builder().output((Object)new ByteArrayInputStream(emptyArray)).build();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SampleDataException(e.getMessage(), "InterruptedException");
        }
        catch (ExecutionException e) {
            throw new SampleDataException(e.getMessage(), "ExecutionException");
        }
    }

    private String findEntityId(String companyId, String entity) throws ExecutionException, InterruptedException {
        RestRequestBuilder builder = new RestRequestBuilder(this.connection.getBaseUri(), "/companies({id})/{entity}?$top=1&$select=id", HttpConstants.Method.GET).setQueryParamFormat(RestRequestBuilder.QueryParamFormat.MULTIMAP).addHeader("accept", (Object)"application/json").addUriParam("id", (Object)companyId).addUriParam("entity", (Object)entity);
        InputStream data = (InputStream)((org.mule.runtime.extension.api.runtime.operation.Result)this.connection.request(builder, 30000, MediaType.APPLICATION_JSON, null).get()).getOutput();
        return (String)this.connection.applyExpression(ID_EXPRESSION, new TypedValue((Object)data, DataType.JSON_STRING)).getValue();
    }
}

