/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.sample;

import com.mulesoft.connectors.dynamics365bc.api.HttpResponseAttributes;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.builder.ExpandableEntityParamsBuilder;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.config.CitizenMicrosoftDynamics365Configuration;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.CitizenPagingProviderWrapper;
import com.mulesoft.connectors.dynamics365bc.internal.connection.MicrosoftRestConnection;
import com.mulesoft.connectors.dynamics365bc.internal.model.CommonQueryParameters;
import com.mulesoft.connectors.dynamics365bc.internal.model.NonEntityRequestParameters;
import com.mulesoft.connectors.dynamics365bc.internal.operation.pagination.ListPagingProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.sdk.api.annotation.param.Config;
import org.mule.sdk.api.annotation.param.Connection;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.sdk.api.data.sample.SampleDataProvider;
import org.mule.sdk.api.runtime.operation.Result;

public class GenericPagingSampleDataProvider
implements SampleDataProvider<Collection<TypedValue<String>>, Void> {
    private static final String NESTED_ARRAY_EXPRESSION = "#[output application/json --- payload - '%s' ++ { %s: [payload.%s[0]]}]";
    @Connection
    private MicrosoftRestConnection connection;
    @Config
    private CitizenMicrosoftDynamics365Configuration config;
    @Parameter
    private String companyId;
    private String entity;
    private List<String> expandableProperties;

    public GenericPagingSampleDataProvider(String entity) {
        this.entity = entity;
    }

    public GenericPagingSampleDataProvider(String entity, List<String> expandableProperties) {
        this.entity = entity;
        this.expandableProperties = expandableProperties;
    }

    public String getId() {
        return this.getClass().getSimpleName();
    }

    public Result<Collection<TypedValue<String>>, Void> getSample() throws SampleDataException {
        List results;
        ListPagingProvider provider = new ListPagingProvider(this.config.getSpecialist(), new CommonQueryParameters(), new NonEntityRequestParameters(), this.companyId, new ExpandableEntityParamsBuilder().withEntity(this.entity).withExpandQueryParams(this.expandableProperties != null ? this.expandableProperties : Collections.emptyList()).build(), 1);
        CitizenPagingProviderWrapper wrapper = new CitizenPagingProviderWrapper((PagingProvider<MicrosoftRestConnection, org.mule.runtime.extension.api.runtime.operation.Result<String, HttpResponseAttributes>>)provider);
        try {
            List<TypedValue<String>> page = wrapper.getPage(this.connection);
            String expandProp = this.expandableProperties != null ? this.expandableProperties.get(this.expandableProperties.size() - 1) : null;
            results = page.stream().map(entity -> {
                if (expandProp != null) {
                    String nesterArrayExpFormatted = String.format(NESTED_ARRAY_EXPRESSION, expandProp, expandProp, expandProp);
                    return this.connection.applyExpression(nesterArrayExpFormatted, entity);
                }
                return entity;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new SampleDataException("Failed to retrieve results.", "CONNECTION_FAILURE", (Throwable)e);
        }
        if (!results.isEmpty()) {
            return Result.builder().output(results).build();
        }
        throw new SampleDataException(String.format("No data for entity %s.", this.entity), "NO_DATA_AVAILABLE");
    }
}

