/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.valueprovider;

import com.mulesoft.connectors.dynamics365bc.citizen.internal.config.CitizenMicrosoftDynamics365Configuration;
import com.mulesoft.connectors.dynamics365bc.internal.config.MicrosoftDynamics365Configuration;
import com.mulesoft.connectors.dynamics365bc.internal.connection.MicrosoftRestConnection;
import com.mulesoft.connectors.dynamics365bc.internal.util.RequestStreamingUtils;
import com.mulesoft.connectors.dynamics365bc.internal.util.RestRequestBuilder;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.http.api.HttpConstants;

public class GenericEntityValueProvider
implements ValueProvider {
    @Config
    CitizenMicrosoftDynamics365Configuration configuration;
    @Connection
    MicrosoftRestConnection connection;
    @Parameter
    private String companyId;
    private final String expression;
    private String entityName;
    private String field;

    public GenericEntityValueProvider(String entityName, String field) {
        this.expression = String.format("#[output java---payload.value reduce ((item, obj={}) -> obj ++ {(item.id): item.%s})]", field);
        this.entityName = entityName;
        this.field = field;
    }

    public Set<Value> resolve() throws ValueResolvingException {
        RestRequestBuilder builder = new RestRequestBuilder(this.connection.getBaseUri(), "/companies({id})/{entity}", HttpConstants.Method.GET).addUriParam("id", (Object)this.companyId).addUriParam("entity", (Object)this.entityName).addQueryParam("$select", (Object)String.format("id, %s", this.field)).addHeader("accept", (Object)"application/json");
        try {
            Result result = RequestStreamingUtils.doRequestAndConsumeString((MicrosoftRestConnection)this.connection, (MicrosoftDynamics365Configuration)this.configuration.getSpecialist(), (RestRequestBuilder)builder, (MediaType)MediaType.JSON);
            LinkedHashMap companyMap = (LinkedHashMap)this.connection.applyExpression(this.expression, (TypedValue)result.getOutput()).getValue();
            return companyMap.entrySet().stream().map(entry -> ValueBuilder.newValue((String)((String)entry.getKey())).withDisplayName((String)entry.getValue()).build()).collect(Collectors.toSet());
        }
        catch (MuleRuntimeException e) {
            throw new ValueResolvingException("Unable to load entity types.", "UNKNOWN", (Throwable)e);
        }
    }
}

