/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.dynamics365bc.citizen.internal.operation;

import com.mulesoft.connectors.dynamics365bc.api.HttpResponseAttributes;
import com.mulesoft.connectors.dynamics365bc.citizen.api.model.Recipient;
import com.mulesoft.connectors.dynamics365bc.citizen.api.model.SalesOrderLine;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.builder.SidecarRequestBuilder;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.config.CitizenMicrosoftDynamics365Configuration;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.SalesOrderTypeMetadataResolver;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.sample.SalesOrderSampleDataProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.valueprovider.CurrencyCodeValueProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.valueprovider.DelegateCompanyNameValueProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.valueprovider.PaymentTermsValueProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.valueprovider.ShipmentMethodValueProvider;
import com.mulesoft.connectors.dynamics365bc.internal.connection.MicrosoftRestConnection;
import com.mulesoft.connectors.dynamics365bc.internal.error.provider.CreateODataErrorProvider;
import com.mulesoft.connectors.dynamics365bc.internal.model.NonEntityRequestParameters;
import com.mulesoft.connectors.dynamics365bc.internal.model.RequestParameters;
import com.mulesoft.connectors.dynamics365bc.internal.operation.BaseRestOperation;
import com.mulesoft.connectors.dynamics365bc.internal.util.RestRequestBuilder;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.sdk.api.annotation.data.sample.SampleData;
import org.mule.sdk.api.annotation.param.ParameterGroup;

public class CreateSalesOrderOperation
extends BaseRestOperation {
    @Throws(value={CreateODataErrorProvider.class})
    @DisplayName(value="Create Sales Order")
    @MediaType(value="application/json")
    @OutputResolver(output=SalesOrderTypeMetadataResolver.class)
    @SampleData(value=SalesOrderSampleDataProvider.class)
    public void createSalesOrder(@Config CitizenMicrosoftDynamics365Configuration config, @Connection MicrosoftRestConnection connection, @MetadataKeyId @Expression(value=ExpressionSupport.NOT_SUPPORTED) @OfValues(value=DelegateCompanyNameValueProvider.class) @DisplayName(value="Company") @Summary(value="Name of the Company that the action should apply to") String companyId, @Optional String externalDocumentNumber, @Optional LocalDate orderDate, @Optional LocalDate postingDate, String customerNumber, @Optional @OfValues(value=CurrencyCodeValueProvider.class) String currencyCode, @Optional @OfValues(value=PaymentTermsValueProvider.class) String paymentTerms, @Optional @OfValues(value=ShipmentMethodValueProvider.class) String shipmentMethod, @Optional String salesPerson, @Optional boolean partialShipping, @Optional LocalDate requestedDeliveryDate, @Optional Float discountAmount, @Optional boolean fullyShipped, @Optional String phoneNumber, @Optional String email, @Optional String billToCustomerNumber, @Optional @ParameterGroup(name="Ship To", showInDsl=true) Recipient shipTo, @Optional @ParameterGroup(name="Sell To", showInDsl=true) Recipient sellTo, @Optional @NullSafe List<SalesOrderLine> salesOrderLines, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        TypedValue<InputStream> jsonBody = SidecarRequestBuilder.builder().withParam("externalDocumentNumber", externalDocumentNumber).withParam("orderDate", orderDate).withParam("postingDate", postingDate).withParam("customerNumber", customerNumber).withParam("currencyId", currencyCode).withParam("paymentTermsId", paymentTerms).withParam("shipmentMethodId", shipmentMethod).withParam("salesPerson", salesPerson).withParam("partialShipping", partialShipping).withParam("requestedDeliveryDate", requestedDeliveryDate).withParam("discountAmount", discountAmount).withParam("fullyShipped", fullyShipped).withParam("phoneNumber", phoneNumber).withParam("email", email).withParam("billToCustomerNumber", billToCustomerNumber).withUnpacked("shipTo", shipTo, Recipient.class).withUnpacked("sellTo", sellTo, Recipient.class).withParam("salesOrderLines", salesOrderLines.stream().map(salesOrderLine -> salesOrderLine.toTypedValueIs(connection)).collect(Collectors.toList())).build(connection);
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), "/companies({id})/{entity}", HttpConstants.Method.POST, (RequestParameters)new NonEntityRequestParameters()).setQueryParamFormat(QUERY_PARAM_FORMAT).addQueryParam("$expand", (Object)"salesOrderLines").addHeader("accept", (Object)"application/json").setBody(jsonBody, config.getConfigurationOverride().getStreamingType()).addUriParam("id", (Object)companyId).addUriParam("entity", (Object)"salesOrders");
        this.doRequest(config.getSpecialist(), connection, builder, config.getConfigurationOverride().getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

