/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.dynamics365bc.citizen.internal.operation;

import com.mulesoft.connectors.dynamics365bc.api.HttpResponseAttributes;
import com.mulesoft.connectors.dynamics365bc.citizen.api.enums.CustomerTypeEnum;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.builder.CommonQueryParamsBuilder;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.builder.ExpandableEntityParamsBuilder;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.builder.Operation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.builder.SidecarFilterQueryBuilder;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.config.CitizenMicrosoftDynamics365Configuration;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.CustomerTypeMetadataResolver;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.sample.PagedCustomerSampleDataProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.valueprovider.DelegateCompanyNameValueProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.CitizenPagingProviderWrapper;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.SpecialistOperations;
import com.mulesoft.connectors.dynamics365bc.internal.connection.MicrosoftRestConnection;
import com.mulesoft.connectors.dynamics365bc.internal.error.provider.GetODataErrorProvider;
import com.mulesoft.connectors.dynamics365bc.internal.model.NonEntityRequestParameters;
import com.mulesoft.connectors.dynamics365bc.internal.operation.BaseRestOperation;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.sdk.api.annotation.data.sample.SampleData;

public class GetCustomersOperation
extends BaseRestOperation {
    @Throws(value={GetODataErrorProvider.class})
    @DisplayName(value="Get Customers")
    @OutputResolver(output=CustomerTypeMetadataResolver.class)
    @SampleData(value=PagedCustomerSampleDataProvider.class)
    public PagingProvider<MicrosoftRestConnection, TypedValue<String>> getCustomers(@Config CitizenMicrosoftDynamics365Configuration config, @MetadataKeyId @Expression(value=ExpressionSupport.NOT_SUPPORTED) @OfValues(value=DelegateCompanyNameValueProvider.class) @DisplayName(value="Company") @Summary(value="Name of the Company that the action should apply to") String companyId, @Optional @DisplayName(value="Customer Number") String number, @Optional @DisplayName(value="Customer Display Name") String displayName, @Optional @DisplayName(value="Customer Type") CustomerTypeEnum type) {
        return new CitizenPagingProviderWrapper((PagingProvider<MicrosoftRestConnection, Result<String, HttpResponseAttributes>>)SpecialistOperations.getListEntitiesOperation().listEntities(config.getSpecialist(), companyId, new ExpandableEntityParamsBuilder().withEntity("customers").build(), new CommonQueryParamsBuilder().withFilterQueryParam(new SidecarFilterQueryBuilder().and("number", Operation.EQUALS, number).and("displayName", Operation.EQUALS, displayName).and("type", Operation.EQUALS, (Object)type).build()).build(), new NonEntityRequestParameters(), 20));
    }
}

