/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.dynamics365bc.citizen.internal.operation;

import com.mulesoft.connectors.dynamics365bc.api.HttpResponseAttributes;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.builder.CommonQueryParamsBuilder;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.builder.ExpandableEntityParamsBuilder;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.builder.Operation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.builder.SidecarFilterQueryBuilder;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.config.CitizenMicrosoftDynamics365Configuration;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.ItemVariantTypeMetadataResolver;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.sample.PagedItemVariantSampleDataProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.valueprovider.DelegateCompanyNameValueProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.CitizenPagingProviderWrapper;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.SpecialistOperations;
import com.mulesoft.connectors.dynamics365bc.internal.connection.MicrosoftRestConnection;
import com.mulesoft.connectors.dynamics365bc.internal.error.provider.GetODataErrorProvider;
import com.mulesoft.connectors.dynamics365bc.internal.model.NonEntityRequestParameters;
import com.mulesoft.connectors.dynamics365bc.internal.operation.BaseRestOperation;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.sdk.api.annotation.data.sample.SampleData;

public class GetItemVariantsOperation
extends BaseRestOperation {
    @Throws(value={GetODataErrorProvider.class})
    @DisplayName(value="Get Item Variants")
    @OutputResolver(output=ItemVariantTypeMetadataResolver.class)
    @SampleData(value=PagedItemVariantSampleDataProvider.class)
    public PagingProvider<MicrosoftRestConnection, TypedValue<String>> getItemVariants(@Config CitizenMicrosoftDynamics365Configuration config, @MetadataKeyId @Expression(value=ExpressionSupport.NOT_SUPPORTED) @OfValues(value=DelegateCompanyNameValueProvider.class) @DisplayName(value="Company") @Summary(value="Name of the Company that the action should apply to") String companyId, @Optional @DisplayName(value="Variant Item Number") String itemNumber) {
        return new CitizenPagingProviderWrapper((PagingProvider<MicrosoftRestConnection, Result<String, HttpResponseAttributes>>)SpecialistOperations.getListEntitiesOperation().listEntities(config.getSpecialist(), companyId, new ExpandableEntityParamsBuilder().withEntity("itemVariants").build(), new CommonQueryParamsBuilder().withFilterQueryParam(new SidecarFilterQueryBuilder().and("itemNumber", Operation.EQUALS, itemNumber).build()).build(), new NonEntityRequestParameters(), 20));
    }
}

