/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.dynamics365bc.citizen.internal.operation;

import com.mulesoft.connectors.dynamics365bc.api.HttpResponseAttributes;
import com.mulesoft.connectors.dynamics365bc.citizen.api.enums.StatusEnum;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.builder.CommonQueryParamsBuilder;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.builder.ExpandableEntityParamsBuilder;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.builder.Operation;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.builder.SidecarFilterQueryBuilder;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.config.CitizenMicrosoftDynamics365Configuration;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.SalesOrderTypeMetadataResolver;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.sample.PagedSalesOrderSampleDataProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.valueprovider.DelegateCompanyNameValueProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.CitizenPagingProviderWrapper;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.SpecialistOperations;
import com.mulesoft.connectors.dynamics365bc.internal.connection.MicrosoftRestConnection;
import com.mulesoft.connectors.dynamics365bc.internal.error.provider.GetODataErrorProvider;
import com.mulesoft.connectors.dynamics365bc.internal.model.NonEntityRequestParameters;
import java.time.LocalDate;
import java.util.Collections;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.sdk.api.annotation.data.sample.SampleData;

public class GetSalesOrdersOperation {
    @Throws(value={GetODataErrorProvider.class})
    @DisplayName(value="Get Sales Orders")
    @OutputResolver(output=SalesOrderTypeMetadataResolver.class)
    @SampleData(value=PagedSalesOrderSampleDataProvider.class)
    public PagingProvider<MicrosoftRestConnection, TypedValue<String>> getSalesOrders(@Config CitizenMicrosoftDynamics365Configuration config, @MetadataKeyId @Expression(value=ExpressionSupport.NOT_SUPPORTED) @OfValues(value=DelegateCompanyNameValueProvider.class) @DisplayName(value="Company") @Summary(value="Name of the Company that the action should apply to") String companyId, @Optional @DisplayName(value="Sales Order Number") String number, @Optional @DisplayName(value="Sales Order Status") StatusEnum status, @Optional @DisplayName(value="Customer Number") String customerNumber, @Optional @DisplayName(value="Customer Name") String customerName, @Optional @DisplayName(value="Order Date Before") LocalDate beforeDate, @Optional @DisplayName(value="Order Date After") LocalDate afterDate) {
        return new CitizenPagingProviderWrapper((PagingProvider<MicrosoftRestConnection, Result<String, HttpResponseAttributes>>)SpecialistOperations.getListEntitiesOperation().listEntities(config.getSpecialist(), companyId, new ExpandableEntityParamsBuilder().withEntity("salesOrders").withExpandQueryParams(Collections.singletonList("salesOrderLines")).build(), new CommonQueryParamsBuilder().withFilterQueryParam(new SidecarFilterQueryBuilder().and("number", Operation.EQUALS, number).and("status", Operation.EQUALS, (Object)status).and("customerNumber", Operation.EQUALS, customerNumber).and("customerName", Operation.EQUALS, customerName).and("orderDate", Operation.LESS_OR_EQUAL, beforeDate).and("orderDate", Operation.GREATER_OR_EQUAL, afterDate).build()).build(), new NonEntityRequestParameters(), 20));
    }
}

