/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.dynamics365bc.citizen.internal.operation;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.dynamics365bc.api.HttpResponseAttributes;
import com.mulesoft.connectors.dynamics365bc.citizen.api.model.Recipient;
import com.mulesoft.connectors.dynamics365bc.citizen.api.model.SalesOrderLine;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.builder.ExpandableEntityParamsBuilder;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.builder.SidecarRequestBuilder;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.config.CitizenMicrosoftDynamics365Configuration;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.SalesOrderTypeMetadataResolver;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.sample.SalesOrderSampleDataProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.valueprovider.CurrencyCodeValueProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.valueprovider.DelegateCompanyNameValueProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.valueprovider.PaymentTermsValueProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.valueprovider.ShipmentMethodValueProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.model.BatchRequestEntry;
import com.mulesoft.connectors.dynamics365bc.internal.connection.MicrosoftRestConnection;
import com.mulesoft.connectors.dynamics365bc.internal.error.provider.UpdateODataErrorProvider;
import com.mulesoft.connectors.dynamics365bc.internal.model.NonEntityRequestParameters;
import com.mulesoft.connectors.dynamics365bc.internal.operation.BaseRestOperation;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.sdk.api.annotation.data.sample.SampleData;
import org.mule.sdk.api.annotation.param.ParameterGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSalesOrderOperation
extends BaseRestOperation {
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final Logger logger = LoggerFactory.getLogger(UpdateSalesOrderOperation.class);
    private static final MultiMap<String, String> BASE_HEADERS = new MultiMap(Collections.singletonMap("content-type", "application/json"));
    public static final String BATCH_REQUEST_RESPONSE_ID = "response";

    @Throws(value={UpdateODataErrorProvider.class})
    @DisplayName(value="Update Sales Order")
    @MediaType(value="application/json")
    @OutputResolver(output=SalesOrderTypeMetadataResolver.class)
    @SampleData(value=SalesOrderSampleDataProvider.class)
    public void updateSalesOrder(@Config CitizenMicrosoftDynamics365Configuration config, @Connection MicrosoftRestConnection connection, @MetadataKeyId @Expression(value=ExpressionSupport.NOT_SUPPORTED) @OfValues(value=DelegateCompanyNameValueProvider.class) @DisplayName(value="Company") @Summary(value="Name of the Company that the action should apply to") String companyId, @DisplayName(value="Entity ID") String entityId, @DisplayName(value="ETag") String etag, @org.mule.runtime.extension.api.annotation.param.Optional String externalDocumentNumber, @org.mule.runtime.extension.api.annotation.param.Optional LocalDate orderDate, @org.mule.runtime.extension.api.annotation.param.Optional LocalDate postingDate, @org.mule.runtime.extension.api.annotation.param.Optional String customerNumber, @org.mule.runtime.extension.api.annotation.param.Optional @OfValues(value=CurrencyCodeValueProvider.class) String currencyCode, @org.mule.runtime.extension.api.annotation.param.Optional @OfValues(value=PaymentTermsValueProvider.class) String paymentTerms, @org.mule.runtime.extension.api.annotation.param.Optional @OfValues(value=ShipmentMethodValueProvider.class) String shipmentMethod, @org.mule.runtime.extension.api.annotation.param.Optional String salesPerson, @org.mule.runtime.extension.api.annotation.param.Optional boolean partialShipping, @org.mule.runtime.extension.api.annotation.param.Optional LocalDate requestedDeliveryDate, @org.mule.runtime.extension.api.annotation.param.Optional Float discountAmount, @org.mule.runtime.extension.api.annotation.param.Optional boolean fullyShipped, @org.mule.runtime.extension.api.annotation.param.Optional String phoneNumber, @org.mule.runtime.extension.api.annotation.param.Optional String email, @org.mule.runtime.extension.api.annotation.param.Optional String billToCustomerNumber, @org.mule.runtime.extension.api.annotation.param.Optional @ParameterGroup(name="Ship To", showInDsl=true) Recipient shipTo, @org.mule.runtime.extension.api.annotation.param.Optional @ParameterGroup(name="Sell To", showInDsl=true) Recipient sellTo, @org.mule.runtime.extension.api.annotation.param.Optional boolean replaceAll, @org.mule.runtime.extension.api.annotation.param.Optional @NullSafe List<SalesOrderLine> salesOrderLines, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        TypedValue<InputStream> jsonBody = SidecarRequestBuilder.builder().withParam("externalDocumentNumber", externalDocumentNumber).withParam("orderDate", orderDate).withParam("postingDate", postingDate).withParam("customerNumber", customerNumber).withParam("currencyCode", currencyCode).withParam("paymentTermsId", paymentTerms).withParam("shipmentMethodId", shipmentMethod).withParam("salesPerson", salesPerson).withParam("partialShipping", partialShipping).withParam("requestedDeliveryDate", requestedDeliveryDate).withParam("discountAmount", discountAmount).withParam("fullyShipped", fullyShipped).withParam("phoneNumber", phoneNumber).withParam("email", email).withParam("billToCustomerNumber", billToCustomerNumber).withUnpacked("shipTo", shipTo, Recipient.class).withUnpacked("sellTo", sellTo, Recipient.class).build(connection);
        ArrayList<BatchRequestEntry> requests = new ArrayList<BatchRequestEntry>();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("If-Match", etag);
        headers.put("content-type", "application/json");
        requests.add(new BatchRequestEntry.BatchRequestEntryBuilder().method("PATCH").url(String.format("companies(%s)/salesOrders(%s)", companyId, entityId)).body(jsonBody).headers((MultiMap<String, String>)new MultiMap(headers)).build());
        if (replaceAll) {
            logger.debug("Replace all selected.. replacing all sales order lines... ");
            try {
                InputStream salesOrdersResponse = (InputStream)((Result)connection.getEntityNoCallback(companyId, entityId, new ExpandableEntityParamsBuilder().withEntity("salesOrders").withExpandQueryParams(Collections.singletonList("salesOrderLines($select=id)")).build(), new NonEntityRequestParameters(), Integer.valueOf(config.getConfigurationOverride().getResponseTimeoutAsMillis()), streamingHelper).get()).getOutput();
                Optional.ofNullable(objectMapper.readTree(salesOrdersResponse)).map(res -> res.get("salesOrderLines")).ifPresent(sols -> sols.elements().forEachRemaining(sol -> Optional.ofNullable(sol.get("id")).ifPresent(solId -> requests.add(new BatchRequestEntry.BatchRequestEntryBuilder().method("DELETE").url(String.format("companies(%s)/salesOrders(%s)/salesOrderLines(%s)", companyId, entityId, solId.asText())).body(null).headers(BASE_HEADERS).build()))));
                this.addCreateEntityBatchRequests(connection, companyId, entityId, salesOrderLines, requests);
            }
            catch (Exception e) {
                callback.error((Throwable)e);
            }
        } else {
            logger.debug("Replace all not selected, adding new sales order lines... ");
            this.addCreateEntityBatchRequests(connection, companyId, entityId, salesOrderLines, requests);
        }
        requests.add(new BatchRequestEntry.BatchRequestEntryBuilder().id(BATCH_REQUEST_RESPONSE_ID).method("GET").url(String.format("companies(%s)/salesOrders(%s)?$expand=salesOrderLines", companyId, entityId)).build());
        logger.debug("Sending batch requests... ");
        connection.sendBatchRequest(config.getSpecialist(), SidecarRequestBuilder.builder().withParam("requests", requests).build(connection), streamingHelper, callback, objectMapper);
    }

    private void addCreateEntityBatchRequests(MicrosoftRestConnection connection, String companyId, String salesOrderId, List<SalesOrderLine> salesOrderLines, List<BatchRequestEntry> requests) {
        salesOrderLines.forEach(sol -> requests.add(new BatchRequestEntry.BatchRequestEntryBuilder().method("POST").url(String.format("companies(%s)/salesOrders(%s)/salesOrderLines", companyId, salesOrderId)).body(sol.toTypedValueIs(connection)).headers(BASE_HEADERS).build()));
    }
}

