/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.dynamics365bc.citizen.internal.operation.model;

import java.io.InputStream;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;

public class BatchRequestEntry {
    private final String id;
    private final String method;
    private final String url;
    private final MultiMap<String, String> headers;
    private final TypedValue<InputStream> body;

    public BatchRequestEntry(String method, String url, MultiMap<String, String> headers, TypedValue<InputStream> body, String id) {
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.body = body;
        this.id = id;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers;
    }

    public TypedValue<InputStream> getBody() {
        return this.body;
    }

    public String getId() {
        return this.id;
    }

    private BatchRequestEntry(BatchRequestEntryBuilder batchRequestEntryBuilder) {
        this.method = batchRequestEntryBuilder.method;
        this.url = batchRequestEntryBuilder.url;
        this.headers = batchRequestEntryBuilder.headers;
        this.body = batchRequestEntryBuilder.body;
        this.id = batchRequestEntryBuilder.id;
    }

    public static class BatchRequestEntryBuilder {
        private String method;
        private String url;
        private MultiMap<String, String> headers;
        private TypedValue<InputStream> body;
        private String id;

        public BatchRequestEntryBuilder method(String method) {
            this.method = method;
            return this;
        }

        public BatchRequestEntryBuilder url(String url) {
            this.url = url;
            return this;
        }

        public BatchRequestEntryBuilder headers(MultiMap<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public BatchRequestEntryBuilder body(TypedValue<InputStream> body) {
            this.body = body;
            return this;
        }

        public BatchRequestEntryBuilder id(String id) {
            this.id = id;
            return this;
        }

        public BatchRequestEntry build() {
            return new BatchRequestEntry(this);
        }
    }
}

