/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.dynamics365bc.citizen.internal.source;

import com.mulesoft.connectors.dynamics365bc.api.HttpResponseAttributes;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.config.CitizenMicrosoftDynamics365Configuration;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.metadata.valueprovider.DelegateCompanyNameValueProvider;
import com.mulesoft.connectors.dynamics365bc.citizen.internal.utils.CitizenUtils;
import com.mulesoft.connectors.dynamics365bc.internal.connection.MicrosoftRestConnection;
import com.mulesoft.connectors.dynamics365bc.internal.source.worker.OnNewOrUpdatedSourceWorker;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.source.BackPressure;
import org.mule.runtime.extension.api.annotation.source.ClusterSupport;
import org.mule.runtime.extension.api.annotation.source.SourceClusterSupport;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;

@MediaType(value="application/json")
@BackPressure(supportedModes={BackPressureMode.WAIT, BackPressureMode.DROP})
@ClusterSupport(value=SourceClusterSupport.NOT_SUPPORTED)
public class CitizenPollingSourceWrapper
extends PollingSource<InputStream, HttpResponseAttributes> {
    private static final DateTimeFormatter MULE_DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);
    @Config
    private CitizenMicrosoftDynamics365Configuration config;
    @Connection
    private ConnectionProvider<MicrosoftRestConnection> connectionProvider;
    @Inject
    private ExpressionLanguage expressionLanguage;
    private OnNewOrUpdatedSourceWorker worker;
    private final String pathTemplate;
    @Parameter
    @DisplayName(value="Company ID")
    @Summary(value="The ID of the Company")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @MetadataKeyId
    @OfValues(value=DelegateCompanyNameValueProvider.class)
    String companyId;
    @Parameter
    @Example(value="1970-01-01T00:00:00.000Z")
    @Optional
    @DisplayName(value="Since")
    @Summary(value="Since")
    String since;

    public CitizenPollingSourceWrapper(String path) {
        this.pathTemplate = path;
    }

    protected void doStart() throws MuleException {
        if (this.since == null || this.since.isEmpty()) {
            this.since = LocalDateTime.now(Clock.systemUTC()).format(MULE_DATETIME_FORMAT);
        }
        this.worker = new OnNewOrUpdatedSourceWorker((MicrosoftRestConnection)this.connectionProvider.connect(), this.config.getSpecialist(), this.expressionLanguage, this.companyId, this.since, this.pathTemplate);
    }

    protected void doStop() {
        this.connectionProvider.disconnect((Object)this.worker.getConnection());
    }

    public void poll(PollContext<InputStream, HttpResponseAttributes> pollContext) {
        Serializable watermark = pollContext.getWatermark().orElse(null);
        this.worker.poll(watermark, result -> pollContext.accept(this.buildPollItemConsumer((OnNewOrUpdatedSourceWorker.ItemResult)result)), arg_0 -> pollContext.onConnectionException(arg_0));
    }

    public void onRejectedItem(Result<InputStream, HttpResponseAttributes> result, SourceCallbackContext callbackContext) {
        if (result.getOutput() != null) {
            IOUtils.closeQuietly((Closeable)((Closeable)result.getOutput()));
        }
    }

    private Consumer<PollContext.PollItem<InputStream, HttpResponseAttributes>> buildPollItemConsumer(OnNewOrUpdatedSourceWorker.ItemResult result) {
        return pollItem -> {
            pollItem.setResult(CitizenUtils.toSdkResult(result.getResult()));
            pollItem.setWatermark(result.getWatermark());
            pollItem.setId(result.getId());
        };
    }
}

