%dw 2.8

import OperationElement from com::mulesoft::connectivity::Metadata

import Error, Result, ResultFailure, failure, success from com::mulesoft::connectivity::Model

import T_AddGoLinkRequest, T_AddGoLinkResult from com::mulesoft::connectivity::coda::types::Types

import Description from com::mulesoft::connectivity::decorator::Annotations

import HttpConnection, HttpRequestType, HttpResponse from com::mulesoft::connectivity::transport::Http

import serializeCookies, serializeHeaders, serializeUriParams, withSerializationConfig from com::mulesoft::connectivity::transport::Serialization

type O_organizations__organizationId__goLinks_post_Type = {
  "200": HttpResponse<T_AddGoLinkResult>,
  "400": HttpResponse<{ statusCode: @Description(value = "HTTP status code of the error.")
  Number, statusMessage: @Description(value = "HTTP status message of the error.")
  String, message: @Description(value = "Any additional context on the error, or the same as `statusMessage` otherwise.")
  String }>,
  "403": HttpResponse<{ statusCode: @Description(value = "HTTP status code of the error.")
  Number, statusMessage: @Description(value = "HTTP status message of the error.")
  String, message: @Description(value = "Any additional context on the error, or the same as `statusMessage` otherwise.")
  String }>,
  errorResponse: ResultFailure<O_organizations__organizationId__goLinks_post_Type."400", Error<"status-400", "CLIENT_ERROR">> | ResultFailure<O_organizations__organizationId__goLinks_post_Type."403", Error<"status-403", "CLIENT_ERROR">> | ResultFailure<HttpResponse<Any>, Error<"status-unauthorized", String>> | ResultFailure<HttpResponse<Any>, Error<"status-unexpected", String>>,
  request: HttpRequestType<{| uri: {| organizationId: String |}, query: Object, headers: Object, cookie: Object, body: T_AddGoLinkRequest |}>,
  response: O_organizations__organizationId__goLinks_post_Type."200"
}

@OperationElement()
var O_organizations__organizationId__goLinks_post = {
  name: "addGoLink",
  displayName: "addGoLink",
  executor: (parameter: O_organizations__organizationId__goLinks_post_Type.request, connection: HttpConnection): Result<O_organizations__organizationId__goLinks_post_Type.response, O_organizations__organizationId__goLinks_post_Type.errorResponse> -> do {
      var uri = serializeUriParams(parameter.uri, {})
      var query = parameter.query default {} withSerializationConfig {}
      var headers = serializeHeaders(parameter.headers default {}, {})
      var cookie = serializeCookies(parameter.cookie default {}, {})
      var response = connection({
        method: "POST",
        path: "/organizations/$(uri.organizationId)/goLinks",
        queryParams: query,
        headers: headers,
        config: {
          contentType: "application/json"
        },
        cookie: cookie,
        (body: parameter.body) if (parameter.body?)
      })
      ---
      response match {
        case response200 if response200.status == 200 and response200 is O_organizations__organizationId__goLinks_post_Type."200" -> success(response200 as O_organizations__organizationId__goLinks_post_Type."200")
        case response400 if response400.status == 400 and response400 is O_organizations__organizationId__goLinks_post_Type."400" -> failure(response400 as O_organizations__organizationId__goLinks_post_Type."400", {
          kind: "status-400",
          categories: ["CLIENT_ERROR"]
        }, "The request parameters did not conform to expectations.")
        case response403 if response403.status == 403 and response403 is O_organizations__organizationId__goLinks_post_Type."403" -> failure(response403 as O_organizations__organizationId__goLinks_post_Type."403", {
          kind: "status-403",
          categories: ["CLIENT_ERROR"]
        }, "The API token does not grant access to this resource.")
        case response401 if response401.status == 401 -> failure(response401, {
          kind: "status-unauthorized",
          categories: []
        }, "Unauthorized")
        else responsedefault-> failure(responsedefault, {
          kind: "status-unexpected",
          categories: []
        }, "Unexpected status code")
      }
    }
}

