%dw 2.8

import OperationElement from com::mulesoft::connectivity::Metadata

import Error, Result, ResultFailure, UnexpectedError, failure, success, unexpectedFailure from com::mulesoft::connectivity::Model

import Integer from com::mulesoft::connectivity::Types

import T_FormulaList, T_SortBy from com::mulesoft::connectivity::coda::types::Types

import Description from com::mulesoft::connectivity::decorator::Annotations

import HttpConnection, HttpRequestType, HttpResponse from com::mulesoft::connectivity::transport::Http

import serializeCookies, serializeHeaders, serializeUriParams, withSerializationConfig from com::mulesoft::connectivity::transport::Serialization

type O_docs__docId__formulas_get_Type = {
  "200": HttpResponse<T_FormulaList>,
  "401": HttpResponse<{ statusCode: @Description(value = "HTTP status code of the error.")
  Number, statusMessage: @Description(value = "HTTP status message of the error.")
  String, message: @Description(value = "Any additional context on the error, or the same as `statusMessage` otherwise.")
  String }>,
  "403": HttpResponse<{ statusCode: @Description(value = "HTTP status code of the error.")
  Number, statusMessage: @Description(value = "HTTP status message of the error.")
  String, message: @Description(value = "Any additional context on the error, or the same as `statusMessage` otherwise.")
  String }>,
  "404": HttpResponse<{ statusCode: @Description(value = "HTTP status code of the error.")
  Number, statusMessage: @Description(value = "HTTP status message of the error.")
  String, message: @Description(value = "Any additional context on the error, or the same as `statusMessage` otherwise.")
  String }>,
  "429": HttpResponse<{ statusCode: @Description(value = "HTTP status code of the error.")
  Number, statusMessage: @Description(value = "HTTP status message of the error.")
  String, message: @Description(value = "Any additional context on the error, or the same as `statusMessage` otherwise.")
  String }>,
  errorResponse: ResultFailure<O_docs__docId__formulas_get_Type."401", Error<"401", "CLIENT_ERROR">> | ResultFailure<O_docs__docId__formulas_get_Type."403", Error<"403", "CLIENT_ERROR">> | ResultFailure<O_docs__docId__formulas_get_Type."404", Error<"404", "CLIENT_ERROR">> | ResultFailure<O_docs__docId__formulas_get_Type."429", Error<"429", "CLIENT_ERROR">> | ResultFailure<HttpResponse<Any>, UnexpectedError>,
  request: HttpRequestType<{| uri: {| docId: String |}, query: { limit?: Integer, pageToken?: String, sortBy?: T_SortBy }, headers: Object, cookie: Object |}>,
  response: O_docs__docId__formulas_get_Type."200"
}

@OperationElement()
var O_docs__docId__formulas_get = {
  name: "listFormulas",
  displayName: "listFormulas",
  executor: (parameter: O_docs__docId__formulas_get_Type.request, connection: HttpConnection): Result<O_docs__docId__formulas_get_Type.response, O_docs__docId__formulas_get_Type.errorResponse> -> do {
      var uri = serializeUriParams(parameter.uri, {})
      var query = parameter.query default {} withSerializationConfig {}
      var headers = serializeHeaders(parameter.headers default {}, {})
      var cookie = serializeCookies(parameter.cookie default {}, {})
      var response = connection({
        method: "GET",
        path: "/docs/$(uri.docId)/formulas",
        queryParams: query,
        headers: headers,
        cookie: cookie,
        (body: parameter.body) if (parameter.body?)
      })
      var statusCode = response.status as String
      ---
      if (response.status == 200 and response is O_docs__docId__formulas_get_Type."200")
        success(response)
      else if (response.status == 401 and response is O_docs__docId__formulas_get_Type."401")
        failure(response, {
          kind: "401",
          categories: ["CLIENT_ERROR"]
        }, "The API token is invalid or has expired.")
      else if (response.status == 403 and response is O_docs__docId__formulas_get_Type."403")
        failure(response, {
          kind: "403",
          categories: ["CLIENT_ERROR"]
        }, "The API token does not grant access to this resource.")
      else if (response.status == 404 and response is O_docs__docId__formulas_get_Type."404")
        failure(response, {
          kind: "404",
          categories: ["CLIENT_ERROR"]
        }, "The resource could not be located with the current API token.")
      else if (response.status == 429 and response is O_docs__docId__formulas_get_Type."429")
        failure(response, {
          kind: "429",
          categories: ["CLIENT_ERROR"]
        }, "The client has sent too many requests.")
      else
        unexpectedFailure(response, {
          kind: statusCode,
          categories: []
        })
    }
}

