%dw 2.8

import OperationElement from com::mulesoft::connectivity::Metadata

import Error, Result, ResultFailure, UnexpectedError, failure, success, unexpectedFailure from com::mulesoft::connectivity::Model

import T_AddGoLinkRequest, T_AddGoLinkResult from com::mulesoft::connectivity::coda::types::Types

import Description from com::mulesoft::connectivity::decorator::Annotations

import HttpConnection, HttpRequestType, HttpResponse from com::mulesoft::connectivity::transport::Http

import serializeCookies, serializeHeaders, serializeUriParams, withSerializationConfig from com::mulesoft::connectivity::transport::Serialization

type O_organizations__organizationId__goLinks_post_Type = {
  "200": HttpResponse<T_AddGoLinkResult>,
  "400": HttpResponse<{ statusCode: @Description(value = "HTTP status code of the error.")
  Number, statusMessage: @Description(value = "HTTP status message of the error.")
  String, message: @Description(value = "Any additional context on the error, or the same as `statusMessage` otherwise.")
  String }>,
  "403": HttpResponse<{ statusCode: @Description(value = "HTTP status code of the error.")
  Number, statusMessage: @Description(value = "HTTP status message of the error.")
  String, message: @Description(value = "Any additional context on the error, or the same as `statusMessage` otherwise.")
  String }>,
  errorResponse: ResultFailure<O_organizations__organizationId__goLinks_post_Type."400", Error<"400", "CLIENT_ERROR">> | ResultFailure<O_organizations__organizationId__goLinks_post_Type."403", Error<"403", "CLIENT_ERROR">> | ResultFailure<HttpResponse<Any>, UnexpectedError>,
  request: HttpRequestType<{| uri: {| organizationId: String |}, query: Object, headers: Object, cookie: Object, body: T_AddGoLinkRequest |}>,
  response: O_organizations__organizationId__goLinks_post_Type."200"
}

@OperationElement()
var O_organizations__organizationId__goLinks_post = {
  name: "addGoLink",
  displayName: "addGoLink",
  executor: (parameter: O_organizations__organizationId__goLinks_post_Type.request, connection: HttpConnection): Result<O_organizations__organizationId__goLinks_post_Type.response, O_organizations__organizationId__goLinks_post_Type.errorResponse> -> do {
      var uri = serializeUriParams(parameter.uri, {})
      var query = parameter.query default {} withSerializationConfig {}
      var headers = serializeHeaders(parameter.headers default {}, {})
      var cookie = serializeCookies(parameter.cookie default {}, {})
      var response = connection({
        method: "POST",
        path: "/organizations/$(uri.organizationId)/goLinks",
        queryParams: query,
        headers: headers,
        config: {
          contentType: "application/json"
        },
        cookie: cookie,
        (body: parameter.body) if (parameter.body?)
      })
      var statusCode = response.status as String
      ---
      if (response.status == 200 and response is O_organizations__organizationId__goLinks_post_Type."200")
        success(response)
      else if (response.status == 400 and response is O_organizations__organizationId__goLinks_post_Type."400")
        failure(response, {
          kind: "400",
          categories: ["CLIENT_ERROR"]
        }, "The request parameters did not conform to expectations.")
      else if (response.status == 403 and response is O_organizations__organizationId__goLinks_post_Type."403")
        failure(response, {
          kind: "403",
          categories: ["CLIENT_ERROR"]
        }, "The API token does not grant access to this resource.")
      else
        unexpectedFailure(response, {
          kind: statusCode,
          categories: []
        })
    }
}

