%dw 2.8

import OperationElement from com::mulesoft::connectivity::Metadata

import Error, Result, ResultFailure, UnexpectedError, failure, success, unexpectedFailure from com::mulesoft::connectivity::Model

import T_User from com::mulesoft::connectivity::coda::types::Types

import Description from com::mulesoft::connectivity::decorator::Annotations

import HttpConnection, HttpRequestType, HttpResponse from com::mulesoft::connectivity::transport::Http

import serializeCookies, serializeHeaders, withSerializationConfig from com::mulesoft::connectivity::transport::Serialization

type O_whoami_get_Type = {
  "200": HttpResponse<T_User>,
  "401": HttpResponse<{ statusCode: @Description(value = "HTTP status code of the error.")
  Number, statusMessage: @Description(value = "HTTP status message of the error.")
  String, message: @Description(value = "Any additional context on the error, or the same as `statusMessage` otherwise.")
  String }>,
  "429": HttpResponse<{ statusCode: @Description(value = "HTTP status code of the error.")
  Number, statusMessage: @Description(value = "HTTP status message of the error.")
  String, message: @Description(value = "Any additional context on the error, or the same as `statusMessage` otherwise.")
  String }>,
  errorResponse: ResultFailure<O_whoami_get_Type."401", Error<"401", "CLIENT_ERROR">> | ResultFailure<O_whoami_get_Type."429", Error<"429", "CLIENT_ERROR">> | ResultFailure<HttpResponse<Any>, UnexpectedError>,
  request: HttpRequestType<{| query: Object, headers: Object, cookie: Object |}>,
  response: O_whoami_get_Type."200"
}

@OperationElement()
var O_whoami_get = {
  name: "whoami",
  displayName: "whoami",
  executor: (parameter: O_whoami_get_Type.request, connection: HttpConnection): Result<O_whoami_get_Type.response, O_whoami_get_Type.errorResponse> -> do {
      var query = parameter.query default {} withSerializationConfig {}
      var headers = serializeHeaders(parameter.headers default {}, {})
      var cookie = serializeCookies(parameter.cookie default {}, {})
      var response = connection({
        method: "GET",
        path: "/whoami",
        queryParams: query,
        headers: headers,
        cookie: cookie,
        (body: parameter.body) if (parameter.body?)
      })
      var statusCode = response.status as String
      ---
      if (response.status == 200 and response is O_whoami_get_Type."200")
        success(response)
      else if (response.status == 401 and response is O_whoami_get_Type."401")
        failure(response, {
          kind: "401",
          categories: ["CLIENT_ERROR"]
        }, "The API token is invalid or has expired.")
      else if (response.status == 429 and response is O_whoami_get_Type."429")
        failure(response, {
          kind: "429",
          categories: ["CLIENT_ERROR"]
        }, "The client has sent too many requests.")
      else
        unexpectedFailure(response, {
          kind: statusCode,
          categories: []
        })
    }
}

