%dw 2.8

import Integer, LWDate, LWDateTime from com::mulesoft::connectivity::Types

import Description from com::mulesoft::connectivity::decorator::Annotations

type T_DocCreate = {
  title?: @Description(value = "Title of the new doc. Defaults to 'Untitled'.")
  String,
  sourceDoc?: @Description(value = "An optional doc ID from which to create a copy.")
  String,
  timezone?: @Description(value = "The timezone to use for the newly created doc.")
  String,
  folderId?: @Description(value = "The ID of the folder within which to create this doc. Defaults to your \"My docs\" folder in the oldest workspace you joined; this is subject to change. You can get this ID by opening the folder in the docs list on your computer and grabbing the `folderId` query parameter.\n")
  String,
  initialPage?: Object & T_PageCreate
}

type T_DocUpdate = {
  title?: @Description(value = "Title of the doc.")
  String,
  iconName?: @Description(value = "Name of the icon.")
  String
}

type T_AddPermissionRequest = {
  access: @Description(value = "Type of access (excluding none).")
  T_AccessTypeNotNone,
  principal: @Description(value = "Metadata about a principal to add to a doc.")
  T_AddedPrincipal,
  suppressEmail?: @Description(value = "When true suppresses email notification")
  Boolean
}

type T_UpdateAclSettingsRequest = {
  allowEditorsToChangePermissions?: @Description(value = "When true, allows editors to change doc permissions. When false, only doc owner can change doc permissions.\n")
  Boolean,
  allowCopying?: @Description(value = "When true, allows doc viewers to copy the doc.")
  Boolean,
  allowViewersToRequestEditing?: @Description(value = "When true, allows doc viewers to request editing permissions.")
  Boolean
}

type T_DocPublish = {
  slug?: @Description(value = "Slug for the published doc.")
  String,
  discoverable?: @Description(value = "If true, indicates that the doc is discoverable.")
  Boolean,
  earnCredit?: @Description(value = "If true, new users may be required to sign in to view content within this document. You will receive Coda credit for each user who signs up via your doc.\n")
  Boolean,
  categoryNames?: @Description(value = "The names of categories to apply to the document.")
  Array<String>,
  mode?: @Description(value = "Which interaction mode the published doc should use.")
  T_DocPublishMode
}

type T_PageCreate = {
  name?: @Description(value = "Name of the page.")
  String,
  subtitle?: @Description(value = "Subtitle of the page.")
  String,
  iconName?: @Description(value = "Name of the icon.")
  String,
  imageUrl?: @Description(value = "Url of the cover image to use.")
  String,
  parentPageId?: @Description(value = "The ID of this new page's parent, if creating a subpage.")
  String,
  pageContent?: @Description(value = "Content that can be added to a page at creation time, either text (or rich text) or a URL to create a full-page embed.")
  T_PageCreateContent
}

type T_PageUpdate = {
  name?: @Description(value = "Name of the page.")
  String,
  subtitle?: @Description(value = "Subtitle of the page.")
  String,
  iconName?: @Description(value = "Name of the icon.")
  String,
  imageUrl?: @Description(value = "Url of the cover image to use.")
  String,
  isHidden?: @Description(value = "Whether the page is hidden or not. Note that for pages that cannot be hidden, like the sole top-level page in a doc, this will be ignored.")
  Boolean,
  contentUpdate?: Object & T_PageContentUpdate
}

type T_BeginPageContentExportRequest = {
  outputFormat: @Description(value = "Supported output content formats that can be requested for getting content for an existing page.")
  T_PageContentOutputFormat
}

type T_SortBy = "name"

type T_TableType = "table" | "view"

type T_RowsSortBy = "createdAt" | "natural" | "updatedAt"

type T_ValueFormat = "simple" | "simpleWithArrays" | "rich"

type T_RowsUpsert = {
  rows: Array<T_RowEdit>,
  keyColumns?: @Description(value = "Optional column IDs, URLs, or names (fragile and discouraged), specifying columns to be used as upsert keys.")
  Array<String>
}

type T_RowsDelete = {
  rowIds: @Description(value = "Row IDs to delete.\n")
  Array<String>
}

type T_RowUpdate = {
  row: @Description(value = "An edit made to a particular row.")
  T_RowEdit
}

type T_AddCustomDocDomainRequest = {
  customDocDomain: @Description(value = "The custom domain.")
  String
}

type T_UpdateCustomDocDomainRequest = Object

type T_WorkspaceUserRole = "Admin" | "DocMaker" | "Editor"

type T_ChangeRole = {
  email: @Description(value = "Email of the user.")
  String,
  newRole: T_WorkspaceUserRole
}

type T_AddGoLinkRequest = {
  name: @Description(value = "The name of the Go Link that comes after go/. Only alphanumeric characters, dashes, and underscores are allowed.")
  String,
  destinationUrl: @Description(value = "The URL that the Go Link redirects to.")
  String,
  description?: @Description(value = "Optional description for the Go Link.")
  String,
  urlPattern?: String | Null,
  creatorEmail?: String | Null
}

type T_DocCategoryList = {
  items: @Description(value = "Categories for the doc.")
  Array<T_DocCategory>
}

type T_DocList = {
  items: Array<T_Doc>,
  href?: @Description(value = "API link to these results")
  String,
  nextPageToken?: @Description(value = "If specified, an opaque token used to fetch the next page of results.")
  T_nextPageToken,
  nextPageLink?: T_nextPageLink & String
}

type T_DocumentCreationResult = {
  id: @Description(value = "ID of the Coda doc.")
  String,
  "type": @Description(value = "The type of this resource.")
  "doc",
  href: @Description(value = "API link to the Coda doc.")
  String,
  browserLink: @Description(value = "Browser-friendly link to the Coda doc.")
  String,
  icon?: @Description(value = "Info about the icon.")
  T_Icon,
  name: @Description(value = "Name of the doc.")
  String,
  owner: @Description(value = "Email address of the doc owner.")
  String,
  ownerName: @Description(value = "Name of the doc owner.")
  String,
  docSize?: @Description(value = "The number of components within a Coda doc.")
  T_DocSize,
  sourceDoc?: Object & T_DocReference,
  createdAt: @Description(value = "Timestamp for when the doc was created.")
  LWDateTime,
  updatedAt: @Description(value = "Timestamp for when the doc was last modified.")
  LWDateTime,
  published?: @Description(value = "Information about the publishing state of the document.")
  T_DocPublished,
  folder: @Description(value = "Reference to a Coda folder.")
  T_FolderReference,
  workspace: @Description(value = "Reference to a Coda workspace.")
  T_WorkspaceReference,
  workspaceId: @Description(value = "ID of the Coda workspace containing this doc.")
  String,
  folderId: @Description(value = "ID of the Coda folder containing this doc.")
  String,
  requestId?: @Description(value = "An arbitrary unique identifier for this request.")
  String
}

type T_Doc = {
  id: @Description(value = "ID of the Coda doc.")
  String,
  "type": @Description(value = "The type of this resource.")
  "doc",
  href: @Description(value = "API link to the Coda doc.")
  String,
  browserLink: @Description(value = "Browser-friendly link to the Coda doc.")
  String,
  icon?: @Description(value = "Info about the icon.")
  T_Icon,
  name: @Description(value = "Name of the doc.")
  String,
  owner: @Description(value = "Email address of the doc owner.")
  String,
  ownerName: @Description(value = "Name of the doc owner.")
  String,
  docSize?: @Description(value = "The number of components within a Coda doc.")
  T_DocSize,
  sourceDoc?: Object & T_DocReference,
  createdAt: @Description(value = "Timestamp for when the doc was created.")
  LWDateTime,
  updatedAt: @Description(value = "Timestamp for when the doc was last modified.")
  LWDateTime,
  published?: @Description(value = "Information about the publishing state of the document.")
  T_DocPublished,
  folder: @Description(value = "Reference to a Coda folder.")
  T_FolderReference,
  workspace: @Description(value = "Reference to a Coda workspace.")
  T_WorkspaceReference,
  workspaceId: @Description(value = "ID of the Coda workspace containing this doc.")
  String,
  folderId: @Description(value = "ID of the Coda folder containing this doc.")
  String
}

type T_DocDelete = Object

type T_DocUpdateResult = Object

type T_AclMetadata = {
  canShare: @Description(value = "When true, the user of the api can share")
  Boolean,
  canShareWithWorkspace: @Description(value = "When true, the user of the api can share with the workspace")
  Boolean,
  canShareWithOrg: @Description(value = "When true, the user of the api can share with the org")
  Boolean,
  canCopy: @Description(value = "When true, the user of the api can copy the doc")
  Boolean
}

type T_Acl = {
  items: Array<T_Permission>,
  href: @Description(value = "API link to these results")
  String,
  nextPageToken?: @Description(value = "If specified, an opaque token used to fetch the next page of results.")
  T_nextPageToken,
  nextPageLink?: T_nextPageLink & String
}

type T_AccessTypeNotNone = "readonly" | "write" | "comment"

type T_AddedPrincipal = Object & ((T_AddedEmailPrincipal | T_AddedGroupPrincipal | T_AddedDomainPrincipal | T_AddedWorkspacePrincipal | T_AddedAnyonePrincipal))

type T_AddPermissionResult = Object

type T_DeletePermissionResult = Object

type T_SearchPrincipalsResponse = {
  users: Array<T_UserSummary>,
  groups: Array<T_GroupPrincipal>
}

type T_AclSettings = {
  allowEditorsToChangePermissions: @Description(value = "When true, allows editors to change doc permissions. When false, only doc owner can change doc permissions.\n")
  Boolean,
  allowCopying: @Description(value = "When true, allows doc viewers to copy the doc.")
  Boolean,
  allowViewersToRequestEditing: @Description(value = "When true, allows doc viewers to request editing permissions.")
  Boolean
}

type T_DocPublishMode = "view" | "play" | "edit"

type T_PublishResult = T_DocumentMutateResponse & Object

type T_UnpublishResult = Object

type T_PageList = {
  items: Array<T_Page>,
  href?: @Description(value = "API link to these results")
  String,
  nextPageToken?: @Description(value = "If specified, an opaque token used to fetch the next page of results.")
  T_nextPageToken,
  nextPageLink?: T_nextPageLink & String
}

type T_PageCreateContent = {
  "type": @Description(value = "Indicates a page containing canvas content.")
  "canvas",
  canvasContent: @Description(value = "Content for a page (canvas).")
  T_PageContent
} | {
  "type": @Description(value = "Indicates a page that embeds other content.")
  "embed",
  url: @Description(value = "The URL of the content to embed.")
  String,
  renderMethod?: @Description(value = "Render mode for a page using the Embed page type.")
  T_PageEmbedRenderMethod
} | {
  "type": @Description(value = "Indicates a page that embeds other Coda content.")
  "syncPage",
  mode: @Description(value = "Indicates a single-page sync page.")
  "page",
  includeSubpages: @Description(value = "Include subpages in the sync page.")
  Boolean,
  sourcePageId: @Description(value = "The page id to insert as a sync page.")
  String,
  sourceDocId: @Description(value = "The id of the document to insert as a sync page.")
  String
} | {
  "type": @Description(value = "Indicates a page that embeds other content.")
  "syncPage",
  mode: @Description(value = "Indicates a full doc sync page.")
  "document",
  sourceDocId: @Description(value = "The id of the document to insert as a sync page.")
  String
}

type T_PageCreateResult = T_DocumentMutateResponse & {
  id: @Description(value = "ID of the created page.")
  String
}

type T_Page = {
  id: @Description(value = "ID of the page.")
  String,
  "type": @Description(value = "The type of this resource.")
  "page",
  href: @Description(value = "API link to the page.")
  String,
  browserLink: @Description(value = "Browser-friendly link to the page.")
  String,
  name: @Description(value = "Name of the page.")
  String,
  subtitle?: @Description(value = "Subtitle of the page.")
  String,
  icon?: @Description(value = "Info about the icon.")
  T_Icon,
  image?: @Description(value = "Info about the image.")
  T_Image,
  contentType: @Description(value = "The type of a page in a doc.")
  T_PageType,
  isHidden: @Description(value = "Whether the page is hidden in the UI.")
  Boolean,
  isEffectivelyHidden: @Description(value = "Whether the page or any of its parents is hidden in the UI.")
  Boolean,
  parent?: @Description(value = "Reference to a page.")
  T_PageReference,
  children: Array<T_PageReference>,
  authors?: @Description(value = "Authors of the page")
  Array<T_PersonValue>,
  createdAt?: @Description(value = "Timestamp for when the page was created.")
  LWDateTime,
  createdBy?: @Description(value = "A named reference to a person, where the person is identified by email address.")
  T_PersonValue,
  updatedAt?: @Description(value = "Timestamp for when page content was last modified.")
  LWDateTime,
  updatedBy?: @Description(value = "A named reference to a person, where the person is identified by email address.")
  T_PersonValue
}

type T_PageContentUpdate = {
  insertionMode: @Description(value = "Mode for inserting content into an existing page.")
  T_PageContentInsertionMode,
  canvasContent: @Description(value = "Content for a page (canvas).")
  T_PageContent
}

type T_PageUpdateResult = T_DocumentMutateResponse & {
  id: @Description(value = "ID of the updated page.")
  String
}

type T_PageDeleteResult = T_DocumentMutateResponse & {
  id: @Description(value = "ID of the page to be deleted.")
  String
}

type T_PageContentOutputFormat = "html" | "markdown"

type T_BeginPageContentExportResponse = {
  id: @Description(value = "The identifier of this export request.")
  String,
  status: @Description(value = "The status of this export.")
  String,
  href: @Description(value = "The URL that reports the status of this export. Poll this URL to get the content URL when the export has completed.")
  String
}

type T_PageContentExportStatusResponse = {
  id: @Description(value = "The identifier of this export request.")
  String,
  status: @Description(value = "The status of this export.")
  String,
  href: @Description(value = "The URL that reports the status of this export.")
  String,
  downloadLink?: @Description(value = "Once the export completes, the location where the resulting export file can be downloaded; this link typically expires after a short time.  Call this method again to get a fresh link.")
  String,
  error?: @Description(value = "Message describing an error, if this export failed.")
  String
}

type T_TableList = {
  items: Array<T_TableReference>,
  href?: @Description(value = "API link to these results")
  String,
  nextPageToken?: @Description(value = "If specified, an opaque token used to fetch the next page of results.")
  T_nextPageToken,
  nextPageLink?: T_nextPageLink & String
}

type T_Table = {
  id: @Description(value = "ID of the table.")
  String,
  "type": @Description(value = "The type of this resource.")
  "table",
  tableType: T_TableType,
  href: @Description(value = "API link to the table.")
  String,
  browserLink: @Description(value = "Browser-friendly link to the table.")
  String,
  name: @Description(value = "Name of the table.")
  String,
  parent: @Description(value = "Reference to a page.")
  T_PageReference,
  parentTable?: @Description(value = "Reference to a table or view.")
  T_TableReference,
  displayColumn: @Description(value = "Reference to a column.")
  T_ColumnReference,
  rowCount: @Description(value = "Total number of rows in the table.")
  Integer,
  sorts: @Description(value = "Any sorts applied to the table.")
  Array<T_Sort>,
  layout: @Description(value = "Layout type of the table or view.")
  T_Layout,
  filter?: Object & T_FormulaDetail,
  createdAt: @Description(value = "Timestamp for when the table was created.")
  LWDateTime,
  updatedAt: @Description(value = "Timestamp for when the table was last modified.")
  LWDateTime,
  viewId: Any
}

type T_ColumnList = {
  items: Array<T_Column>,
  href?: @Description(value = "API link to these results")
  String,
  nextPageToken?: @Description(value = "If specified, an opaque token used to fetch the next page of results.")
  T_nextPageToken,
  nextPageLink?: T_nextPageLink & String
}

type T_RowList = {
  items: Array<T_Row>,
  href?: @Description(value = "API link to these results")
  String,
  nextPageToken?: @Description(value = "If specified, an opaque token used to fetch the next page of results.")
  T_nextPageToken,
  nextPageLink?: T_nextPageLink & String,
  nextSyncToken?: @Description(value = "If specified, an opaque token that can be passed back later to retrieve new results that match the parameters specified when the sync token was created.\n")
  T_nextSyncToken
}

type T_RowEdit = {
  cells: Array<T_CellEdit>
}

type T_RowsUpsertResult = T_DocumentMutateResponse & {
  addedRowIds?: @Description(value = "Row IDs for rows that will be added. Only applicable when keyColumns is not set or empty.")
  Array<String>
}

type T_RowsDeleteResult = T_DocumentMutateResponse & {
  rowIds: @Description(value = "Row IDs to delete.")
  Array<String>
}

type T_RowDetail = {
  id: @Description(value = "ID of the row.")
  String,
  "type": @Description(value = "The type of this resource.")
  "row",
  href: @Description(value = "API link to the row.")
  String,
  name: @Description(value = "The display name of the row, based on its identifying column.")
  String,
  index: @Description(value = "Index of the row within the table.")
  Integer,
  browserLink: @Description(value = "Browser-friendly link to the row.")
  String,
  createdAt: @Description(value = "Timestamp for when the row was created.")
  LWDateTime,
  updatedAt: @Description(value = "Timestamp for when the row was last modified.")
  LWDateTime,
  values: @Description(value = "Values for a specific row, represented as a hash of column IDs (or names with `useColumnNames`) to values.\n")
  {
    _?: T_CellValue
  },
  parent: @Description(value = "Reference to a table or view.")
  T_TableReference
}

type T_RowUpdateResult = T_DocumentMutateResponse & {
  id: @Description(value = "ID of the updated row.")
  String
}

type T_RowDeleteResult = T_DocumentMutateResponse & {
  id: @Description(value = "ID of the row to be deleted.")
  String
}

type T_PushButtonResult = T_DocumentMutateResponse & {
  rowId: @Description(value = "ID of the row where the button exists.")
  String,
  columnId: @Description(value = "ID of the column where the button exists.")
  String
}

type T_ColumnDetail = {
  id: @Description(value = "ID of the column.")
  String,
  "type": @Description(value = "The type of this resource.")
  "column",
  href: @Description(value = "API link to the column.")
  String,
  name: @Description(value = "Name of the column.")
  String,
  display?: @Description(value = "Whether the column is the display column.")
  Boolean,
  calculated?: @Description(value = "Whether the column has a formula set on it.")
  Boolean,
  formula?: @Description(value = "Formula on the column.")
  String,
  defaultValue?: @Description(value = "Default value formula for the column.")
  String,
  format: @Description(value = "Format of a column.")
  T_ColumnFormat,
  parent: @Description(value = "Reference to a table or view.")
  T_TableReference
}

type T_FormulaList = {
  items: Array<T_FormulaReference>,
  href?: @Description(value = "API link to these results")
  String,
  nextPageToken?: @Description(value = "If specified, an opaque token used to fetch the next page of results.")
  T_nextPageToken,
  nextPageLink?: T_nextPageLink & String
}

type T_Formula = {
  id: @Description(value = "ID of the formula.")
  String,
  "type": @Description(value = "The type of this resource.")
  "formula",
  href: @Description(value = "API link to the formula.")
  String,
  name: @Description(value = "Name of the formula.")
  String,
  parent?: @Description(value = "Reference to a page.")
  T_PageReference,
  value: @Description(value = "A Coda result or entity expressed as a primitive type, or array of primitive types.")
  T_Value
}

type T_ControlList = {
  items: Array<T_ControlReference>,
  href?: @Description(value = "API link to these results")
  String,
  nextPageToken?: @Description(value = "If specified, an opaque token used to fetch the next page of results.")
  T_nextPageToken,
  nextPageLink?: T_nextPageLink & String
}

type T_Control = {
  id: @Description(value = "ID of the control.")
  String,
  "type": @Description(value = "The type of this resource.")
  "control",
  href: @Description(value = "API link to the control.")
  String,
  name: @Description(value = "Name of the control.")
  String,
  parent?: @Description(value = "Reference to a page.")
  T_PageReference,
  controlType: @Description(value = "Type of the control.")
  T_ControlType,
  value: @Description(value = "A Coda result or entity expressed as a primitive type, or array of primitive types.")
  T_Value
}

type T_CustomDocDomainList = {
  customDocDomains: @Description(value = "Custom domains for the published doc.")
  Array<T_CustomDocDomain>,
  nextPageToken?: @Description(value = "If specified, an opaque token used to fetch the next page of results.")
  T_nextPageToken,
  nextPageLink?: T_nextPageLink & String
}

type T_AddCustomDocDomainResponse = Object

type T_DeleteCustomDocDomainResponse = Object

type T_UpdateCustomDocDomainResponse = Object

type T_Folder = {
  createdAt: @Description(value = "Timestamp for when the folder was created.")
  LWDateTime,
  description?: @Description(value = "The description of the folder.")
  String,
  icon?: @Description(value = "Info about the icon.")
  T_Icon,
  id: @Description(value = "ID of the Coda folder.")
  String,
  name: @Description(value = "The name of the folder.")
  String,
  "type": @Description(value = "The type of this resource.")
  "folder",
  workspaceId: @Description(value = "ID of the Coda workspace.")
  String
}

type T_User = {
  name: @Description(value = "Name of the user.")
  String,
  loginId: @Description(value = "Email address of the user.")
  String,
  "type": @Description(value = "The type of this resource.")
  "user",
  pictureLink?: @Description(value = "Browser-friendly link to the user's avatar image.")
  String,
  scoped: @Description(value = "True if the token used to make this request has restricted/scoped access to the API.")
  Boolean,
  tokenName: @Description(value = "Returns the name of the token used for this request.")
  String,
  href: @Description(value = "API link to the user.")
  String,
  workspace: @Description(value = "Reference to a Coda workspace.")
  T_WorkspaceReference
}

type T_WorkspaceMembersList = {
  items: Array<T_WorkspaceUser>,
  nextPageToken?: @Description(value = "If specified, an opaque token used to fetch the next page of results.")
  T_nextPageToken,
  nextPageLink?: T_nextPageLink & String
}

type T_ChangeRoleResult = {
  roleChangedAt: @Description(value = "Timestamp for when the user's role last changed in this workspace.")
  LWDateTime
}

type T_GetWorkspaceRoleActivity = {
  items: Array<T_WorkspaceRoleActivity>
}

type T_AddGoLinkResult = Object

type T_DocCategory = {
  name: @Description(value = "Name of the category.")
  String
}

type T_nextPageToken = String

type T_nextPageLink = String

type T_Icon = {
  name: @Description(value = "Name of the icon.")
  String,
  "type": @Description(value = "MIME type of the icon")
  String,
  browserLink: @Description(value = "Browser-friendly link to an icon.")
  String
}

type T_DocSize = {
  totalRowCount: @Description(value = "The number of rows contained within all tables of the doc.")
  Number,
  tableAndViewCount: @Description(value = "The total number of tables and views contained within the doc.")
  Number,
  pageCount: @Description(value = "The total number of page contained within the doc.")
  Number,
  overApiSizeLimit: @Description(value = "If true, indicates that the doc is over the API size limit.")
  Boolean
}

type T_DocReference = {
  id: @Description(value = "ID of the Coda doc.")
  String,
  "type": @Description(value = "The type of this resource.")
  "doc",
  href: @Description(value = "API link to the Coda doc.")
  String,
  browserLink: @Description(value = "Browser-friendly link to the Coda doc.")
  String
}

type T_DocPublished = {
  description?: @Description(value = "Description of the published doc.")
  String,
  browserLink: @Description(value = "URL to the published doc.")
  String,
  imageLink?: @Description(value = "URL to the cover image for the published doc.")
  String,
  discoverable: @Description(value = "If true, indicates that the doc is discoverable.")
  Boolean,
  earnCredit: @Description(value = "If true, new users may be required to sign in to view content within this document. You will receive Coda credit for each user who signs up via your doc.\n")
  Boolean,
  mode: @Description(value = "Which interaction mode the published doc should use.")
  T_DocPublishMode,
  categories: @Description(value = "Categories applied to the doc.")
  Array<T_DocCategory>
}

type T_FolderReference = {
  id: @Description(value = "ID of the Coda folder.")
  String,
  "type": @Description(value = "The type of this resource.")
  "folder",
  browserLink: @Description(value = "Browser-friendly link to the folder.")
  String,
  name?: @Description(value = "Name of the folder; included if the user has access to the folder.")
  String
}

type T_WorkspaceReference = {
  id: @Description(value = "ID of the Coda workspace.")
  String,
  "type": @Description(value = "The type of this resource.")
  "workspace",
  organizationId?: @Description(value = "ID of the organization bound to this workspace, if any.")
  String,
  browserLink: @Description(value = "Browser-friendly link to the Coda workspace.")
  String,
  name?: @Description(value = "Name of the workspace; included if the user has access to the workspace.")
  String
}

type T_Permission = {
  principal: @Description(value = "Metadata about a principal.")
  T_Principal,
  id: @Description(value = "Id for the Permission")
  String,
  access: @Description(value = "Type of access.")
  T_AccessType
}

type T_AddedEmailPrincipal = {
  "type": @Description(value = "The type of this principal.")
  "email",
  email: @Description(value = "Email for the principal.")
  String
}

type T_AddedGroupPrincipal = {
  "type": @Description(value = "The type of this principal.")
  "group",
  groupId: @Description(value = "Group ID for the principal.")
  String
}

type T_AddedDomainPrincipal = {
  "type": @Description(value = "The type of this principal.")
  "domain",
  domain: @Description(value = "Domain for the principal.")
  String
}

type T_AddedWorkspacePrincipal = {
  "type": @Description(value = "The type of this principal.")
  "workspace",
  workspaceId: @Description(value = "WorkspaceId for the principal.")
  String
}

type T_AddedAnyonePrincipal = {
  "type": @Description(value = "The type of this principal.")
  "anyone"
}

type T_UserSummary = {
  name: @Description(value = "Name of the user.")
  String,
  loginId: @Description(value = "Email address of the user.")
  String,
  "type": @Description(value = "The type of this resource.")
  "user",
  pictureLink?: @Description(value = "Browser-friendly link to the user's avatar image.")
  String
}

type T_GroupPrincipal = {
  "type": @Description(value = "The type of this principal.")
  "group",
  groupId: @Description(value = "Group ID for the principal.")
  String,
  groupName: @Description(value = "Name of the group.")
  String
}

type T_DocumentMutateResponse = {
  requestId: @Description(value = "An arbitrary unique identifier for this request.")
  String
}

type T_PageContent = {
  format: @Description(value = "Supported content types for page (canvas) content.")
  T_PageContentFormat,
  content: @Description(value = "The actual page content.")
  String
}

type T_PageEmbedRenderMethod = "compatibility" | "standard"

type T_Image = {
  browserLink: @Description(value = "Browser-friendly link to an image.")
  String,
  "type"?: @Description(value = "MIME type of the image.")
  String,
  width?: @Description(value = "The width in pixels of the image.")
  Number,
  height?: @Description(value = "The height in pixels of the image.")
  Number
}

type T_PageType = "canvas" | "embed" | "syncPage"

type T_PageReference = {
  id: @Description(value = "ID of the page.")
  String,
  "type": @Description(value = "The type of this resource.")
  "page",
  href: @Description(value = "API link to the page.")
  String,
  browserLink: @Description(value = "Browser-friendly link to the page.")
  String,
  name: @Description(value = "Name of the page.")
  String
}

type T_PersonValue = T_LinkedDataObject & {
  "@type": "Person",
  name: @Description(value = "The full name of the person.")
  String,
  email?: @Description(value = "The email address of the person.")
  String
}

type T_PageContentInsertionMode = "append" | "replace"

type T_TableReference = {
  id: @Description(value = "ID of the table.")
  String,
  "type": @Description(value = "The type of this resource.")
  "table",
  tableType: T_TableType,
  href: @Description(value = "API link to the table.")
  String,
  browserLink: @Description(value = "Browser-friendly link to the table.")
  String,
  name: @Description(value = "Name of the table.")
  String,
  parent?: @Description(value = "Reference to a page.")
  T_PageReference
}

type T_ColumnReference = {
  id: @Description(value = "ID of the column.")
  String,
  "type": @Description(value = "The type of this resource.")
  "column",
  href: @Description(value = "API link to the column.")
  String
}

type T_Sort = {
  column: @Description(value = "Reference to a column.")
  T_ColumnReference,
  direction: @Description(value = "Direction of a sort for a table or view.")
  T_SortDirection
}

type T_Layout = "default" | "areaChart" | "barChart" | "bubbleChart" | "calendar" | "card" | "detail" | "form" | "ganttChart" | "lineChart" | "masterDetail" | "pieChart" | "scatterChart" | "slide" | "wordCloud"

type T_FormulaDetail = {
  valid: @Description(value = "Returns whether or not the given formula is valid.")
  Boolean,
  isVolatile?: @Description(value = "Returns whether or not the given formula can return different results in different contexts (for example, for different users).\n")
  Boolean,
  hasUserFormula?: @Description(value = "Returns whether or not the given formula has a User() formula within it.")
  Boolean,
  hasTodayFormula?: @Description(value = "Returns whether or not the given formula has a Today() formula within it.")
  Boolean,
  hasNowFormula?: @Description(value = "Returns whether or not the given formula has a Now() formula within it.")
  Boolean
}

type T_Column = {
  id: @Description(value = "ID of the column.")
  String,
  "type": @Description(value = "The type of this resource.")
  "column",
  href: @Description(value = "API link to the column.")
  String,
  name: @Description(value = "Name of the column.")
  String,
  display?: @Description(value = "Whether the column is the display column.")
  Boolean,
  calculated?: @Description(value = "Whether the column has a formula set on it.")
  Boolean,
  formula?: @Description(value = "Formula on the column.")
  String,
  defaultValue?: @Description(value = "Default value formula for the column.")
  String,
  format: @Description(value = "Format of a column.")
  T_ColumnFormat
}

type T_Row = {
  id: @Description(value = "ID of the row.")
  String,
  "type": @Description(value = "The type of this resource.")
  "row",
  href: @Description(value = "API link to the row.")
  String,
  name: @Description(value = "The display name of the row, based on its identifying column.")
  String,
  index: @Description(value = "Index of the row within the table.")
  Integer,
  browserLink: @Description(value = "Browser-friendly link to the row.")
  String,
  createdAt: @Description(value = "Timestamp for when the row was created.")
  LWDateTime,
  updatedAt: @Description(value = "Timestamp for when the row was last modified.")
  LWDateTime,
  values: @Description(value = "Values for a specific row, represented as a hash of column IDs (or names with `useColumnNames`) to values.\n")
  {
    _?: T_CellValue
  }
}

type T_nextSyncToken = String

type T_CellEdit = {
  column: @Description(value = "Column ID, URL, or name (fragile and discouraged) associated with this edit.")
  String,
  value: @Description(value = "A Coda result or entity expressed as a primitive type, or array of primitive types.")
  T_Value
}

type T_CellValue = T_Value | T_RichValue

type T_ColumnFormat = Object & ((T_ButtonColumnFormat | T_CheckboxColumnFormat | T_DateColumnFormat | T_DateTimeColumnFormat | T_DurationColumnFormat | T_EmailColumnFormat | T_LinkColumnFormat | T_CurrencyColumnFormat | T_ImageReferenceColumnFormat | T_NumericColumnFormat | T_ReferenceColumnFormat | T_SelectColumnFormat | T_SimpleColumnFormat | T_ScaleColumnFormat | T_SliderColumnFormat | T_TimeColumnFormat))

type T_FormulaReference = {
  id: @Description(value = "ID of the formula.")
  String,
  "type": @Description(value = "The type of this resource.")
  "formula",
  href: @Description(value = "API link to the formula.")
  String,
  name: @Description(value = "Name of the formula.")
  String,
  parent?: @Description(value = "Reference to a page.")
  T_PageReference
}

type T_Value = Object & ((T_ScalarValue | Array<T_ScalarValue | Array<T_ScalarValue>>))

type T_ControlReference = {
  id: @Description(value = "ID of the control.")
  String,
  "type": @Description(value = "The type of this resource.")
  "control",
  href: @Description(value = "API link to the control.")
  String,
  name: @Description(value = "Name of the control.")
  String,
  parent?: @Description(value = "Reference to a page.")
  T_PageReference
}

type T_ControlType = "aiBlock" | "button" | "checkbox" | "datePicker" | "dateRangePicker" | "dateTimePicker" | "lookup" | "multiselect" | "select" | "scale" | "slider" | "reaction" | "textbox" | "timePicker"

type T_CustomDocDomain = {
  customDocDomain: @Description(value = "The custom domain.")
  String,
  hasCertificate: @Description(value = "Whether the domain has a certificate")
  Boolean,
  hasDnsDocId: @Description(value = "Whether the domain DNS points back to this doc.")
  Boolean,
  setupStatus: T_CustomDocDomainSetupStatus,
  domainStatus: T_CustomDomainConnectedStatus,
  lastVerifiedTimestamp?: @Description(value = "When the domain DNS settings were last checked.")
  LWDateTime
}

type T_WorkspaceUser = {
  email: @Description(value = "Email of the user.")
  String,
  name: @Description(value = "Name of the user.")
  String,
  role: T_WorkspaceUserRole,
  pictureUrl?: @Description(value = "Picture url of the user.")
  String,
  registeredAt: @Description(value = "Timestamp for when the user registered in this workspace")
  LWDateTime,
  roleChangedAt?: @Description(value = "Timestamp for when the user's role last changed in this workspace.")
  LWDateTime,
  lastActiveAt?: @Description(value = "Date when the user last took an action in any workspace.")
  LWDate,
  ownedDocs?: @Description(value = "Number of docs the user owns in this workspace.")
  Number,
  docsLastActiveAt?: @Description(value = "Date when anyone last accessed a doc that the user owns in this workspace.")
  LWDate,
  docCollaboratorCount?: @Description(value = "Number of collaborators that have interacted with docs owned by the user in the last 90 days.")
  Number,
  totalDocs?: @Description(value = "Number of docs the user owns, manages, or to which they have added pages in the last 90 days.")
  Number,
  totalDocsLastActiveAt?: @Description(value = "Date when anyone last accessed a doc the member owns or contributed to.")
  LWDate,
  totalDocCollaboratorsLast90Days?: @Description(value = "Number of unique users that have viewed any doc the user owns, manages, or has added pages to in the last 90 days.")
  Number
}

type T_WorkspaceRoleActivity = {
  month: @Description(value = "Month corresponding to the data.")
  String,
  activeAdminCount: @Description(value = "Number of active Admins.")
  Number,
  activeDocMakerCount: @Description(value = "Number of active Doc Makers.")
  Number,
  activeEditorCount: @Description(value = "Number of active Editors.")
  Number,
  inactiveAdminCount: @Description(value = "Number of inactive Admins.")
  Number,
  inactiveDocMakerCount: @Description(value = "Number of inactive Doc Makers.")
  Number,
  inactiveEditorCount: @Description(value = "Number of inactive Editor users.")
  Number
}

type T_Principal = Object & ((T_EmailPrincipal | T_GroupPrincipal | T_DomainPrincipal | T_WorkspacePrincipal | T_AnyonePrincipal))

type T_AccessType = "readonly" | "write" | "comment" | "none"

type T_PageContentFormat = "html" | "markdown"

type T_LinkedDataObject = {
  "@context": @Description(value = "A url describing the schema context for this object, typically \"http://schema.org/\".")
  String,
  "@type": @Description(value = "A schema.org identifier for the object.")
  T_LinkedDataType,
  additionalType?: @Description(value = "An identifier of additional type info specific to Coda that may not be present in a schema.org taxonomy,\n")
  String
}

type T_SortDirection = "ascending" | "descending"

type T_RichValue = T_RichSingleValue | Array<T_RichSingleValue | Array<T_RichSingleValue>>

type T_ButtonColumnFormat = T_SimpleColumnFormat & {
  label?: @Description(value = "Label formula for the button.")
  String,
  disableIf?: @Description(value = "DisableIf formula for the button.")
  String,
  action?: @Description(value = "Action formula for the button.")
  String
}

type T_CheckboxColumnFormat = T_SimpleColumnFormat & {
  displayType: @Description(value = "How a checkbox should be displayed.")
  T_CheckboxDisplayType
}

type T_DateColumnFormat = T_SimpleColumnFormat & {
  format?: @Description(value = "A format string using Moment syntax: https://momentjs.com/docs/#/displaying/")
  String
}

type T_DateTimeColumnFormat = T_SimpleColumnFormat & {
  dateFormat?: @Description(value = "A format string using Moment syntax: https://momentjs.com/docs/#/displaying/")
  String,
  timeFormat?: @Description(value = "A format string using Moment syntax: https://momentjs.com/docs/#/displaying/")
  String
}

type T_DurationColumnFormat = T_SimpleColumnFormat & {
  precision?: Integer,
  maxUnit?: Object & T_DurationUnit
}

type T_EmailColumnFormat = T_SimpleColumnFormat & {
  display?: @Description(value = "How an email address should be displayed in the user interface.")
  T_EmailDisplayType,
  autocomplete?: Boolean
}

type T_LinkColumnFormat = T_SimpleColumnFormat & {
  display?: @Description(value = "How a link should be displayed in the user interface.")
  T_LinkDisplayType,
  force?: @Description(value = "Force embeds to render on the client instead of the server (for sites that require user login).")
  Boolean
}

type T_CurrencyColumnFormat = T_SimpleColumnFormat & {
  currencyCode?: @Description(value = "The currency symbol")
  String,
  precision?: @Description(value = "The decimal precision.")
  Integer,
  format?: @Description(value = "How the numeric value should be formatted (with or without symbol, negative numbers in parens).")
  T_CurrencyFormatType
}

type T_ImageReferenceColumnFormat = T_SimpleColumnFormat & {
  width: Object & T_NumberOrNumberFormula,
  height: Object & T_NumberOrNumberFormula,
  style: @Description(value = "How an image should be displayed.")
  T_ImageShapeStyle
}

type T_NumericColumnFormat = T_SimpleColumnFormat & {
  precision?: @Description(value = "The decimal precision.")
  Integer,
  useThousandsSeparator?: @Description(value = "Whether to use a thousands separator (like \",\") to format the numeric value.")
  Boolean
}

type T_ReferenceColumnFormat = T_SimpleColumnFormat & {
  table: Object & T_TableReference
}

type T_SelectColumnFormat = T_SimpleColumnFormat & {
  options?: @Description(value = "For select format columns, the list of available options. Only returned for select lists that used a fixed set of options. Returns the first 5000 options.")
  Array<T_SelectOption>
}

type T_SimpleColumnFormat = {
  "type": @Description(value = "Format type of the column")
  T_ColumnFormatType,
  isArray: @Description(value = "Whether or not this column is an array.")
  Boolean
}

type T_ScaleColumnFormat = T_SimpleColumnFormat & {
  maximum: @Description(value = "The maximum number allowed for this scale.")
  Number,
  icon: Object & T_IconSet
}

type T_SliderColumnFormat = T_SimpleColumnFormat & {
  minimum?: Object & T_NumberOrNumberFormula,
  maximum?: Object & T_NumberOrNumberFormula,
  step?: Object & T_NumberOrNumberFormula,
  displayType?: @Description(value = "How the slider should be rendered.")
  T_SliderDisplayType,
  showValue?: @Description(value = "Whether the underyling numeric value is also displayed.")
  Boolean
}

type T_TimeColumnFormat = T_SimpleColumnFormat & {
  format?: @Description(value = "A format string using Moment syntax: https://momentjs.com/docs/#/displaying/")
  String
}

type T_ScalarValue = String | Number | Boolean

type T_CustomDocDomainSetupStatus = "pending" | "succeeded" | "failed"

type T_CustomDomainConnectedStatus = "connected" | "notConnected"

type T_EmailPrincipal = {
  "type": @Description(value = "The type of this principal.")
  "email",
  email: @Description(value = "Email for the principal.")
  String
}

type T_DomainPrincipal = {
  "type": @Description(value = "The type of this principal.")
  "domain",
  domain: @Description(value = "Domain for the principal.")
  String
}

type T_WorkspacePrincipal = {
  "type": @Description(value = "The type of this principal.")
  "workspace",
  workspaceId: @Description(value = "WorkspaceId for the principal.")
  String
}

type T_AnyonePrincipal = {
  "type": @Description(value = "The type of this principal.")
  "anyone"
}

type T_LinkedDataType = "ImageObject" | "MonetaryAmount" | "Person" | "WebPage" | "StructuredValue"

type T_RichSingleValue = Object & ((T_ScalarValue | T_CurrencyValue | T_ImageUrlValue | T_PersonValue | T_UrlValue | T_RowValue))

type T_CheckboxDisplayType = "toggle" | "check"

type T_DurationUnit = "days" | "hours" | "minutes" | "seconds"

type T_EmailDisplayType = "iconAndEmail" | "iconOnly" | "emailOnly"

type T_LinkDisplayType = "iconOnly" | "url" | "title" | "card" | "embed"

type T_CurrencyFormatType = "currency" | "accounting" | "financial"

type T_NumberOrNumberFormula = Number | String

type T_ImageShapeStyle = "auto" | "circle"

type T_SelectOption = {
  name: @Description(value = "The name of the option.")
  String,
  backgroundColor?: @Description(value = "The background color of the option.")
  String,
  foregroundColor?: @Description(value = "The foreground color of the option.")
  String
}

type T_ColumnFormatType = "text" | "person" | "lookup" | "number" | "percent" | "currency" | "date" | "dateTime" | "time" | "duration" | "email" | "link" | "slider" | "scale" | "image" | "imageReference" | "attachments" | "button" | "checkbox" | "select" | "packObject" | "reaction" | "canvas" | "other"

type T_IconSet = "star" | "circle" | "fire" | "bug" | "diamond" | "bell" | "thumbsup" | "heart" | "chili" | "smiley" | "lightning" | "currency" | "coffee" | "person" | "battery" | "cocktail" | "cloud" | "sun" | "checkmark" | "lightbulb"

type T_SliderDisplayType = "slider" | "progress"

type T_CurrencyValue = T_LinkedDataObject & {
  "@type": "MonetaryAmount",
  currency: @Description(value = "The 3-letter currency code.")
  String,
  amount: @Description(value = "A numeric monetary amount as a string or number.")
  T_CurrencyAmount
}

type T_ImageUrlValue = T_LinkedDataObject & {
  "@type": "ImageObject",
  name?: @Description(value = "The name of the image.")
  String,
  url?: @Description(value = "The url of the image.")
  String,
  height?: @Description(value = "The height of the image in pixels.")
  Number,
  width?: @Description(value = "The width of the image in pixels.")
  Number,
  status?: @Description(value = "The status values that an image object can have.")
  T_ImageStatus
}

type T_UrlValue = T_LinkedDataObject & {
  "@type": "WebPage",
  name?: @Description(value = "The user-visible text of the hyperlink.")
  String,
  url: @Description(value = "The url of the hyperlink.")
  String
}

type T_RowValue = T_LinkedDataObject & {
  "@type": "StructuredValue",
  name: @Description(value = "The display name of the row, based on its identifying column.")
  String,
  url: @Description(value = "The url of the row.")
  String,
  tableId: @Description(value = "The ID of the table")
  String,
  rowId: @Description(value = "The ID of the table")
  String,
  tableUrl: @Description(value = "The url of the table.")
  String,
  additionalType: @Description(value = "The type of this resource.")
  "row"
}

type T_CurrencyAmount = String | Number

type T_ImageStatus = "live" | "deleted" | "failed"

