%dw 2.8

import OperationElement from com::mulesoft::connectivity::Metadata

import Error, Result, ResultFailure, failure, success from com::mulesoft::connectivity::Model

import T_PageDeleteResult from com::mulesoft::connectivity::coda::types::Types

import Description from com::mulesoft::connectivity::decorator::Annotations

import HttpConnection, HttpRequestType, HttpResponse from com::mulesoft::connectivity::transport::Http

import serializeCookies, serializeHeaders, serializeUriParams, withSerializationConfig from com::mulesoft::connectivity::transport::Serialization

type O_docs__docId__pages__pageIdOrName__delete_Type = {
  "202": HttpResponse<T_PageDeleteResult>,
  "400": HttpResponse<{ statusCode: @Description(value = "HTTP status code of the error.")
  Number, statusMessage: @Description(value = "HTTP status message of the error.")
  String, message: @Description(value = "Any additional context on the error, or the same as `statusMessage` otherwise.")
  String }>,
  "401": HttpResponse<{ statusCode: @Description(value = "HTTP status code of the error.")
  Number, statusMessage: @Description(value = "HTTP status message of the error.")
  String, message: @Description(value = "Any additional context on the error, or the same as `statusMessage` otherwise.")
  String }>,
  "403": HttpResponse<{ statusCode: @Description(value = "HTTP status code of the error.")
  Number, statusMessage: @Description(value = "HTTP status message of the error.")
  String, message: @Description(value = "Any additional context on the error, or the same as `statusMessage` otherwise.")
  String }>,
  "404": HttpResponse<{ statusCode: @Description(value = "HTTP status code of the error.")
  Number, statusMessage: @Description(value = "HTTP status message of the error.")
  String, message: @Description(value = "Any additional context on the error, or the same as `statusMessage` otherwise.")
  String }>,
  "429": HttpResponse<{ statusCode: @Description(value = "HTTP status code of the error.")
  Number, statusMessage: @Description(value = "HTTP status message of the error.")
  String, message: @Description(value = "Any additional context on the error, or the same as `statusMessage` otherwise.")
  String }>,
  errorResponse: ResultFailure<O_docs__docId__pages__pageIdOrName__delete_Type."400", Error<"status-400", "CLIENT_ERROR">> | ResultFailure<O_docs__docId__pages__pageIdOrName__delete_Type."401", Error<"status-401", "CLIENT_ERROR">> | ResultFailure<O_docs__docId__pages__pageIdOrName__delete_Type."403", Error<"status-403", "CLIENT_ERROR">> | ResultFailure<O_docs__docId__pages__pageIdOrName__delete_Type."404", Error<"status-404", "CLIENT_ERROR">> | ResultFailure<O_docs__docId__pages__pageIdOrName__delete_Type."429", Error<"status-429", "CLIENT_ERROR">> | ResultFailure<HttpResponse<Any>, Error<"status-unexpected", String>>,
  request: HttpRequestType<{| uri: {| docId: String, pageIdOrName: String |}, query: Object, headers: Object, cookie: Object |}>,
  response: O_docs__docId__pages__pageIdOrName__delete_Type."202"
}

@OperationElement()
var O_docs__docId__pages__pageIdOrName__delete = {
  name: "deletePage",
  displayName: "deletePage",
  executor: (parameter: O_docs__docId__pages__pageIdOrName__delete_Type.request, connection: HttpConnection): Result<O_docs__docId__pages__pageIdOrName__delete_Type.response, O_docs__docId__pages__pageIdOrName__delete_Type.errorResponse> -> do {
      var uri = serializeUriParams(parameter.uri, {})
      var query = parameter.query default {} withSerializationConfig {}
      var headers = serializeHeaders(parameter.headers default {}, {})
      var cookie = serializeCookies(parameter.cookie default {}, {})
      var response = connection({
        method: "DELETE",
        path: "/docs/$(uri.docId)/pages/$(uri.pageIdOrName)",
        queryParams: query,
        headers: headers,
        cookie: cookie,
        (body: parameter.body) if (parameter.body?)
      })
      ---
      response match {
        case response202 if response202.status == 202 and response202 is O_docs__docId__pages__pageIdOrName__delete_Type."202" -> success(response202 as O_docs__docId__pages__pageIdOrName__delete_Type."202")
        case response400 if response400.status == 400 and response400 is O_docs__docId__pages__pageIdOrName__delete_Type."400" -> failure(response400 as O_docs__docId__pages__pageIdOrName__delete_Type."400", {
          kind: "status-400",
          categories: ["CLIENT_ERROR"]
        }, "The request parameters did not conform to expectations.")
        case response401 if response401.status == 401 and response401 is O_docs__docId__pages__pageIdOrName__delete_Type."401" -> failure(response401 as O_docs__docId__pages__pageIdOrName__delete_Type."401", {
          kind: "status-401",
          categories: ["CLIENT_ERROR"]
        }, "The API token is invalid or has expired.")
        case response403 if response403.status == 403 and response403 is O_docs__docId__pages__pageIdOrName__delete_Type."403" -> failure(response403 as O_docs__docId__pages__pageIdOrName__delete_Type."403", {
          kind: "status-403",
          categories: ["CLIENT_ERROR"]
        }, "The API token does not grant access to this resource.")
        case response404 if response404.status == 404 and response404 is O_docs__docId__pages__pageIdOrName__delete_Type."404" -> failure(response404 as O_docs__docId__pages__pageIdOrName__delete_Type."404", {
          kind: "status-404",
          categories: ["CLIENT_ERROR"]
        }, "The resource could not be located with the current API token.")
        case response429 if response429.status == 429 and response429 is O_docs__docId__pages__pageIdOrName__delete_Type."429" -> failure(response429 as O_docs__docId__pages__pageIdOrName__delete_Type."429", {
          kind: "status-429",
          categories: ["CLIENT_ERROR"]
        }, "The client has sent too many requests.")
        else responsedefault-> failure(responsedefault, {
          kind: "status-unexpected",
          categories: []
        }, "Unexpected status code")
      }
    }
}

