/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.cds.impl.repository;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.mulesoft.connectivity.cds.model.ContentDocumentModel;
import com.mulesoft.connectivity.cds.repository.ContentDocumentRepositoryInterface;
import com.mulesoft.connectivity.cds.repository.ContentDocumentStorageException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

public class FileBasedContentDocumentRepository
implements ContentDocumentRepositoryInterface {
    private static final Path BASE_STORAGE_DIRECTORY = Path.of(System.getProperty("java.io.tmpdir"), "content-documents");
    private static final Set<PosixFilePermission> SECURE_DIR_PERMISSIONS = PosixFilePermissions.fromString("rwx------");
    private static final Set<PosixFilePermission> SECURE_FILE_PERMISSIONS = PosixFilePermissions.fromString("rw-------");
    private static final FileBasedContentDocumentRepository INSTANCE = new FileBasedContentDocumentRepository();
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final Map<String, Path> documentPaths = new ConcurrentHashMap<String, Path>();

    private FileBasedContentDocumentRepository() {
    }

    public static FileBasedContentDocumentRepository getInstance() {
        return INSTANCE;
    }

    public ContentDocumentModel save(ContentDocumentModel document, @Nullable InputStream contentStream) {
        try {
            Path directory = BASE_STORAGE_DIRECTORY.resolve(FileBasedContentDocumentRepository.sanitizeFileName(document.getId()));
            this.createSecureDirectory(directory);
            Path metadataFile = Files.createTempFile(directory, "content-document-" + FileBasedContentDocumentRepository.sanitizeFileName(document.getId()), ".json", PosixFilePermissions.asFileAttribute(SECURE_FILE_PERMISSIONS));
            String fileName = document.getTitle() != null ? document.getTitle() : "content";
            Path dataFilePath = directory.resolve(FileBasedContentDocumentRepository.sanitizeFileName(fileName));
            long bytesCopied = 0L;
            if (contentStream != null) {
                try (InputStream in = contentStream;){
                    bytesCopied = this.writeContentWithSecurePermissions(dataFilePath, in);
                }
            } else {
                this.createSecureEmptyFile(dataFilePath);
            }
            document.setSize(Long.valueOf(bytesCopied));
            String json = MAPPER.writeValueAsString((Object)document);
            Files.writeString(metadataFile, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
            this.documentPaths.put(document.getId(), metadataFile);
            return document;
        }
        catch (IOException e) {
            throw new ContentDocumentStorageException("Failed to save document " + document.getId(), (Throwable)e);
        }
    }

    public @Nullable ContentDocumentModel findById(String id) {
        Path path = this.documentPaths.get(id);
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            String json = Files.readString(path, StandardCharsets.UTF_8);
            return (ContentDocumentModel)MAPPER.readValue(json, ContentDocumentModel.class);
        }
        catch (IOException e) {
            throw new ContentDocumentStorageException("Failed to load document " + id, (Throwable)e);
        }
    }

    public void cleanup() {
        this.documentPaths.values().forEach(path -> {
            try {
                Files.deleteIfExists(path);
                Path dir = path.getParent();
                if (dir != null && Files.isDirectory(dir, new LinkOption[0])) {
                    this.deleteDirectoryRecursively(dir);
                }
            }
            catch (IOException e) {
                System.err.println("Warning: Could not delete temporary file: " + String.valueOf(path));
            }
        });
        this.documentPaths.clear();
    }

    public InputStream openContentStream(String id) {
        Path path = this.documentPaths.get(id);
        if (path == null) {
            throw new ContentDocumentStorageException("No metadata found for document " + id);
        }
        Path dir = path.getParent();
        if (dir == null) {
            throw new ContentDocumentStorageException("Path " + String.valueOf(path) + " for document " + id + " has no parent");
        }
        String title = this.readTitleFromMetadata(path);
        Path contentPath = dir.resolve(FileBasedContentDocumentRepository.sanitizeFileName(title != null ? title : "content"));
        try {
            return Files.newInputStream(contentPath, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ContentDocumentStorageException("Failed to open content stream for document " + id, (Throwable)e);
        }
    }

    private @Nullable String readTitleFromMetadata(Path metadataPath) {
        try {
            String json = Files.readString(metadataPath, StandardCharsets.UTF_8);
            ContentDocumentModel model = (ContentDocumentModel)MAPPER.readValue(json, ContentDocumentModel.class);
            return model.getTitle();
        }
        catch (IOException e) {
            throw new ContentDocumentStorageException("Failed to read metadata from " + String.valueOf(metadataPath), (Throwable)e);
        }
    }

    private long writeContentWithSecurePermissions(Path targetPath, InputStream content) throws IOException {
        try {
            Files.createFile(targetPath, PosixFilePermissions.asFileAttribute(SECURE_FILE_PERMISSIONS));
        }
        catch (UnsupportedOperationException e) {
            try {
                Files.createFile(targetPath, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {}
        }
        catch (FileAlreadyExistsException e) {
            // empty catch block
        }
        long totalBytesWritten = 0L;
        byte[] buffer = new byte[16384];
        try (OutputStream out = Files.newOutputStream(targetPath, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            int read;
            while ((read = content.read(buffer)) != -1) {
                out.write(buffer, 0, read);
                totalBytesWritten += (long)read;
            }
        }
        return totalBytesWritten;
    }

    private void createSecureEmptyFile(Path path) throws IOException {
        try {
            Files.createFile(path, PosixFilePermissions.asFileAttribute(SECURE_FILE_PERMISSIONS));
        }
        catch (UnsupportedOperationException e) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {}
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }

    private void deleteDirectoryRecursively(Path directory) {
        try (Stream<Path> walk = Files.walk(directory, new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).forEach(this::deletePathSilently);
        }
        catch (IOException e) {
            System.err.println("Warning: Could not walk directory: " + String.valueOf(directory) + ": " + e.getMessage());
        }
    }

    private void deletePathSilently(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            System.err.println("Warning: Could not delete path: " + String.valueOf(path) + ": " + e.getMessage());
        }
    }

    private void createSecureDirectory(Path directory) throws IOException {
        if (!Files.exists(directory, new LinkOption[0])) {
            try {
                Files.createDirectories(directory, PosixFilePermissions.asFileAttribute(SECURE_DIR_PERMISSIONS));
            }
            catch (UnsupportedOperationException e) {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
        }
    }

    static String sanitizeFileName(@Nullable String fileName) {
        if (fileName == null) {
            return "unknown";
        }
        return fileName.replaceAll("[^a-zA-Z0-9._-]", "_").replaceAll("^\\.", "_");
    }
}

