/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.cds.impl.repository;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.mulesoft.connectivity.cds.model.ContentDocumentModel;
import com.mulesoft.connectivity.cds.repository.ContentDocumentRepositoryInterface;
import com.mulesoft.connectivity.cds.repository.ContentDocumentStorageException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

public class FileBasedContentDocumentRepository
implements ContentDocumentRepositoryInterface {
    private static final Path BASE_STORAGE_DIRECTORY = Path.of(System.getProperty("java.io.tmpdir"), "content-documents");
    private static final Set<PosixFilePermission> SECURE_DIR_PERMISSIONS = PosixFilePermissions.fromString("rwx------");
    private static final FileBasedContentDocumentRepository INSTANCE = new FileBasedContentDocumentRepository();
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final Map<String, Path> documentPaths = new ConcurrentHashMap<String, Path>();

    private FileBasedContentDocumentRepository() {
    }

    public static FileBasedContentDocumentRepository getInstance() {
        return INSTANCE;
    }

    public String createContentDocument(ContentDocumentModel document, @Nullable InputStream contentStream) {
        String id = UUID.randomUUID().toString();
        try {
            long bytesCopied;
            Path metadataFile;
            Path directory;
            block15: {
                directory = BASE_STORAGE_DIRECTORY.resolve(id);
                this.createSecureDirectory(directory);
                metadataFile = directory.resolve("content-document.json");
                Path dataFilePath = directory.resolve("content");
                bytesCopied = 0L;
                try (OutputStream out = Files.newOutputStream(dataFilePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);){
                    if (contentStream == null) break block15;
                    try (InputStream in = contentStream;){
                        int read;
                        byte[] buffer = new byte[16384];
                        while ((read = in.read(buffer)) != -1) {
                            out.write(buffer, 0, read);
                            bytesCopied += (long)read;
                        }
                    }
                }
            }
            String json = MAPPER.writeValueAsString((Object)new ContentDocumentModel(document.getTitle(), document.getDescription(), Long.valueOf(bytesCopied), document.getFileExtension()));
            Files.writeString(metadataFile, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
            this.documentPaths.put(id, directory);
            return id;
        }
        catch (IOException e) {
            throw new ContentDocumentStorageException("Failed to save document " + String.valueOf(document), (Throwable)e);
        }
    }

    public @Nullable ContentDocumentModel findById(String id) {
        Path path = BASE_STORAGE_DIRECTORY.resolve(id).resolve("content-document.json");
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            String json = Files.readString(path, StandardCharsets.UTF_8);
            return (ContentDocumentModel)MAPPER.readValue(json, ContentDocumentModel.class);
        }
        catch (IOException e) {
            throw new ContentDocumentStorageException("Failed to load document " + id, (Throwable)e);
        }
    }

    public void cleanup() {
        this.documentPaths.values().forEach(dir -> {
            if (Files.isDirectory(dir, new LinkOption[0])) {
                this.deleteDirectoryRecursively((Path)dir);
            }
        });
        this.documentPaths.clear();
    }

    public InputStream openContentStream(String id) {
        try {
            return Files.newInputStream(BASE_STORAGE_DIRECTORY.resolve(id).resolve("content"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ContentDocumentStorageException("Failed to open content stream for document " + id, (Throwable)e);
        }
    }

    private void deleteDirectoryRecursively(Path directory) {
        try (Stream<Path> walk = Files.walk(directory, new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).forEach(this::deletePathSilently);
        }
        catch (IOException e) {
            System.err.println("Warning: Could not walk directory: " + String.valueOf(directory) + ": " + e.getMessage());
        }
    }

    private void deletePathSilently(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            System.err.println("Warning: Could not delete path: " + String.valueOf(path) + ": " + e.getMessage());
        }
    }

    private void createSecureDirectory(Path directory) throws IOException {
        if (Files.exists(directory, new LinkOption[0])) {
            throw new IllegalStateException("id already exists");
        }
        try {
            Files.createDirectories(directory, PosixFilePermissions.asFileAttribute(SECURE_DIR_PERMISSIONS));
        }
        catch (UnsupportedOperationException e) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
    }
}

