/*
 * Copyright (c) 2025, Salesforce, Inc.,
 * All rights reserved.
 * For full license text, see the LICENSE.txt file
 */
%dw 2.9
import * from dw::javaplain::Functions

type ContentDocumentRef = {
    id: String,
    title?: String,
    description?: String,
    size?: Number,
    fileExtension?: String
}

type ContentDocument = ContentDocumentRef & {
    content: Binary
}

// Note: content is always streamed separately via getContentFromDocument(id)

var moduleFQN = "com::mulesoft::connectivity::cds::api::ContentDocumentService"

fun createContentDocument(title: String | Null, description: String | Null, content: Binary): ContentDocumentRef = do {
    invoke<ContentDocumentRef>(moduleFQN, "createContentDocument", [title, description, content])
}

fun getContentFromDocument(id: String): Binary = do {
     invoke<Binary>(moduleFQN, "getContentFromDocument", [id])
}
