/*
 * Copyright (c) 2025, Salesforce, Inc.,
 * All rights reserved.
 * For full license text, see the LICENSE.txt file
 */
/**
* Support functions for "transformed operations"
*/
%dw 2.8
import * from com::mulesoft::connectivity::cds::api::ContentDocumentService

fun getFileName(headerValue: String): String | Null =
  scan(headerValue, /.*filename\*=UTF-8''([^;]+)/)[0][1]

fun extractFileFromResponseBody(response: Object): ContentDocumentRef = createContentDocument(getFileName(response.headers."Content-Disposition"),
 "File handled by Connectivity Content Document Service", response.body!)