/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.cds.function;

import com.mulesoft.connectivity.cds.function.AbstractContentDocumentFunction;
import com.mulesoft.connectivity.cds.model.ContentDocumentModel;
import com.mulesoft.connectivity.cds.repository.ContentDocumentRepositoryInterface;
import com.mulesoft.connectivity.cds.utils.ServiceUtils;
import java.io.InputStream;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.module.javaplain.api.contribution.JavaPlainBasedFunctionResult;
import org.mule.weave.v2.module.javaplain.api.contribution.ServiceProvider;

public class CreateContentDocumentFunction
extends AbstractContentDocumentFunction {
    private static final String FUNCTION_NAME = "createContentDocument";

    public static CreateContentDocumentFunction getInstance() {
        return new CreateContentDocumentFunction();
    }

    public JavaPlainBasedFunctionResult call(@Nullable Object @Nullable [] args, ServiceProvider serviceProvider) {
        Object contentArg;
        Object titleArg;
        Object object = titleArg = args != null && args.length > 0 ? args[0] : null;
        if (titleArg != null && !(titleArg instanceof String)) {
            throw new IllegalArgumentException("Parameter 'title' must be a String");
        }
        if (args != null && args.length > 1 && args[1] != null && !(args[1] instanceof String)) {
            throw new IllegalArgumentException("Parameter 'description' must be a String or null");
        }
        String title = (String)titleArg;
        String description = args != null && args.length > 1 && args[1] != null ? (String)args[1] : null;
        Object object2 = contentArg = args != null && args.length > 2 ? args[2] : null;
        if (!(contentArg instanceof InputStream)) {
            throw new IllegalArgumentException("Parameter 'content' must be Binary/InputStream");
        }
        InputStream contentStream = (InputStream)contentArg;
        ContentDocumentModel document = new ContentDocumentModel(title, description);
        ContentDocumentRepositoryInterface service = ServiceUtils.lookupService(serviceProvider, ContentDocumentRepositoryInterface.class);
        String id = service.createContentDocument(document, contentStream);
        return () -> id;
    }

    public String functionName() {
        return FUNCTION_NAME;
    }
}

