/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.cds.function;

import com.mulesoft.connectivity.cds.function.AbstractContentDocumentFunction;
import com.mulesoft.connectivity.cds.model.ContentDocumentModel;
import com.mulesoft.connectivity.cds.repository.ContentDocumentRepositoryInterface;
import com.mulesoft.connectivity.cds.utils.ServiceUtils;
import java.util.HashMap;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.module.javaplain.api.contribution.JavaPlainBasedFunctionResult;
import org.mule.weave.v2.module.javaplain.api.contribution.ServiceProvider;

public class GetContentDocumentFunction
extends AbstractContentDocumentFunction {
    private static final String FUNCTION_NAME = "getContentDocument";

    public static GetContentDocumentFunction getInstance() {
        return new GetContentDocumentFunction();
    }

    public JavaPlainBasedFunctionResult call(@Nullable Object @Nullable [] args, ServiceProvider serviceProvider) {
        if (args == null || args.length == 0 || args[0] == null) {
            throw new IllegalArgumentException("Parameter 'id' (String) is required");
        }
        String id = args[0].toString();
        ContentDocumentRepositoryInterface service = ServiceUtils.lookupService(serviceProvider, ContentDocumentRepositoryInterface.class);
        ContentDocumentModel document = service.findById(id);
        if (document == null) {
            throw new IllegalArgumentException("Document not found: " + id);
        }
        return () -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (document.getTitle() != null) {
                map.put("title", document.getTitle());
            }
            if (document.getDescription() != null) {
                map.put("description", document.getDescription());
            }
            if (document.getSize() != null) {
                map.put("size", document.getSize());
            }
            if (document.getFileExtension() != null) {
                map.put("fileExtension", document.getFileExtension());
            }
            map.put("content", service.openContentStream(id));
            return map;
        };
    }

    public String functionName() {
        return FUNCTION_NAME;
    }
}

