/*
 * Copyright (c) 2025, Salesforce, Inc.,
 * All rights reserved.
 * For full license text, see the LICENSE.txt file
 */
/**
* Support functions for "transformed operations"
*/
%dw 2.8
import * from com::mulesoft::connectivity::cds::api::ContentDocumentService

fun getFileName(headerValue: String | Null): String | Null =
  if (headerValue == null) null else scan(headerValue, /.*filename\*=UTF-8''([^;]+)/)[0][1]

fun extractFileFromResponseBody(response: {headers: {"Content-Disposition"?: String}, body: Binary}): ContentDocumentMetadata & {id: ContentDocumentId} = do {
  var fileName = getFileName(response.headers."Content-Disposition")  default "unnamed"
  var description = "File handled by Connectivity Content Document Service"
  ---
  {
    id: createContentDocument(fileName, description, response.body! as Binary),
    fileName: fileName,
    description: description
  }
 }
